/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.CharFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;

public class CharConstant
extends CharFunction
implements ConstantFunction {
    public static final CharConstant ZERO = new CharConstant('\u0000');
    private final Utf8String utf8Value;
    private final char value;

    public CharConstant(char value) {
        this.value = value;
        this.utf8Value = value != '\u0000' ? new Utf8String(value) : null;
    }

    public static CharConstant newInstance(char value) {
        return value != '\u0000' ? new CharConstant(value) : ZERO;
    }

    @Override
    public char getChar(Record rec) {
        return this.value;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        return this.utf8Value;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.utf8Value;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val('\'').val(this.value).val('\'');
    }
}

