/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8e)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToShortFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public short getShort(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            try {
                if (value == null) {
                    return 0;
                }
                return (short)Numbers.parseInt(value);
            }
            catch (NumericException e) {
                return 0;
            }
        }
    }
}

