/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToFloatFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToFloatFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Df)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastDoubleToFloatFunction(args.getQuick(0));
    }

    public static class CastDoubleToFloatFunction
    extends AbstractCastToFloatFunction {
        public CastDoubleToFloatFunction(Function arg) {
            super(arg);
        }

        @Override
        public float getFloat(Record rec) {
            double value = this.arg.getDouble(rec);
            return Numbers.isNull(value) || value > 3.4028234663852886E38 || value < -3.4028234663852886E38 ? Float.NaN : (float)value;
        }
    }
}

