/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Utf8SequenceHashSet;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class AllNotEqVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<>all(\u00d8w)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        FunctionExtension arrayFunction = args.getQuick(1).extendedOps();
        int arraySize = arrayFunction.getArrayLength();
        if (arraySize == 0) {
            return BooleanConstant.TRUE;
        }
        Utf8SequenceHashSet set = new Utf8SequenceHashSet();
        Utf8StringSink sink = Misc.getThreadLocalUtf8Sink();
        for (int i = 0; i < arraySize; ++i) {
            sink.clear();
            sink.put(arrayFunction.getStrA(null, i));
            set.add(sink);
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            Utf8Sequence str = var.getVarcharA(null);
            return BooleanConstant.of(str != null && set.excludes(str));
        }
        return new AllNotEqualVarcharFunction(var, set);
    }

    private static class AllNotEqualVarcharFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final Utf8SequenceHashSet set;

        private AllNotEqualVarcharFunction(Function arg, Utf8SequenceHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence str = this.arg.getVarcharA(rec);
            return str != null && this.set.excludes(str);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" <> all ").val(this.set);
        }
    }
}

