/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.AbstractPartitionFrameCursorFactory;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.FullPartitionFrameCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IntervalPartitionFrameCursorFactory;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.map.RecordValueSinkFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.SingleSymbolFilter;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.PriorityMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlHints;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.WhereClauseParser;
import io.questdb.griffin.WhereClauseSymbolEstimator;
import io.questdb.griffin.engine.EmptyTableRecordCursorFactory;
import io.questdb.griffin.engine.ExplainPlanFactory;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.griffin.engine.LimitRecordCursorFactory;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.cast.CastByteToCharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleArrayToDoubleArrayFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleArrayToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleArrayToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToDoubleArray;
import io.questdb.griffin.engine.functions.cast.CastDoubleToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastGeoHashToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIPv4ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIPv4ToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntervalToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastSymbolToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastSymbolToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.columns.ArrayColumn;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IPv4Column;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.IntervalColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.columns.UuidColumn;
import io.questdb.griffin.engine.functions.columns.VarcharColumn;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.groupby.CountRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctTimeSeriesRecordCursorFactory;
import io.questdb.griffin.engine.groupby.FillRangeRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFirstLastRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByInterpolateRecordCursorFactory;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.groupby.vect.AvgDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgShortVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.KSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxShortVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinShortVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.NSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLong256VectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumShortVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunctionConstructor;
import io.questdb.griffin.engine.join.AsOfJoinFastRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinLightNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinNoKeyFastRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.ChainedSymbolShortCircuit;
import io.questdb.griffin.engine.join.CrossJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.DisabledSymbolShortCircuit;
import io.questdb.griffin.engine.join.FilteredAsOfJoinFastRecordCursorFactory;
import io.questdb.griffin.engine.join.FilteredAsOfJoinNoKeyFastRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinFilteredLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinFilteredRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LtJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinNoKeyFastRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NestedLoopLeftJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.RecordAsAFieldRecordCursorFactory;
import io.questdb.griffin.engine.join.SingleStringSymbolShortCircuit;
import io.questdb.griffin.engine.join.SingleSymbolSymbolShortCircuit;
import io.questdb.griffin.engine.join.SingleVarcharSymbolShortCircuit;
import io.questdb.griffin.engine.join.SpliceJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.SymbolShortCircuit;
import io.questdb.griffin.engine.orderby.LimitedSizeSortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.LongSortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.LongTopKRecordCursorFactory;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncGroupByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncGroupByRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncJitFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncTopKRecordCursorFactory;
import io.questdb.griffin.engine.table.DeferredSingleSymbolFilterPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FilterOnExcludedValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnSubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllSymbolsFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByDeferredListValuesFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByLightRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestBySubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.PageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.PageFrameRowCursorFactory;
import io.questdb.griffin.engine.table.SelectedRecordCursorFactory;
import io.questdb.griffin.engine.table.SortedSymbolIndexRecordCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.VirtualRecordCursorFactory;
import io.questdb.griffin.engine.union.ExceptAllRecordCursorFactory;
import io.questdb.griffin.engine.union.ExceptRecordCursorFactory;
import io.questdb.griffin.engine.union.IntersectAllRecordCursorFactory;
import io.questdb.griffin.engine.union.IntersectRecordCursorFactory;
import io.questdb.griffin.engine.union.SetRecordCursorFactoryConstructor;
import io.questdb.griffin.engine.union.UnionAllRecordCursorFactory;
import io.questdb.griffin.engine.union.UnionRecordCursorFactory;
import io.questdb.griffin.engine.window.CachedWindowRecordCursorFactory;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.griffin.engine.window.WindowRecordCursorFactory;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExplainModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.griffin.model.WindowColumn;
import io.questdb.jit.CompiledFilter;
import io.questdb.jit.CompiledFilterIRSerializer;
import io.questdb.jit.JitUtil;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BitSet;
import io.questdb.std.BufferWindowCharSequence;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LongList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.ObjectPool;
import java.io.Closeable;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeGenerator
implements Mutable,
Closeable {
    public static final int GKK_HOUR_INT = 1;
    public static final int GKK_VANILLA_INT = 0;
    private static final VectorAggregateFunctionConstructor COUNT_CONSTRUCTOR = (keyKind, columnIndex, workerCount) -> new CountVectorAggregateFunction(keyKind);
    private static final FullFatJoinGenerator CREATE_FULL_FAT_AS_OF_JOIN = SqlCodeGenerator::createFullFatAsOfJoin;
    private static final FullFatJoinGenerator CREATE_FULL_FAT_LT_JOIN = SqlCodeGenerator::createFullFatLtJoin;
    private static final Log LOG = LogFactory.getLog(SqlCodeGenerator.class);
    private static final ModelOperator RESTORE_WHERE_CLAUSE = QueryModel::restoreWhereClause;
    private static final SetRecordCursorFactoryConstructor SET_EXCEPT_ALL_CONSTRUCTOR = ExceptAllRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_EXCEPT_CONSTRUCTOR = ExceptRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_INTERSECT_ALL_CONSTRUCTOR = IntersectAllRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_INTERSECT_CONSTRUCTOR = IntersectRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_UNION_CONSTRUCTOR = UnionRecordCursorFactory::new;
    private static final int[][] UNION_CAST_MATRIX = new int[][]{{0, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 0}, {11, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 1}, {11, 11, 2, 3, 11, 5, 6, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 2}, {11, 11, 3, 3, 3, 5, 6, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 3}, {11, 11, 11, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 11}, {11, 11, 5, 5, 5, 5, 6, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 5}, {11, 11, 6, 6, 6, 6, 6, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 6}, {11, 11, 7, 7, 7, 7, 7, 7, 8, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 7}, {11, 11, 8, 8, 8, 8, 8, 8, 8, 9, 10, 11, 8, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 8}, {11, 11, 9, 9, 9, 9, 9, 9, 9, 9, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 9}, {11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 10}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {11, 11, 11, 11, 11, 11, 11, 11, 8, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 11}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 13}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 18, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 18}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 19, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 19}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 20, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 20}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 21, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 21}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 22, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11, 22}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 23, 11, 11, 26, 11, 11, 11, 11, 11, 11, 23}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 24, 11, 26, 11, 11, 11, 11, 11, 11, 24}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 25, 26, 11, 11, 11, 11, 11, 11, 25}, {26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 11, 26, 26, -1, -1, -1, -1, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 27, 11, 11, 11, 11, 11, 27}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 28, 11, 11, 11, 11, 28}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 29, 11, 11, 11, 29}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 30, 11, 11, 30}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 31, 11, 31}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 32, 32}, {0, 1, 2, 3, 11, 5, 6, 7, 8, 9, 10, 11, 11, 13, -1, -1, -1, -1, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33}};
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> avgConstructors = new IntObjHashMap();
    private static final ModelOperator backupWhereClauseRef = QueryModel::backupWhereClause;
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> countConstructors = new IntObjHashMap();
    private static final boolean[] joinsRequiringTimestamp = new boolean[9];
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> ksumConstructors = new IntObjHashMap();
    private static final IntHashSet limitTypes = new IntHashSet();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> maxConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> minConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> nsumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> sumConstructors = new IntObjHashMap();
    public static boolean ALLOW_FUNCTION_MEMOIZATION = true;
    private final ArrayColumnTypes arrayColumnTypes = new ArrayColumnTypes();
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final CairoConfiguration configuration;
    private final ObjList<TableColumnMetadata> deferredWindowMetadata = new ObjList();
    private final boolean enableJitDebug;
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final boolean fastAsOfJoins;
    private final FunctionParser functionParser;
    private final IntList groupByFunctionPositions = new IntList();
    private final ObjObjHashMap<IntList, ObjList<WindowFunction>> groupedWindow = new ObjObjHashMap();
    private final IntHashSet intHashSet = new IntHashSet();
    private final ObjectPool<IntList> intListPool = new ObjectPool<IntList>(IntList::new, 4);
    private final MemoryCARW jitIRMem;
    private final CompiledFilterIRSerializer jitIRSerializer = new CompiledFilterIRSerializer();
    private final ArrayColumnTypes keyTypes = new ArrayColumnTypes();
    private final ListColumnFilter listColumnFilterA = new ListColumnFilter();
    private final ListColumnFilter listColumnFilterB = new ListColumnFilter();
    private final LongList prefixes = new LongList();
    private final RecordComparatorCompiler recordComparatorCompiler;
    private final IntList recordFunctionPositions = new IntList();
    private final PageFrameReduceTaskFactory reduceTaskFactory;
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final WhereClauseSymbolEstimator symbolEstimator = new WhereClauseSymbolEstimator();
    private final IntList tempAggIndex = new IntList();
    private final ObjList<QueryColumn> tempColumnsList = new ObjList();
    private final ObjList<ExpressionNode> tempExpressionNodeList = new ObjList();
    private final IntList tempKeyIndex = new IntList();
    private final IntList tempKeyIndexesInBase = new IntList();
    private final IntList tempKeyKinds = new IntList();
    private final GenericRecordMetadata tempMetadata = new GenericRecordMetadata();
    private final IntList tempSymbolSkewIndexes = new IntList();
    private final ObjList<VectorAggregateFunction> tempVaf = new ObjList();
    private final IntList tempVecConstructorArgIndexes = new IntList();
    private final ObjList<VectorAggregateFunctionConstructor> tempVecConstructors = new ObjList();
    private final boolean validateSampleByFillType;
    private final ArrayColumnTypes valueTypes = new ArrayColumnTypes();
    private final WhereClauseParser whereClauseParser = new WhereClauseParser();
    private final BitSet writeStringAsVarcharA = new BitSet();
    private final BitSet writeStringAsVarcharB = new BitSet();
    private final BitSet writeSymbolAsString = new BitSet();
    private boolean enableJitNullChecks = true;
    private boolean fullFatJoins = false;

    public SqlCodeGenerator(CairoConfiguration configuration, FunctionParser functionParser, ObjectPool<ExpressionNode> expressionNodePool) {
        try {
            this.configuration = configuration;
            this.functionParser = functionParser;
            this.recordComparatorCompiler = new RecordComparatorCompiler(this.asm);
            this.enableJitDebug = configuration.isSqlJitDebugEnabled();
            this.jitIRMem = Vm.getCARWInstance(configuration.getSqlJitIRMemoryPageSize(), configuration.getSqlJitIRMemoryMaxPages(), 54);
            this.jitIRMem.putByte((byte)0);
            this.jitIRMem.truncate();
            this.expressionNodePool = expressionNodePool;
            this.reduceTaskFactory = () -> new PageFrameReduceTask(configuration, 54);
            this.fastAsOfJoins = configuration.useFastAsOfJoin();
            this.validateSampleByFillType = configuration.isValidateSampleByFillType();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static int[][] actualUnionCastMatrix() {
        return UNION_CAST_MATRIX;
    }

    public static int[][] expectedUnionCastMatrix() {
        int[][] expected = new int[34][34];
        for (short typeA = 0; typeA <= 33; typeA = (short)((short)(typeA + 1))) {
            for (short typeB = 0; typeB <= 33; typeB = (short)(typeB + 1)) {
                int outType;
                expected[typeA][typeB] = outType = ColumnType.isGeoType(typeA) || ColumnType.isGeoType(typeB) ? -1 : (int)ColumnType.commonWideningType(typeA, typeB);
            }
        }
        return expected;
    }

    public static int getUnionCastType(int typeA, int typeB) {
        boolean isGeoHashB;
        boolean bIsArray;
        short tagA = ColumnType.tagOf(typeA);
        short tagB = ColumnType.tagOf(typeB);
        boolean aIsArray = tagA == 27;
        boolean bl = bIsArray = tagB == 27;
        if (aIsArray && bIsArray) {
            short elementTypeA = ColumnType.decodeArrayElementType(typeA);
            if (elementTypeA != ColumnType.decodeArrayElementType(typeB)) {
                return 26;
            }
            return ColumnType.encodeArrayType(elementTypeA, Math.max(ColumnType.decodeArrayDimensionality(typeA), ColumnType.decodeArrayDimensionality(typeB)));
        }
        if (aIsArray) {
            if (tagB == 10) {
                return typeA;
            }
            return tagB == 11 ? 11 : 26;
        }
        if (bIsArray) {
            if (tagA == 10) {
                return typeB;
            }
            return tagA == 11 ? 11 : 26;
        }
        int geoBitsA = ColumnType.getGeoHashBits(typeA);
        int geoBitsB = ColumnType.getGeoHashBits(typeB);
        boolean isGeoHashA = geoBitsA != 0;
        boolean bl2 = isGeoHashB = geoBitsB != 0;
        if (isGeoHashA != isGeoHashB) {
            return ColumnType.isStringyType(typeA) ? typeB : (ColumnType.isStringyType(typeB) ? typeA : 11);
        }
        if (isGeoHashA) {
            return geoBitsA < geoBitsB ? typeA : typeB;
        }
        return UNION_CAST_MATRIX[tagA][tagB];
    }

    @Override
    public void clear() {
        this.whereClauseParser.clear();
        this.symbolEstimator.clear();
        this.intListPool.clear();
    }

    @Override
    public void close() {
        Misc.free(this.jitIRMem);
    }

    @NotNull
    public Function compileBooleanFilter(ExpressionNode expr, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        Function filter = this.functionParser.parseFunction(expr, metadata, executionContext);
        if (ColumnType.isBoolean(filter.getType())) {
            return filter;
        }
        Misc.free(filter);
        throw SqlException.$(expr.position, "boolean expression expected");
    }

    @NotNull
    public Function compileJoinFilter(ExpressionNode expr, JoinRecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        try {
            return this.compileBooleanFilter(expr, metadata, executionContext);
        }
        catch (Throwable t) {
            Misc.free(metadata);
            throw t;
        }
    }

    public RecordCursorFactory generate(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.generateQuery(model, executionContext, true);
    }

    public RecordCursorFactory generateExplain(ExplainModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factory;
        ExecutionModel innerModel = model.getInnerExecutionModel();
        QueryModel queryModel = innerModel.getQueryModel();
        if (queryModel != null) {
            factory = this.generate(queryModel, executionContext);
            if (innerModel.getModelType() != 1) {
                factory = new RecordCursorFactoryStub(innerModel, factory);
            }
        } else {
            factory = new RecordCursorFactoryStub(innerModel, null);
        }
        return new ExplainPlanFactory(factory, model.getFormat());
    }

    public RecordCursorFactory generateExplain(QueryModel model, RecordCursorFactory factory, int format) {
        RecordCursorFactoryStub recordCursorFactory = new RecordCursorFactoryStub(model, factory);
        return new ExplainPlanFactory(recordCursorFactory, format);
    }

    public BytecodeAssembler getAsm() {
        return this.asm;
    }

    public EntityColumnFilter getEntityColumnFilter() {
        return this.entityColumnFilter;
    }

    public ListColumnFilter getIndexColumnFilter() {
        return this.listColumnFilterA;
    }

    public RecordComparatorCompiler getRecordComparatorCompiler() {
        return this.recordComparatorCompiler;
    }

    public IntList toOrderIndices(RecordMetadata m, ObjList<ExpressionNode> orderBy, IntList orderByDirection) throws SqlException {
        IntList indices = this.intListPool.next();
        int n = orderBy.size();
        for (int i = 0; i < n; ++i) {
            ExpressionNode tok = orderBy.getQuick(i);
            int index = m.getColumnIndexQuiet(tok.token);
            if (index == -1) {
                throw SqlException.invalidColumn(tok.position, tok.token);
            }
            ++index;
            if (orderByDirection.getQuick(i) == 1) {
                index = -index;
            }
            indices.add(index);
        }
        return indices;
    }

    private static boolean allGroupsFirstLastWithSingleSymbolFilter(QueryModel model, RecordMetadata metadata) {
        ObjList<QueryColumn> columns = model.getColumns();
        CharSequence symbolToken = null;
        int timestampIdx = metadata.getTimestampIndex();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 7) {
                int idx = metadata.getColumnIndex(node.token);
                int columnType = metadata.getColumnType(idx);
                if (columnType == 8) {
                    if (idx == timestampIdx) continue;
                    return false;
                }
                if (columnType == 12) {
                    if (symbolToken == null) {
                        symbolToken = node.token;
                        continue;
                    }
                    if (Chars.equalsIgnoreCase(symbolToken, node.token)) continue;
                    return false;
                }
                return false;
            }
            ExpressionNode columnAst = column.getAst();
            CharSequence token = columnAst.token;
            if (!SqlKeywords.isFirstKeyword(token) && !SqlKeywords.isLastKeyword(token)) {
                return false;
            }
            if (columnAst.rhs.type == 7 && metadata.getColumnIndex(columnAst.rhs.token) >= 0) continue;
            return false;
        }
        return true;
    }

    private static void coerceRuntimeConstantType(Function func, short type, SqlExecutionContext context, CharSequence message, int pos) throws SqlException {
        if (ColumnType.isUndefined(func.getType())) {
            func.assignType(type, context.getBindVariableService());
        } else if (!func.isConstant() && !func.isRuntimeConstant() || !ColumnType.isAssignableFrom(func.getType(), type)) {
            throw SqlException.$(pos, message);
        }
    }

    private static RecordCursorFactory createFullFatAsOfJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex, JoinContext joinContext, ColumnFilter masterTableKeyColumns, long toleranceInterval, int slaveValueTimestampIndex) {
        return new AsOfJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex, joinContext, masterTableKeyColumns, toleranceInterval, slaveValueTimestampIndex);
    }

    private static RecordCursorFactory createFullFatLtJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex, JoinContext joinContext, ColumnFilter masterTableKeyColumns, long toleranceInterval, int slaveValueTimestampIndex) {
        return new LtJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex, joinContext, masterTableKeyColumns, toleranceInterval, slaveValueTimestampIndex);
    }

    @Nullable
    private static <T extends Function> ObjList<ObjList<T>> extractWorkerFunctionsConditionally(ObjList<Function> projectionFunctions, IntList projectionFunctionFlags, ObjList<ObjList<Function>> perThreadFunctions, int flag) {
        int i;
        ObjList perThreadKeyFunctions = null;
        boolean keysThreadSafe = true;
        int n = projectionFunctions.size();
        for (i = 0; i < n; ++i) {
            if (flag != -1 && projectionFunctionFlags.get(i) != flag || projectionFunctions.getQuick(i).isThreadSafe()) continue;
            keysThreadSafe = false;
            break;
        }
        if (!keysThreadSafe) {
            assert (perThreadFunctions != null);
            perThreadKeyFunctions = new ObjList();
            n = perThreadFunctions.size();
            for (i = 0; i < n; ++i) {
                ObjList<Function> threadFunctions = new ObjList<Function>();
                perThreadKeyFunctions.add(threadFunctions);
                ObjList<Function> funcs = perThreadFunctions.getQuick(i);
                int m = funcs.size();
                for (int j = 0; j < m; ++j) {
                    if (flag != -1 && projectionFunctionFlags.get(j) != flag) continue;
                    threadFunctions.add(funcs.getQuick(j));
                }
            }
        }
        return perThreadKeyFunctions;
    }

    private static int getOrderByDirectionOrDefault(QueryModel model, int index) {
        IntList direction = model.getOrderByDirectionAdvice();
        return index >= direction.size() ? 0 : direction.getQuick(index);
    }

    private static boolean isSingleColumnFunction(ExpressionNode ast, CharSequence name) {
        return ast.type == 6 && ast.paramCount == 1 && Chars.equalsIgnoreCase(ast.token, name) && ast.rhs.type == 7;
    }

    private static long tolerance(QueryModel slaveModel) throws SqlException {
        ExpressionNode tolerance = slaveModel.getAsOfJoinTolerance();
        long toleranceInterval = Long.MIN_VALUE;
        if (tolerance != null) {
            long multiplier;
            int k = TimestampSamplerFactory.findIntervalEndIndex(tolerance.token, tolerance.position, "tolerance");
            assert (tolerance.token.length() > k);
            char unit = tolerance.token.charAt(k);
            switch (unit) {
                case 'U': {
                    multiplier = 1L;
                    break;
                }
                case 'T': {
                    multiplier = 1000L;
                    break;
                }
                case 's': {
                    multiplier = 1000000L;
                    break;
                }
                case 'm': {
                    multiplier = 60000000L;
                    break;
                }
                case 'h': {
                    multiplier = 3600000000L;
                    break;
                }
                case 'd': {
                    multiplier = 86400000000L;
                    break;
                }
                case 'w': {
                    multiplier = 604800000000L;
                    break;
                }
                default: {
                    throw SqlException.$(tolerance.position, "unsupported TOLERANCE unit [unit=").put(unit).put(']');
                }
            }
            int maxValue = (int)Math.min(Long.MAX_VALUE / multiplier, Integer.MAX_VALUE);
            toleranceInterval = TimestampSamplerFactory.parseInterval(tolerance.token, k, tolerance.position, "tolerance", maxValue, unit);
            toleranceInterval *= multiplier;
        }
        return toleranceInterval;
    }

    private static RecordMetadata widenSetMetadata(RecordMetadata typesA, RecordMetadata typesB) {
        int columnCount = typesA.getColumnCount();
        assert (columnCount == typesB.getColumnCount());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        for (int i = 0; i < columnCount; ++i) {
            int typeA = typesA.getColumnType(i);
            int typeB = typesB.getColumnType(i);
            int targetType = SqlCodeGenerator.getUnionCastType(typeA, typeB);
            metadata.add(new TableColumnMetadata(typesA.getColumnName(i), targetType));
        }
        return metadata;
    }

    private VectorAggregateFunctionConstructor assembleFunctionReference(RecordMetadata metadata, ExpressionNode ast) {
        if (ast.type == 6 && ast.paramCount == 1 && SqlKeywords.isSumKeyword(ast.token) && ast.rhs.type == 7) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return sumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (ast.type == 6 && SqlKeywords.isCountKeyword(ast.token) && (ast.paramCount == 0 || ast.paramCount == 1 && ast.rhs.type == 4 && !SqlKeywords.isNullKeyword(ast.rhs.token))) {
            this.tempVecConstructorArgIndexes.add(-1);
            return COUNT_CONSTRUCTOR;
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "count")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return countConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "ksum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return ksumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "nsum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return nsumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "avg")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return avgConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "min")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return minConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (SqlCodeGenerator.isSingleColumnFunction(ast, "max")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return maxConstructors.get(metadata.getColumnType(columnIndex));
        }
        return null;
    }

    private boolean assembleKeysAndFunctionReferences(ObjList<QueryColumn> columns, RecordMetadata metadata, int hourFunctionIndex) {
        this.tempVaf.clear();
        this.tempMetadata.clear();
        this.tempSymbolSkewIndexes.clear();
        this.tempVecConstructors.clear();
        this.tempVecConstructorArgIndexes.clear();
        this.tempAggIndex.clear();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = columns.getQuick(i);
            ExpressionNode ast = qc.getAst();
            if (ast.type == 7) {
                if (hourFunctionIndex != -1) continue;
                int columnIndex = metadata.getColumnIndex(ast.token);
                int type = metadata.getColumnType(columnIndex);
                if (ColumnType.isInt(type)) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.arrayColumnTypes.add(5);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                if (ColumnType.isSymbol(type)) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.tempSymbolSkewIndexes.extendAndSet(i, columnIndex);
                    this.arrayColumnTypes.add(12);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                return false;
            }
            if (i == hourFunctionIndex) continue;
            VectorAggregateFunctionConstructor constructor = this.assembleFunctionReference(metadata, ast);
            if (constructor != null) {
                this.tempVecConstructors.add(constructor);
                this.tempAggIndex.add(i);
                continue;
            }
            return false;
        }
        return true;
    }

    private void backupWhereClause(ExpressionNode node) {
        this.processNodeQueryModels(node, backupWhereClauseRef);
    }

    private boolean canSortAndLimitBeOptimized(QueryModel model, SqlExecutionContext context, Function loFunc, Function hiFunc) {
        if (model.getLimitLo() == null && model.getLimitHi() == null) {
            return false;
        }
        if (loFunc != null && loFunc.isConstant() && hiFunc != null && hiFunc.isConstant()) {
            try {
                loFunc.init(null, context);
                hiFunc.init(null, context);
                return loFunc.getLong(null) < 0L || hiFunc.getLong(null) >= 0L;
            }
            catch (SqlException ex) {
                LOG.error().$("Failed to initialize lo or hi functions [").$("error=").$safe(ex.getMessage()).I$();
            }
        }
        return true;
    }

    private boolean checkIfSetCastIsRequired(RecordMetadata metadataA, RecordMetadata metadataB, boolean symbolDisallowed) {
        int columnCount = metadataA.getColumnCount();
        assert (columnCount == metadataB.getColumnCount());
        for (int i = 0; i < columnCount; ++i) {
            int typeB;
            int typeA = metadataA.getColumnType(i);
            if (typeA == (typeB = metadataB.getColumnType(i)) && (typeA != 12 || !symbolDisallowed)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Function compileFilter(IntrinsicModel intrinsicModel, RecordMetadata readerMeta, SqlExecutionContext executionContext) throws SqlException {
        if (intrinsicModel.filter != null) {
            return this.compileBooleanFilter(intrinsicModel.filter, readerMeta, executionContext);
        }
        return null;
    }

    @Nullable
    private ObjList<ObjList<Function>> compilePerWorkerInnerProjectionFunctions(SqlExecutionContext executionContext, ObjList<QueryColumn> queryColumns, ObjList<Function> innerProjectionFunctions, int workerCount, RecordMetadata metadata) throws SqlException {
        boolean threadSafe = true;
        assert (innerProjectionFunctions.size() == queryColumns.size());
        int n = innerProjectionFunctions.size();
        for (int i = 0; i < n; ++i) {
            if (innerProjectionFunctions.getQuick(i).isThreadSafe()) continue;
            threadSafe = false;
            break;
        }
        if (!threadSafe) {
            ObjList<ObjList<Function>> allWorkerKeyFunctions = new ObjList<ObjList<Function>>();
            int columnCount = queryColumns.size();
            for (int i = 0; i < workerCount; ++i) {
                ObjList<Function> workerKeyFunctions = new ObjList<Function>(columnCount);
                allWorkerKeyFunctions.add(workerKeyFunctions);
                for (int j = 0; j < columnCount; ++j) {
                    Function func = this.functionParser.parseFunction(queryColumns.getQuick(j).getAst(), metadata, executionContext);
                    if (func instanceof GroupByFunction) {
                        ((GroupByFunction)func).initValueIndex(((GroupByFunction)innerProjectionFunctions.getQuick(j)).getValueIndex());
                    }
                    workerKeyFunctions.add(func);
                }
            }
            return allWorkerKeyFunctions;
        }
        return null;
    }

    @Nullable
    private ObjList<Function> compileWorkerFilterConditionally(SqlExecutionContext executionContext, @Nullable Function filter, int sharedQueryWorkerCount, @Nullable ExpressionNode filterExpr, RecordMetadata metadata) throws SqlException {
        if (filter != null && !filter.isThreadSafe() && sharedQueryWorkerCount > 0) {
            assert (filterExpr != null);
            ObjList<Function> workerFilters = new ObjList<Function>();
            for (int i = 0; i < sharedQueryWorkerCount; ++i) {
                this.restoreWhereClause(filterExpr);
                Function workerFilter = this.compileBooleanFilter(filterExpr, metadata, executionContext);
                workerFilters.extendAndSet(i, workerFilter);
                assert (filter.getClass() == workerFilter.getClass());
            }
            return workerFilters;
        }
        return null;
    }

    @Nullable
    private ObjList<ObjList<GroupByFunction>> compileWorkerGroupByFunctionsConditionally(SqlExecutionContext executionContext, QueryModel model, @NotNull ObjList<GroupByFunction> groupByFunctions, int workerCount, RecordMetadata metadata) throws SqlException {
        boolean threadSafe = true;
        int n = groupByFunctions.size();
        for (int i = 0; i < n; ++i) {
            if (groupByFunctions.getQuick(i).isThreadSafe()) continue;
            threadSafe = false;
            break;
        }
        if (!threadSafe) {
            ObjList<ObjList<GroupByFunction>> allWorkerGroupByFunctions = new ObjList<ObjList<GroupByFunction>>();
            for (int i = 0; i < workerCount; ++i) {
                ObjList<GroupByFunction> workerGroupByFunctions = new ObjList<GroupByFunction>(groupByFunctions.size());
                allWorkerGroupByFunctions.extendAndSet(i, workerGroupByFunctions);
                GroupByUtils.prepareWorkerGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, workerGroupByFunctions);
            }
            return allWorkerGroupByFunctions;
        }
        return null;
    }

    private RecordCursorFactory createAsOfJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit, JoinContext joinContext, long toleranceInterval) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new AsOfJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit, joinContext, toleranceInterval);
    }

    @NotNull
    private RecordCursorFactory createFullFatJoin(RecordCursorFactory master, RecordMetadata masterMetadata, CharSequence masterAlias, RecordCursorFactory slave, RecordMetadata slaveMetadata, CharSequence slaveAlias, int joinPosition, FullFatJoinGenerator generator, JoinContext joinContext, long toleranceInterval) throws SqlException {
        this.intHashSet.clear();
        int n = this.listColumnFilterA.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.intHashSet.add(this.listColumnFilterA.getColumnIndexFactored(i));
        }
        int m = slaveMetadata.getColumnCount();
        for (int k = 0; k < m; ++k) {
            if (!this.intHashSet.excludes(k) || !ColumnType.isVarSize(slaveMetadata.getColumnType(k))) continue;
            throw SqlException.position(joinPosition).put("right side column '").put(slaveMetadata.getColumnName(k)).put("' is of unsupported type");
        }
        RecordSink masterSink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)masterMetadata, (ColumnFilter)this.listColumnFilterB, this.writeSymbolAsString, this.writeStringAsVarcharB);
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        try {
            int i;
            metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
            IntList columnIndex = new IntList(slaveMetadata.getColumnCount());
            ListColumnFilter masterTableKeyColumns = this.listColumnFilterB.copy();
            this.listColumnFilterB.clear();
            this.valueTypes.clear();
            ArrayColumnTypes slaveTypes = new ArrayColumnTypes();
            int slaveTimestampIndex = slaveMetadata.getTimestampIndex();
            int slaveValueTimestampIndex = -1;
            int n2 = slaveMetadata.getColumnCount();
            for (i = 0; i < n2; ++i) {
                if (!this.intHashSet.excludes(i)) continue;
                TableColumnMetadata m2 = slaveMetadata.getColumnMetadata(i);
                metadata.add(slaveAlias, m2);
                this.listColumnFilterB.add(i + 1);
                columnIndex.add(i);
                this.valueTypes.add(m2.getColumnType());
                slaveTypes.add(m2.getColumnType());
                if (i != slaveTimestampIndex) continue;
                slaveValueTimestampIndex = this.valueTypes.getColumnCount() - 1;
            }
            assert (slaveValueTimestampIndex != -1);
            n2 = this.listColumnFilterA.getColumnCount();
            for (i = 0; i < n2; ++i) {
                int index = this.listColumnFilterA.getColumnIndexFactored(i);
                TableColumnMetadata m3 = slaveMetadata.getColumnMetadata(index);
                metadata.add(slaveAlias, m3);
                slaveTypes.add(m3.getColumnType());
                columnIndex.add(index);
            }
            if (masterMetadata.getTimestampIndex() != -1) {
                metadata.setTimestampIndex(masterMetadata.getTimestampIndex());
            }
            return generator.create(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, slaveTypes, masterSink, RecordSinkFactory.getInstance(this.asm, (ColumnTypes)slaveMetadata, (ColumnFilter)this.listColumnFilterA, this.writeSymbolAsString, this.writeStringAsVarcharA), masterMetadata.getColumnCount(), RecordValueSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterB), columnIndex, joinContext, masterTableKeyColumns, toleranceInterval, slaveValueTimestampIndex);
        }
        catch (Throwable e) {
            Misc.free(metadata);
            throw e;
        }
    }

    private RecordCursorFactory createHashJoin(RecordMetadata metadata, RecordCursorFactory master, RecordCursorFactory slave, int joinType, Function filter, JoinContext context) {
        RecordMetadata masterMetadata = master.getMetadata();
        RecordMetadata slaveMetadata = slave.getMetadata();
        RecordSink masterKeySink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)masterMetadata, (ColumnFilter)this.listColumnFilterB, this.writeSymbolAsString, this.writeStringAsVarcharB);
        RecordSink slaveKeySink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)slaveMetadata, (ColumnFilter)this.listColumnFilterA, this.writeSymbolAsString, this.writeStringAsVarcharA);
        if (slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
            this.valueTypes.clear();
            this.valueTypes.add(5);
            if (joinType == 1) {
                this.valueTypes.add(5);
                return new HashJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount(), context);
            }
            if (filter != null) {
                return new HashOuterJoinFilteredLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount(), filter, context);
            }
            return new HashOuterJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount(), context);
        }
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.entityColumnFilter.of(slaveMetadata.getColumnCount());
        RecordSink slaveSink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.entityColumnFilter);
        if (joinType == 1) {
            return new HashJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount(), context);
        }
        if (filter != null) {
            return new HashOuterJoinFilteredRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount(), filter, context);
        }
        return new HashOuterJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount(), context);
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata) {
        return this.createJoinMetadata(masterAlias, masterMetadata, slaveAlias, slaveMetadata, masterMetadata.getTimestampIndex());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata, int timestampIndex) {
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        try {
            metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
            metadata.copyColumnMetadataFrom(slaveAlias, slaveMetadata);
        }
        catch (Throwable th) {
            Misc.free(metadata);
            throw th;
        }
        if (timestampIndex != -1) {
            metadata.setTimestampIndex(timestampIndex);
        }
        return metadata;
    }

    private RecordCursorFactory createLtJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit, JoinContext joinContext, long toleranceInterval) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new LtJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit, joinContext, toleranceInterval);
    }

    private RecordCursorFactory createSpliceJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit, JoinContext context) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new SpliceJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit, context);
    }

    @NotNull
    private SymbolShortCircuit createSymbolShortCircuit(RecordMetadata masterMetadata, RecordMetadata slaveMetadata, boolean selfJoin) {
        SymbolShortCircuit symbolShortCircuit = DisabledSymbolShortCircuit.INSTANCE;
        assert (this.listColumnFilterA.getColumnCount() == this.listColumnFilterB.getColumnCount());
        SymbolShortCircuit[] symbolShortCircuits = null;
        int n = this.listColumnFilterA.getColumnCount();
        block5: for (int i = 0; i < n; ++i) {
            SymbolShortCircuit newSymbolShortCircuit;
            int masterIndex = this.listColumnFilterB.getColumnIndexFactored(i);
            int slaveIndex = this.listColumnFilterA.getColumnIndexFactored(i);
            if (slaveMetadata.getColumnType(slaveIndex) != 12 || !slaveMetadata.isSymbolTableStatic(slaveIndex)) continue;
            int masterColType = masterMetadata.getColumnType(masterIndex);
            switch (masterColType) {
                case 12: {
                    if (selfJoin && masterIndex == slaveIndex) continue block5;
                    newSymbolShortCircuit = new SingleSymbolSymbolShortCircuit(this.configuration, masterIndex, slaveIndex);
                    break;
                }
                case 26: {
                    newSymbolShortCircuit = new SingleVarcharSymbolShortCircuit(masterIndex, slaveIndex);
                    break;
                }
                case 11: {
                    newSymbolShortCircuit = new SingleStringSymbolShortCircuit(masterIndex, slaveIndex);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (symbolShortCircuit == DisabledSymbolShortCircuit.INSTANCE) {
                symbolShortCircuit = newSymbolShortCircuit;
                continue;
            }
            if (symbolShortCircuits == null) {
                symbolShortCircuits = new SymbolShortCircuit[]{symbolShortCircuit, newSymbolShortCircuit};
                symbolShortCircuit = new ChainedSymbolShortCircuit(symbolShortCircuits);
                continue;
            }
            int size = symbolShortCircuits.length;
            SymbolShortCircuit[] newSymbolShortCircuits = new SymbolShortCircuit[size + 1];
            System.arraycopy(symbolShortCircuits, 0, newSymbolShortCircuits, 0, size);
            newSymbolShortCircuits[size] = newSymbolShortCircuit;
            symbolShortCircuit = new ChainedSymbolShortCircuit(newSymbolShortCircuits);
            symbolShortCircuits = newSymbolShortCircuits;
        }
        return symbolShortCircuit;
    }

    @NotNull
    private ObjList<Function> extractVirtualFunctionsFromProjection(ObjList<Function> projectionFunctions, IntList projectionFunctionFlags) {
        ObjList<Function> result = new ObjList<Function>();
        int n = projectionFunctions.size();
        for (int i = 0; i < n; ++i) {
            if (projectionFunctionFlags.getQuick(i) != 1) continue;
            result.add(projectionFunctions.getQuick(i));
        }
        return result;
    }

    private ObjList<Function> generateCastFunctions(RecordMetadata castToMetadata, RecordMetadata castFromMetadata, int modelPosition) throws SqlException {
        int columnCount = castToMetadata.getColumnCount();
        ObjList<Function> castFunctions = new ObjList<Function>();
        block145: for (int i = 0; i < columnCount; ++i) {
            int toType = castToMetadata.getColumnType(i);
            int fromType = castFromMetadata.getColumnType(i);
            short toTag = ColumnType.tagOf(toType);
            short fromTag = ColumnType.tagOf(fromType);
            if (fromTag == 33) {
                castFunctions.add(NullConstant.NULL);
                continue;
            }
            switch (toTag) {
                case 1: {
                    castFunctions.add(BooleanColumn.newInstance(i));
                    continue block145;
                }
                case 2: {
                    castFunctions.add(ByteColumn.newInstance(i));
                    continue block145;
                }
                case 3: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(ByteColumn.newInstance(i));
                            break;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            break;
                        }
                        case 3: {
                            castFunctions.add(ShortColumn.newInstance(i));
                        }
                    }
                    continue block145;
                }
                case 4: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new CastByteToCharFunctionFactory.Func(ByteColumn.newInstance(i)));
                            continue block145;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block145;
                        }
                    }
                    continue block145;
                }
                case 5: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(ByteColumn.newInstance(i));
                            break;
                        }
                        case 3: {
                            castFunctions.add(ShortColumn.newInstance(i));
                            break;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            break;
                        }
                        case 5: {
                            castFunctions.add(IntColumn.newInstance(i));
                        }
                    }
                    continue block145;
                }
                case 25: {
                    if (fromTag == 25) {
                        castFunctions.add(new IPv4Column(i));
                        continue block145;
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 6: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(ByteColumn.newInstance(i));
                            continue block145;
                        }
                        case 3: {
                            castFunctions.add(ShortColumn.newInstance(i));
                            continue block145;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block145;
                        }
                        case 5: {
                            castFunctions.add(IntColumn.newInstance(i));
                            continue block145;
                        }
                        case 6: {
                            castFunctions.add(LongColumn.newInstance(i));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 7: {
                    if (fromTag == 7) {
                        castFunctions.add(DateColumn.newInstance(i));
                        continue block145;
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 19: {
                    assert (fromTag == 19);
                    castFunctions.add(UuidColumn.newInstance(i));
                    continue block145;
                }
                case 8: {
                    switch (fromTag) {
                        case 7: {
                            castFunctions.add(new CastDateToTimestampFunctionFactory.CastDateToTimestampFunction(DateColumn.newInstance(i)));
                            continue block145;
                        }
                        case 8: {
                            castFunctions.add(TimestampColumn.newInstance(i));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 9: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(ByteColumn.newInstance(i));
                            continue block145;
                        }
                        case 3: {
                            castFunctions.add(ShortColumn.newInstance(i));
                            continue block145;
                        }
                        case 5: {
                            castFunctions.add(IntColumn.newInstance(i));
                            continue block145;
                        }
                        case 6: {
                            castFunctions.add(LongColumn.newInstance(i));
                            continue block145;
                        }
                        case 9: {
                            castFunctions.add(FloatColumn.newInstance(i));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 10: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(ByteColumn.newInstance(i));
                            continue block145;
                        }
                        case 3: {
                            castFunctions.add(ShortColumn.newInstance(i));
                            continue block145;
                        }
                        case 5: {
                            castFunctions.add(IntColumn.newInstance(i));
                            continue block145;
                        }
                        case 6: {
                            castFunctions.add(LongColumn.newInstance(i));
                            continue block145;
                        }
                        case 9: {
                            castFunctions.add(FloatColumn.newInstance(i));
                            continue block145;
                        }
                        case 10: {
                            castFunctions.add(DoubleColumn.newInstance(i));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 11: {
                    short arrayType;
                    switch (fromTag) {
                        case 1: {
                            castFunctions.add(BooleanColumn.newInstance(i));
                            break;
                        }
                        case 2: {
                            castFunctions.add(new CastByteToStrFunctionFactory.Func(ByteColumn.newInstance(i)));
                            break;
                        }
                        case 3: {
                            castFunctions.add(new CastShortToStrFunctionFactory.Func(ShortColumn.newInstance(i)));
                            break;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            break;
                        }
                        case 5: {
                            castFunctions.add(new CastIntToStrFunctionFactory.Func(IntColumn.newInstance(i)));
                            break;
                        }
                        case 6: {
                            castFunctions.add(new CastLongToStrFunctionFactory.Func(LongColumn.newInstance(i)));
                            break;
                        }
                        case 7: {
                            castFunctions.add(new CastDateToStrFunctionFactory.Func(DateColumn.newInstance(i)));
                            break;
                        }
                        case 8: {
                            castFunctions.add(new CastTimestampToStrFunctionFactory.Func(TimestampColumn.newInstance(i)));
                            break;
                        }
                        case 9: {
                            castFunctions.add(new CastFloatToStrFunctionFactory.Func(FloatColumn.newInstance(i)));
                            break;
                        }
                        case 10: {
                            castFunctions.add(new CastDoubleToStrFunctionFactory.Func(DoubleColumn.newInstance(i)));
                            break;
                        }
                        case 11: {
                            castFunctions.add(new StrColumn(i));
                            break;
                        }
                        case 26: {
                            castFunctions.add(new VarcharColumn(i));
                            break;
                        }
                        case 19: {
                            castFunctions.add(new CastUuidToStrFunctionFactory.Func(UuidColumn.newInstance(i)));
                            break;
                        }
                        case 12: {
                            castFunctions.add(new CastSymbolToStrFunctionFactory.Func(new SymbolColumn(i, castFromMetadata.isSymbolTableStatic(i))));
                            break;
                        }
                        case 13: {
                            castFunctions.add(new CastLong256ToStrFunctionFactory.Func(Long256Column.newInstance(i)));
                            break;
                        }
                        case 14: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoByteToStrCastFunction(GeoByteColumn.newInstance(i, fromType), ColumnType.getGeoHashBits(fromType)));
                            break;
                        }
                        case 15: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoShortToStrCastFunction(GeoShortColumn.newInstance(i, fromType), ColumnType.getGeoHashBits(fromType)));
                            break;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoIntToStrCastFunction(GeoIntColumn.newInstance(i, fromType), ColumnType.getGeoHashBits(fromType)));
                            break;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoLongToStrCastFunction(GeoLongColumn.newInstance(i, fromType), ColumnType.getGeoHashBits(fromType)));
                            break;
                        }
                        case 32: {
                            castFunctions.add(new CastIntervalToStrFunctionFactory.Func(IntervalColumn.newInstance(i)));
                            break;
                        }
                        case 18: {
                            throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                        }
                        case 27: {
                            arrayType = ColumnType.decodeArrayElementType(fromType);
                            if (arrayType != 10) {
                                throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                            }
                            castFunctions.add(new CastDoubleArrayToStrFunctionFactory.Func(ArrayColumn.newInstance(i, fromType)));
                            break;
                        }
                        case 25: {
                            castFunctions.add(new CastIPv4ToStrFunctionFactory.Func(new IPv4Column(i)));
                        }
                    }
                    continue block145;
                }
                case 12: {
                    castFunctions.add(new CastSymbolToStrFunctionFactory.Func(new SymbolColumn(i, castFromMetadata.isSymbolTableStatic(i))));
                    continue block145;
                }
                case 13: {
                    castFunctions.add(Long256Column.newInstance(i));
                    continue block145;
                }
                case 14: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block145;
                        }
                        case 26: {
                            castFunctions.add(CastVarcharToGeoHashFunctionFactory.newInstance(0, toType, new VarcharColumn(i)));
                            continue block145;
                        }
                        case 14: {
                            castFunctions.add(GeoByteColumn.newInstance(i, fromType));
                            continue block145;
                        }
                        case 15: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoShortColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoIntColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoLongColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 15: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block145;
                        }
                        case 26: {
                            castFunctions.add(CastVarcharToGeoHashFunctionFactory.newInstance(0, toType, new VarcharColumn(i)));
                            continue block145;
                        }
                        case 15: {
                            castFunctions.add(GeoShortColumn.newInstance(i, toType));
                            continue block145;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoIntColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoLongColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 16: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block145;
                        }
                        case 26: {
                            castFunctions.add(CastVarcharToGeoHashFunctionFactory.newInstance(0, toType, new VarcharColumn(i)));
                            continue block145;
                        }
                        case 16: {
                            castFunctions.add(GeoIntColumn.newInstance(i, fromType));
                            continue block145;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, GeoLongColumn.newInstance(i, fromType), toType, fromType));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 17: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block145;
                        }
                        case 26: {
                            castFunctions.add(CastVarcharToGeoHashFunctionFactory.newInstance(0, toType, new VarcharColumn(i)));
                            continue block145;
                        }
                        case 17: {
                            castFunctions.add(GeoLongColumn.newInstance(i, fromType));
                            continue block145;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 18: {
                    castFunctions.add(BinColumn.newInstance(i));
                    continue block145;
                }
                case 26: {
                    short arrayType;
                    switch (fromTag) {
                        case 1: {
                            castFunctions.add(BooleanColumn.newInstance(i));
                            continue block145;
                        }
                        case 2: {
                            castFunctions.add(new CastByteToVarcharFunctionFactory.Func(ByteColumn.newInstance(i)));
                            continue block145;
                        }
                        case 3: {
                            castFunctions.add(new CastShortToVarcharFunctionFactory.Func(ShortColumn.newInstance(i)));
                            continue block145;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block145;
                        }
                        case 5: {
                            castFunctions.add(new CastIntToVarcharFunctionFactory.Func(IntColumn.newInstance(i)));
                            continue block145;
                        }
                        case 6: {
                            castFunctions.add(new CastLongToVarcharFunctionFactory.Func(LongColumn.newInstance(i)));
                            continue block145;
                        }
                        case 7: {
                            castFunctions.add(new CastDateToVarcharFunctionFactory.Func(DateColumn.newInstance(i)));
                            continue block145;
                        }
                        case 8: {
                            castFunctions.add(new CastTimestampToVarcharFunctionFactory.Func(TimestampColumn.newInstance(i)));
                            continue block145;
                        }
                        case 9: {
                            castFunctions.add(new CastFloatToVarcharFunctionFactory.Func(FloatColumn.newInstance(i)));
                            continue block145;
                        }
                        case 10: {
                            castFunctions.add(new CastDoubleToVarcharFunctionFactory.Func(DoubleColumn.newInstance(i)));
                            continue block145;
                        }
                        case 11: {
                            castFunctions.add(new StrColumn(i));
                            continue block145;
                        }
                        case 26: {
                            castFunctions.add(new VarcharColumn(i));
                            continue block145;
                        }
                        case 19: {
                            castFunctions.add(new CastUuidToVarcharFunctionFactory.Func(UuidColumn.newInstance(i)));
                            continue block145;
                        }
                        case 25: {
                            castFunctions.add(new CastIPv4ToVarcharFunctionFactory.Func(new IPv4Column(i)));
                            continue block145;
                        }
                        case 12: {
                            castFunctions.add(new CastSymbolToVarcharFunctionFactory.Func(new SymbolColumn(i, castFromMetadata.isSymbolTableStatic(i))));
                            continue block145;
                        }
                        case 13: {
                            castFunctions.add(new CastLong256ToVarcharFunctionFactory.Func(Long256Column.newInstance(i)));
                            continue block145;
                        }
                        case 14: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoByteToVarcharCastFunction(GeoShortColumn.newInstance(i, toTag), ColumnType.getGeoHashBits(fromType)));
                            continue block145;
                        }
                        case 15: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoShortToVarcharCastFunction(GeoShortColumn.newInstance(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block145;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoIntToVarcharCastFunction(GeoIntColumn.newInstance(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block145;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoLongToVarcharCastFunction(GeoLongColumn.newInstance(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block145;
                        }
                        case 18: {
                            throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                        }
                        case 27: {
                            arrayType = ColumnType.decodeArrayElementType(fromType);
                            if (arrayType != 10) {
                                throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                            }
                            castFunctions.add(new CastDoubleArrayToVarcharFunctionFactory.Func(ArrayColumn.newInstance(i, fromType)));
                            continue block145;
                        }
                    }
                    assert (false);
                    continue block145;
                }
                case 32: {
                    castFunctions.add(IntervalColumn.newInstance(i));
                    continue block145;
                }
                case 27: {
                    switch (fromTag) {
                        case 27: {
                            int toDims;
                            assert (ColumnType.decodeArrayElementType(fromType) == 10);
                            assert (ColumnType.decodeArrayElementType(toType) == 10);
                            int fromDims = ColumnType.decodeArrayDimensionality(fromType);
                            if (fromDims == (toDims = ColumnType.decodeArrayDimensionality(toType))) {
                                castFunctions.add(ArrayColumn.newInstance(i, fromType));
                                continue block145;
                            }
                            assert (fromDims < toDims);
                            castFunctions.add(new CastDoubleArrayToDoubleArrayFunctionFactory.Func(ArrayColumn.newInstance(i, fromType), toType, toDims - fromDims));
                            continue block145;
                        }
                        case 10: {
                            assert (ColumnType.decodeArrayElementType(toType) == 10);
                            castFunctions.add(new CastDoubleToDoubleArray.Func(DoubleColumn.newInstance(i), toType));
                            continue block145;
                        }
                    }
                    assert (false);
                    continue block145;
                }
            }
        }
        return castFunctions;
    }

    private RecordCursorFactory generateFill(QueryModel model, RecordCursorFactory groupByFactory, SqlExecutionContext executionContext) throws SqlException {
        QueryModel curr;
        for (curr = model; curr != null && curr.getFillStride() == null; curr = curr.getNestedModel()) {
        }
        if (curr == null || curr.getFillStride() == null) {
            return groupByFactory;
        }
        ObjList<Function> fillValues = null;
        Function fillFromFunc = TimestampConstant.NULL;
        Function fillToFunc = TimestampConstant.NULL;
        ExpressionNode fillFrom = curr.getFillFrom();
        ExpressionNode fillTo = curr.getFillTo();
        ExpressionNode fillStride = curr.getFillStride();
        ObjList<ExpressionNode> fillValuesExprs = curr.getFillValues();
        try {
            if (fillValuesExprs == null) {
                throw SqlException.$(-1, "fill values were null");
            }
            fillValues = new ObjList<Function>(fillValuesExprs.size());
            int n = fillValuesExprs.size();
            for (int i = 0; i < n; ++i) {
                ExpressionNode expr = fillValuesExprs.getQuick(0);
                if (SqlKeywords.isNoneKeyword(expr.token)) {
                    Misc.freeObjList(fillValues);
                    return groupByFactory;
                }
                Function fillValueFunc = this.functionParser.parseFunction(expr, EmptyRecordMetadata.INSTANCE, executionContext);
                fillValues.add(fillValueFunc);
            }
            if (fillValues.size() == 0 || fillValues.size() == 1 && SqlKeywords.isNoneKeyword(((Function)fillValues.getQuick(0)).getName())) {
                Misc.freeObjList(fillValues);
                return groupByFactory;
            }
            if (fillFrom != null) {
                fillFromFunc = this.functionParser.parseFunction(fillFrom, EmptyRecordMetadata.INSTANCE, executionContext);
                SqlCodeGenerator.coerceRuntimeConstantType(fillFromFunc, (short)8, executionContext, "from lower bound must be a constant expression convertible to a TIMESTAMP", fillFrom.position);
            }
            if (fillTo != null) {
                fillToFunc = this.functionParser.parseFunction(fillTo, EmptyRecordMetadata.INSTANCE, executionContext);
                SqlCodeGenerator.coerceRuntimeConstantType(fillToFunc, (short)8, executionContext, "to upper bound must be a constant expression convertible to a TIMESTAMP", fillTo.position);
            }
            QueryModel temp = model;
            ExpressionNode timestamp = model.getTimestamp();
            while (timestamp == null && temp != null) {
                if ((temp = temp.getNestedModel()) == null) continue;
                timestamp = temp.getTimestamp();
            }
            assert (timestamp != null);
            CharSequence alias = timestamp.token;
            CharSequence currTimestamp = curr.getTimestamp().token;
            int n2 = model.getBottomUpColumns().size();
            for (int i = 0; i < n2; ++i) {
                CharSequence ts;
                QueryColumn col = model.getColumns().getQuick(i);
                ExpressionNode ast = col.getAst();
                if (ast.type != 6 || !Chars.equalsIgnoreCase("timestamp_floor", ast.token)) continue;
                if (ast.paramCount == 3 || ast.paramCount == 5) {
                    int idx = ast.paramCount - 2;
                    ts = ast.args.getQuick((int)idx).token;
                } else {
                    ts = ast.rhs.token;
                }
                if (!Chars.equalsIgnoreCase(ts, currTimestamp)) continue;
                alias = col.getAlias();
            }
            int timestampIndex = groupByFactory.getMetadata().getColumnIndexQuiet(alias);
            int samplingIntervalEnd = TimestampSamplerFactory.findIntervalEndIndex(fillStride.token, fillStride.position, "sample");
            long samplingInterval = TimestampSamplerFactory.parseInterval(fillStride.token, samplingIntervalEnd, fillStride.position, "sample", Integer.MIN_VALUE, ' ');
            assert (samplingInterval > 0L);
            assert (samplingIntervalEnd < fillStride.token.length());
            char samplingIntervalUnit = fillStride.token.charAt(samplingIntervalEnd);
            TimestampSampler timestampSampler = TimestampSamplerFactory.getInstance(samplingInterval, samplingIntervalUnit, fillStride.position);
            return new FillRangeRecordCursorFactory(groupByFactory.getMetadata(), groupByFactory, fillFromFunc, fillToFunc, samplingInterval, samplingIntervalUnit, timestampSampler, fillValues, timestampIndex);
        }
        catch (Throwable e) {
            Misc.freeObjList(fillValues);
            Misc.free(fillFromFunc);
            Misc.free(fillToFunc);
            Misc.free(groupByFactory);
            throw e;
        }
    }

    private RecordCursorFactory generateFilter(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return model.getWhereClause() == null ? factory : this.generateFilter0(factory, model, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private RecordCursorFactory generateFilter0(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        Function filter;
        ExpressionNode filterExpr = model.getWhereClause();
        model.setBackupWhereClause(ExpressionNode.deepClone(this.expressionNodePool, filterExpr));
        this.backupWhereClause(filterExpr);
        model.setWhereClause(null);
        try {
            filter = this.compileBooleanFilter(filterExpr, factory.getMetadata(), executionContext);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        if (filter.isConstant()) {
            try {
                if (filter.getBool(null)) {
                    RecordCursorFactory e = factory;
                    return e;
                }
                RecordMetadata metadata = factory.getMetadata();
                assert (metadata instanceof GenericRecordMetadata);
                Misc.free(factory);
                EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(metadata);
                return emptyTableRecordCursorFactory;
            }
            finally {
                filter.close();
            }
        }
        boolean enableParallelFilter = executionContext.isParallelFilterEnabled();
        if (enableParallelFilter && factory.supportsPageFrameCursor()) {
            boolean canCompile;
            boolean useJit = executionContext.getJitMode() != 2 && (!model.isUpdate() || executionContext.isWalApplication());
            boolean bl = canCompile = factory.supportsPageFrameCursor() && JitUtil.isJitSupported();
            if (useJit && canCompile) {
                CompiledFilter compiledFilter = null;
                try {
                    int jitOptions;
                    ObjList<Function> bindVarFunctions = new ObjList<Function>();
                    try (PageFrameCursor cursor = factory.getPageFrameCursor(executionContext, 2);){
                        boolean forceScalar = executionContext.getJitMode() == 1;
                        this.jitIRSerializer.of(this.jitIRMem, executionContext, factory.getMetadata(), cursor, bindVarFunctions);
                        jitOptions = this.jitIRSerializer.serialize(filterExpr, forceScalar, this.enableJitDebug, this.enableJitNullChecks);
                    }
                    compiledFilter = new CompiledFilter();
                    compiledFilter.compile(this.jitIRMem, jitOptions);
                    Function limitLoFunction = this.getLimitLoFunctionOnly(model, executionContext);
                    int limitLoPos = model.getLimitAdviceLo() != null ? model.getLimitAdviceLo().position : 0;
                    LOG.debug().$("JIT enabled for (sub)query [tableName=").$safe(model.getName()).$(", fd=").$(executionContext.getRequestFd()).I$();
                    AsyncJitFilteredRecordCursorFactory asyncJitFilteredRecordCursorFactory = new AsyncJitFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), factory, bindVarFunctions, compiledFilter, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), filterExpr, factory.getMetadata()), limitLoFunction, limitLoPos, executionContext.getSharedQueryWorkerCount());
                    return asyncJitFilteredRecordCursorFactory;
                }
                catch (SqlException | LimitOverflowException ex) {
                    Misc.free(compiledFilter);
                    LOG.debug().$("JIT cannot be applied to (sub)query [tableName=").$safe(model.getName()).$(", ex=").$safe(((FlyweightMessageContainer)((Object)ex)).getFlyweightMessage()).$(", fd=").$(executionContext.getRequestFd()).$(']').$();
                }
                catch (Throwable t) {
                    Misc.free(compiledFilter);
                    Misc.free(filter);
                    Misc.free(factory);
                    throw t;
                }
                finally {
                    this.jitIRSerializer.clear();
                    this.jitIRMem.truncate();
                }
            }
            try {
                Function limitLoFunction = this.getLimitLoFunctionOnly(model, executionContext);
                int limitLoPos = model.getLimitAdviceLo() != null ? model.getLimitAdviceLo().position : 0;
                return new AsyncFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), factory, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), filterExpr, factory.getMetadata()), limitLoFunction, limitLoPos, executionContext.getSharedQueryWorkerCount());
            }
            catch (Throwable e) {
                Misc.free(filter);
                Misc.free(factory);
                throw e;
            }
        }
        return new FilteredRecordCursorFactory(factory, filter);
    }

    private RecordCursorFactory generateFunctionQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory tableFactory = model.getTableNameFunction();
        if (tableFactory != null) {
            model.setTableNameFunction(null);
            return tableFactory;
        }
        return TableUtils.createCursorFunction(this.functionParser, model, executionContext).getRecordCursorFactory();
    }

    private RecordCursorFactory generateIntersectOrExceptAllFactory(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordMetadata unionMetadata, SetRecordCursorFactoryConstructor constructor) throws SqlException {
        this.writeSymbolAsString.clear();
        this.valueTypes.clear();
        this.keyTypes.clear();
        int n = unionMetadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int columnType = unionMetadata.getColumnType(i);
            if (ColumnType.isSymbol(columnType)) {
                this.keyTypes.add(11);
                this.writeSymbolAsString.set(i);
                continue;
            }
            this.keyTypes.add(columnType);
        }
        this.entityColumnFilter.of(factoryA.getMetadata().getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, unionMetadata, this.entityColumnFilter, this.writeSymbolAsString);
        RecordCursorFactory unionAllFactory = constructor.create(this.configuration, unionMetadata, factoryA, factoryB, castFunctionsA, castFunctionsB, recordSink, this.keyTypes, this.valueTypes);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionAllFactory, executionContext);
        }
        return unionAllFactory;
    }

    /*
     * Unable to fully structure code
     */
    private RecordCursorFactory generateJoins(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        joinModels = model.getJoinModels();
        ordered = model.getOrderedJoinModels();
        joinMetadata = null;
        master = null;
        masterAlias = null;
        try {
            n = ordered.size();
            if (!SqlCodeGenerator.$assertionsDisabled && n <= 1) {
                throw new AssertionError();
            }
            for (i = 0; i < n; ++i) {
                block57: {
                    index = ordered.getQuick(i);
                    slaveModel = joinModels.getQuick(index);
                    if (i > 0) {
                        executionContext.pushTimestampRequiredFlag(SqlCodeGenerator.joinsRequiringTimestamp[slaveModel.getJoinType()]);
                    } else {
                        nextJointType = joinModels.getQuick(ordered.getQuick(1)).getJoinType();
                        executionContext.pushTimestampRequiredFlag(SqlCodeGenerator.joinsRequiringTimestamp[nextJointType]);
                    }
                    slave = null;
                    releaseSlave = true;
                    try {
                        slave = this.generateQuery(slaveModel, executionContext, index > 0);
                        if (master == null) {
                            master = slave;
                            releaseSlave = false;
                            masterAlias = slaveModel.getName();
                            break block57;
                        }
                        joinType = slaveModel.getJoinType();
                        masterMetadata = master.getMetadata();
                        slaveMetadata = slave.getMetadata();
                        filter = null;
                        switch (joinType) {
                            case 8: {
                                if (!SqlCodeGenerator.$assertionsDisabled && slaveModel.getOuterJoinExpressionClause() == null) {
                                    throw new AssertionError();
                                }
                                joinMetadata = this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata);
                                filter = this.compileJoinFilter(slaveModel.getOuterJoinExpressionClause(), joinMetadata, executionContext);
                                master = new NestedLoopLeftJoinRecordCursorFactory(joinMetadata, master, slave, masterMetadata.getColumnCount(), filter, NullRecordFactory.getInstance(slaveMetadata));
                                masterAlias = null;
                                ** break;
lbl40:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                this.validateOuterJoinExpressions(slaveModel, "CROSS");
                                master = new CrossJoinRecordCursorFactory((RecordMetadata)this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount());
                                masterAlias = null;
                                ** break;
lbl46:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.validateOuterJoinExpressions(slaveModel, "ASOF");
                                selfJoin = this.isSameTable(master, slave);
                                this.processJoinContext(index == 1, selfJoin, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                asOfToleranceInterval = SqlCodeGenerator.tolerance(slaveModel);
                                asOfAvoidBinarySearch = SqlHints.hasAvoidAsOfJoinBinarySearchHint(model, masterAlias, slaveModel.getName());
                                if (slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
                                    if (this.isKeyedTemporalJoin(masterMetadata, slaveMetadata)) {
                                        masterSink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)masterMetadata, (ColumnFilter)this.listColumnFilterB, this.writeSymbolAsString, this.writeStringAsVarcharB);
                                        slaveSink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)slaveMetadata, (ColumnFilter)this.listColumnFilterA, this.writeSymbolAsString, this.writeStringAsVarcharA);
                                        created = false;
                                        if (!asOfAvoidBinarySearch) {
                                            if (slave.supportsTimeFrameCursor() && this.fastAsOfJoins) {
                                                symbolShortCircuit = this.createSymbolShortCircuit(masterMetadata, slaveMetadata, selfJoin);
                                                master = new AsOfJoinFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, masterSink, slave, slaveSink, masterMetadata.getColumnCount(), symbolShortCircuit, slaveModel.getContext(), asOfToleranceInterval);
                                                created = true;
                                            }
                                            if (!created && slave.supportsFilterStealing() && slave.getBaseFactory().supportsTimeFrameCursor()) {
                                                slaveBase = slave.getBaseFactory();
                                                slaveTimestampIndex = slaveMetadata.getTimestampIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && slaveBase.getMetadata().getTimestampIndex() != slaveTimestampIndex) {
                                                    throw new AssertionError();
                                                }
                                                stolenFilter = slave.getFilter();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenFilter == null) {
                                                    throw new AssertionError();
                                                }
                                                Misc.free(slave.getCompiledFilter());
                                                Misc.free(slave.getBindVarMemory());
                                                Misc.freeObjList(slave.getBindVarFunctions());
                                                slave.halfClose();
                                                master = new FilteredAsOfJoinFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, masterSink, slaveBase, slaveSink, stolenFilter, masterMetadata.getColumnCount(), NullRecordFactory.getInstance(slaveMetadata), null, slaveTimestampIndex, asOfToleranceInterval);
                                                created = true;
                                            }
                                            if (!created && slave.isProjection() && (projectionBase = slave.getBaseFactory()).supportsFilterStealing() && (filterStealingBase = projectionBase.getBaseFactory()).supportsTimeFrameCursor()) {
                                                stolenCrossIndex = slave.getColumnCrossIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenCrossIndex == null) {
                                                    throw new AssertionError();
                                                }
                                                stolenFilter = projectionBase.getFilter();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenFilter == null) {
                                                    throw new AssertionError();
                                                }
                                                slaveTimestampIndex = slaveMetadata.getTimestampIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenCrossIndex.get(slaveTimestampIndex) != filterStealingBase.getMetadata().getTimestampIndex()) {
                                                    throw new AssertionError();
                                                }
                                                Misc.free(projectionBase.getCompiledFilter());
                                                Misc.free(projectionBase.getBindVarMemory());
                                                Misc.freeObjList(projectionBase.getBindVarFunctions());
                                                projectionBase.halfClose();
                                                master = new FilteredAsOfJoinFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, masterSink, filterStealingBase, slaveSink, stolenFilter, masterMetadata.getColumnCount(), NullRecordFactory.getInstance(slaveMetadata), stolenCrossIndex, slaveTimestampIndex, asOfToleranceInterval);
                                                created = true;
                                            }
                                        }
                                        if (!created) {
                                            master = this.createAsOfJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, masterSink, slave, slaveSink, masterMetadata.getColumnCount(), slaveModel.getContext(), asOfToleranceInterval);
                                        }
                                    } else {
                                        created = false;
                                        if (this.fastAsOfJoins && !asOfAvoidBinarySearch) {
                                            if (slave.supportsTimeFrameCursor()) {
                                                master = new AsOfJoinNoKeyFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount(), asOfToleranceInterval);
                                                created = true;
                                            }
                                            if (!created && slave.supportsFilterStealing() && slave.getBaseFactory().supportsTimeFrameCursor()) {
                                                slaveBase = slave.getBaseFactory();
                                                slaveTimestampIndex = slaveMetadata.getTimestampIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && slaveBase.getMetadata().getTimestampIndex() != slaveTimestampIndex) {
                                                    throw new AssertionError();
                                                }
                                                stolenFilter = slave.getFilter();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenFilter == null) {
                                                    throw new AssertionError();
                                                }
                                                Misc.free(slave.getCompiledFilter());
                                                Misc.free(slave.getBindVarMemory());
                                                Misc.freeObjList(slave.getBindVarFunctions());
                                                slave.halfClose();
                                                master = new FilteredAsOfJoinNoKeyFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slaveBase, stolenFilter, masterMetadata.getColumnCount(), NullRecordFactory.getInstance(slaveMetadata), null, slaveTimestampIndex, asOfToleranceInterval);
                                                created = true;
                                            }
                                            if (!created && slave.isProjection() && (projectionBase = slave.getBaseFactory()).supportsFilterStealing() && (filterStealingBase = projectionBase.getBaseFactory()).supportsTimeFrameCursor()) {
                                                stolenCrossIndex = slave.getColumnCrossIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenCrossIndex == null) {
                                                    throw new AssertionError();
                                                }
                                                stolenFilter = projectionBase.getFilter();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenFilter == null) {
                                                    throw new AssertionError();
                                                }
                                                slaveTimestampIndex = slaveMetadata.getTimestampIndex();
                                                if (!SqlCodeGenerator.$assertionsDisabled && stolenCrossIndex.get(slaveTimestampIndex) != filterStealingBase.getMetadata().getTimestampIndex()) {
                                                    throw new AssertionError();
                                                }
                                                Misc.free(projectionBase.getCompiledFilter());
                                                Misc.free(projectionBase.getBindVarMemory());
                                                Misc.freeObjList(projectionBase.getBindVarFunctions());
                                                projectionBase.halfClose();
                                                master = new FilteredAsOfJoinNoKeyFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, filterStealingBase, stolenFilter, masterMetadata.getColumnCount(), NullRecordFactory.getInstance(slaveMetadata), stolenCrossIndex, slaveTimestampIndex, asOfToleranceInterval);
                                                created = true;
                                            }
                                        }
                                        if (!created) {
                                            master = new AsOfJoinLightNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount(), asOfToleranceInterval);
                                        }
                                    }
                                } else {
                                    master = this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), SqlCodeGenerator.CREATE_FULL_FAT_AS_OF_JOIN, slaveModel.getContext(), asOfToleranceInterval);
                                }
                                masterAlias = null;
                                releaseSlave = false;
                                ** break;
lbl148:
                                // 1 sources

                                break;
                            }
                            case 6: {
                                ltToleranceInterval = SqlCodeGenerator.tolerance(slaveModel);
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.validateOuterJoinExpressions(slaveModel, "LT");
                                ltAvoidBinarySearch = SqlHints.hasAvoidLtJoinBinarySearchHint(model, masterAlias, slaveModel.getName());
                                this.processJoinContext(index == 1, this.isSameTable(master, slave), slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.isKeyedTemporalJoin(masterMetadata, slaveMetadata) ? this.createLtJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, (ColumnTypes)masterMetadata, (ColumnFilter)this.listColumnFilterB, this.writeSymbolAsString, this.writeStringAsVarcharB), slave, RecordSinkFactory.getInstance(this.asm, (ColumnTypes)slaveMetadata, (ColumnFilter)this.listColumnFilterA, this.writeSymbolAsString, this.writeStringAsVarcharA), masterMetadata.getColumnCount(), slaveModel.getContext(), ltToleranceInterval) : (slave.supportsTimeFrameCursor() && !ltAvoidBinarySearch ? new LtJoinNoKeyFastRecordCursorFactory(this.configuration, this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount(), ltToleranceInterval) : new LtJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount(), ltToleranceInterval))) : this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), SqlCodeGenerator.CREATE_FULL_FAT_LT_JOIN, slaveModel.getContext(), ltToleranceInterval);
                                masterAlias = null;
                                releaseSlave = false;
                                this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                ** break;
lbl160:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.validateOuterJoinExpressions(slaveModel, "SPLICE");
                                this.processJoinContext(index == 1, this.isSameTable(master, slave), slaveModel.getContext(), masterMetadata, slaveMetadata);
                                if (slave.recordCursorSupportsRandomAccess() && master.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
                                    master = this.createSpliceJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata, -1), master, RecordSinkFactory.getInstance(this.asm, (ColumnTypes)masterMetadata, (ColumnFilter)this.listColumnFilterB, this.writeSymbolAsString, this.writeStringAsVarcharB), slave, RecordSinkFactory.getInstance(this.asm, (ColumnTypes)slaveMetadata, (ColumnFilter)this.listColumnFilterA, this.writeSymbolAsString, this.writeStringAsVarcharA), masterMetadata.getColumnCount(), slaveModel.getContext());
                                    releaseSlave = false;
                                    this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                    ** break;
lbl170:
                                    // 1 sources

                                    break;
                                }
                                if (!master.recordCursorSupportsRandomAccess()) {
                                    throw SqlException.position(slaveModel.getJoinKeywordPosition()).put("left side of splice join doesn't support random access");
                                }
                                if (!slave.recordCursorSupportsRandomAccess()) {
                                    throw SqlException.position(slaveModel.getJoinKeywordPosition()).put("right side of splice join doesn't support random access");
                                }
                                throw SqlException.position(slaveModel.getJoinKeywordPosition()).put("splice join doesn't support full fat mode");
                            }
                            default: {
                                this.processJoinContext(index == 1, this.isSameTable(master, slave), slaveModel.getContext(), masterMetadata, slaveMetadata);
                                joinMetadata = this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata);
                                if (slaveModel.getOuterJoinExpressionClause() != null) {
                                    filter = this.compileJoinFilter(slaveModel.getOuterJoinExpressionClause(), joinMetadata, executionContext);
                                }
                                if (joinType == 2 && filter != null && filter.isConstant() && !filter.getBool(null)) {
                                    Misc.free(slave);
                                    slave = new EmptyTableRecordCursorFactory(slaveMetadata);
                                }
                                if (joinType == 1) {
                                    this.validateOuterJoinExpressions(slaveModel, "INNER");
                                }
                                master = this.createHashJoin(joinMetadata, master, slave, joinType, filter, slaveModel.getContext());
                                masterAlias = null;
                                break;
                            }
                        }
                    }
                    catch (Throwable th) {
                        Misc.free(joinMetadata);
                        master = Misc.free(master);
                        if (releaseSlave) {
                            Misc.free(slave);
                        }
                        throw th;
                    }
                    finally {
                        executionContext.popTimestampRequiredFlag();
                    }
                }
                filterExpr = slaveModel.getPostJoinWhereClause();
                if (filterExpr == null) continue;
                if (executionContext.isParallelFilterEnabled() && master.supportsPageFrameCursor()) {
                    filter = this.compileJoinFilter(filterExpr, (JoinRecordMetadata)master.getMetadata(), executionContext);
                    master = new AsyncFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), master, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), filterExpr, master.getMetadata()), null, 0, executionContext.getSharedQueryWorkerCount());
                    continue;
                }
                master = new FilteredRecordCursorFactory(master, this.compileJoinFilter(filterExpr, (JoinRecordMetadata)master.getMetadata(), executionContext));
            }
            constFilterExpr = model.getConstWhereClause();
            if (constFilterExpr != null) {
                filter = this.functionParser.parseFunction(constFilterExpr, null, executionContext);
                if (!ColumnType.isBoolean(filter.getType())) {
                    throw SqlException.position(constFilterExpr.position).put("boolean expression expected");
                }
                filter.init(null, executionContext);
                if (filter.isConstant()) {
                    if (!filter.getBool(null)) {
                        metadata = (JoinRecordMetadata)master.getMetadata();
                        metadata.incrementRefCount();
                        factory = new EmptyTableRecordCursorFactory(metadata);
                        Misc.free(master);
                        return factory;
                    }
                } else {
                    master = executionContext.isParallelFilterEnabled() != false && master.supportsPageFrameCursor() != false ? new AsyncFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), master, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), constFilterExpr, master.getMetadata()), null, 0, executionContext.getSharedQueryWorkerCount()) : new FilteredRecordCursorFactory(master, filter);
                }
            }
            return master;
        }
        catch (Throwable e) {
            Misc.free(master);
            throw e;
        }
    }

    @NotNull
    private RecordCursorFactory generateLatestBy(RecordCursorFactory factory, QueryModel model) throws SqlException {
        String timestampColumn;
        int timestampIndex;
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        if (latestBy.size() == 0) {
            return factory;
        }
        try {
            timestampIndex = this.getTimestampIndex(model, factory);
            if (timestampIndex == -1) {
                throw SqlException.$(model.getModelPosition(), "latest by query does not provide dedicated TIMESTAMP column");
            }
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        RecordMetadata metadata = factory.getMetadata();
        this.prepareLatestByColumnIndexes(latestBy, metadata);
        if (!factory.recordCursorSupportsRandomAccess()) {
            return new LatestByRecordCursorFactory(this.configuration, factory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA), this.keyTypes, timestampIndex);
        }
        boolean orderedByTimestampAsc = false;
        QueryModel nested = model.getNestedModel();
        assert (nested != null);
        LowerCaseCharSequenceIntHashMap orderBy = nested.getOrderHash();
        if (orderBy.get(timestampColumn = metadata.getColumnName(timestampIndex)) == 0) {
            orderedByTimestampAsc = true;
        } else if (timestampIndex == metadata.getTimestampIndex() && orderBy.size() == 0) {
            orderedByTimestampAsc = true;
        }
        return new LatestByLightRecordCursorFactory(this.configuration, factory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA), this.keyTypes, timestampIndex, orderedByTimestampAsc);
    }

    @NotNull
    private RecordCursorFactory generateLatestByTableQuery(QueryModel model, TableReader reader, RecordMetadata metadata, TableToken tableToken, IntrinsicModel intrinsicModel, Function filter, SqlExecutionContext executionContext, int timestampIndex, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts, @NotNull LongList prefixes) throws SqlException {
        AbstractPartitionFrameCursorFactory partitionFrameCursorFactory = intrinsicModel.hasIntervalFilters() ? new IntervalPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), intrinsicModel.buildIntervalModel(), timestampIndex, GenericRecordMetadata.deepCopyOf(reader.getMetadata()), 1) : new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), GenericRecordMetadata.deepCopyOf(reader.getMetadata()), 1);
        assert (model.getLatestBy() != null && model.getLatestBy().size() > 0);
        ObjList<ExpressionNode> latestBy = new ObjList<ExpressionNode>(model.getLatestBy().size());
        latestBy.addAll(model.getLatestBy());
        ExpressionNode latestByNode = (ExpressionNode)latestBy.get(0);
        int latestByIndex = metadata.getColumnIndexQuiet(latestByNode.token);
        boolean indexed = metadata.isColumnIndexed(latestByIndex);
        model.setWhereClause(null);
        model.getLatestBy().clear();
        if (latestBy.size() > 1 || !ColumnType.isSymbol(metadata.getColumnType(latestByIndex))) {
            boolean symbolKeysOnly = true;
            int n = this.keyTypes.getColumnCount();
            for (int i = 0; i < n; ++i) {
                symbolKeysOnly &= ColumnType.isSymbol(this.keyTypes.getColumnType(i));
            }
            if (symbolKeysOnly) {
                IntList partitionByColumnIndexes = new IntList(this.listColumnFilterA.size());
                int n2 = this.listColumnFilterA.size();
                for (int i = 0; i < n2; ++i) {
                    partitionByColumnIndexes.add(this.listColumnFilterA.getColumnIndexFactored(i));
                }
                IntList partitionBySymbolCounts = this.symbolEstimator.estimate(model, intrinsicModel.filter, metadata, partitionByColumnIndexes);
                return new LatestByAllSymbolsFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA), this.keyTypes, partitionByColumnIndexes, partitionBySymbolCounts, filter, columnIndexes, columnSizeShifts);
            }
            return new LatestByAllFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA), this.keyTypes, filter, columnIndexes, columnSizeShifts);
        }
        if (intrinsicModel.keyColumn != null) {
            int symbolKey;
            assert (latestByIndex == metadata.getColumnIndexQuiet(intrinsicModel.keyColumn));
            if (intrinsicModel.keySubQuery != null) {
                Record.CharSequenceFunction func;
                RecordCursorFactory rcf = null;
                try {
                    rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                    func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                }
                catch (Throwable th) {
                    Misc.free(partitionFrameCursorFactory);
                    Misc.free(rcf);
                    throw th;
                }
                return new LatestBySubQueryRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, rcf, filter, indexed, func, columnIndexes, columnSizeShifts);
            }
            int nKeyValues = intrinsicModel.keyValueFuncs.size();
            int nExcludedKeyValues = intrinsicModel.keyExcludedValueFuncs.size();
            if (indexed && nExcludedKeyValues == 0) {
                assert (nKeyValues > 0);
                SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(latestByIndex));
                if (nKeyValues == 1) {
                    int symbol;
                    Function symbolValueFunc = intrinsicModel.keyValueFuncs.get(0);
                    int n = symbol = symbolValueFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolValueFunc.getStrA(null));
                    if (filter == null) {
                        RowCursorFactory rcf = symbol == -2 ? new LatestByValueDeferredIndexedRowCursorFactory(latestByIndex, symbolValueFunc, false) : new LatestByValueIndexedRowCursorFactory(latestByIndex, symbol, false);
                        return new PageFrameRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, rcf, false, null, false, columnIndexes, columnSizeShifts, true, true);
                    }
                    if (symbol == -2) {
                        return new LatestByValueDeferredIndexedFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, symbolValueFunc, filter, columnIndexes, columnSizeShifts);
                    }
                    return new LatestByValueIndexedFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, symbol, filter, columnIndexes, columnSizeShifts);
                }
                return new LatestByValuesIndexedFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, intrinsicModel.keyValueFuncs, symbolMapReader, filter, columnIndexes, columnSizeShifts);
            }
            assert (nKeyValues > 0 || nExcludedKeyValues > 0);
            if (nKeyValues > 1 || nExcludedKeyValues > 0) {
                return new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, intrinsicModel.keyValueFuncs, intrinsicModel.keyExcludedValueFuncs, filter, columnIndexes, columnSizeShifts);
            }
            assert (nExcludedKeyValues == 0);
            Function symbolKeyFunc = intrinsicModel.keyValueFuncs.get(0);
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(latestByIndex));
            int n = symbolKey = symbolKeyFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolKeyFunc.getStrA(null));
            if (symbolKey == -2) {
                return new LatestByValueDeferredFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, symbolKeyFunc, filter, columnIndexes, columnSizeShifts);
            }
            return new LatestByValueFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, symbolKey, filter, columnIndexes, columnSizeShifts);
        }
        assert (intrinsicModel.keyValueFuncs.size() == 0);
        if (indexed && filter == null && this.configuration.useWithinLatestByOptimisation()) {
            return new LatestByAllIndexedRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, columnIndexes, columnSizeShifts, prefixes);
        }
        return new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, metadata, partitionFrameCursorFactory, latestByIndex, filter, columnIndexes, columnSizeShifts);
    }

    private RecordCursorFactory generateLimit(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (factory.followedLimitAdvice()) {
            return factory;
        }
        ExpressionNode limitLo = model.getLimitLo();
        ExpressionNode limitHi = model.getLimitHi();
        if (limitLo == null && limitHi == null || factory.implementsLimit() && model.isLimitImplemented()) {
            return factory;
        }
        try {
            Function loFunc = this.getLoFunction(model, executionContext);
            Function hiFunc = this.getHiFunction(model, executionContext);
            return new LimitRecordCursorFactory(factory, loFunc, hiFunc);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateNoSelect(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        if (tableNameExpr != null) {
            if (tableNameExpr.type == 6) {
                return this.generateFunctionQuery(model, executionContext);
            }
            return this.generateTableQuery(model, executionContext);
        }
        return this.generateSubQuery(model, executionContext);
    }

    private RecordCursorFactory generateOrderBy(RecordCursorFactory recordCursorFactory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (recordCursorFactory.followedOrderByAdvice()) {
            return recordCursorFactory;
        }
        try {
            LowerCaseCharSequenceIntHashMap orderByColumnNameToIndexMap = model.getOrderHash();
            ObjList orderByColumnNames = orderByColumnNameToIndexMap.keys();
            int orderByColumnCount = orderByColumnNames.size();
            if (orderByColumnCount > 0) {
                GenericRecordMetadata orderedMetadata;
                int firstOrderByColumnIndex;
                int index;
                CharSequence column;
                RecordMetadata metadata = recordCursorFactory.getMetadata();
                int timestampIndex = metadata.getTimestampIndex();
                this.listColumnFilterA.clear();
                this.intHashSet.clear();
                int orderedByTimestampIndex = -1;
                for (int i = 0; i < orderByColumnCount; ++i) {
                    column = (CharSequence)orderByColumnNames.getQuick(i);
                    index = metadata.getColumnIndexQuiet(column);
                    int columnType = metadata.getColumnType(index);
                    if (!ColumnType.isComparable(columnType)) {
                        ObjList<ExpressionNode> nodes = model.getOrderBy();
                        int position = 0;
                        int y = nodes.size();
                        for (int j = 0; j < y; ++j) {
                            if (!Chars.equals(column, nodes.getQuick((int)i).token)) continue;
                            position = nodes.getQuick((int)i).position;
                            break;
                        }
                        throw SqlException.$(position, ColumnType.nameOf(columnType)).put(" is not a supported type in ORDER BY clause");
                    }
                    if (!this.intHashSet.add(index)) continue;
                    if (orderByColumnNameToIndexMap.get(column) == 1) {
                        this.listColumnFilterA.add(-index - 1);
                    } else {
                        this.listColumnFilterA.add(index + 1);
                    }
                    if (i != 0 || metadata.getColumnType(index) != 8) continue;
                    orderedByTimestampIndex = index;
                }
                boolean preSortedByTs = false;
                if (timestampIndex != -1 && (index = metadata.getColumnIndexQuiet(column = (CharSequence)orderByColumnNames.getQuick(0))) == timestampIndex) {
                    if (orderByColumnCount == 1) {
                        if (orderByColumnNameToIndexMap.get(column) == 0 && recordCursorFactory.getScanDirection() == 1) {
                            return recordCursorFactory;
                        }
                        if (orderByColumnNameToIndexMap.get(column) == 1 && recordCursorFactory.getScanDirection() == 2) {
                            return recordCursorFactory;
                        }
                    } else {
                        boolean bl = preSortedByTs = orderByColumnNameToIndexMap.get(column) == 0 && recordCursorFactory.getScanDirection() == 1 || orderByColumnNameToIndexMap.get(column) == 1 && recordCursorFactory.getScanDirection() == 2;
                    }
                }
                if ((firstOrderByColumnIndex = metadata.getColumnIndexQuiet((CharSequence)orderByColumnNames.getQuick(0))) == timestampIndex) {
                    orderedMetadata = GenericRecordMetadata.copyOf(metadata);
                } else {
                    orderedMetadata = GenericRecordMetadata.copyOfSansTimestamp(metadata);
                    orderedMetadata.setTimestampIndex(orderedByTimestampIndex);
                }
                Function loFunc = this.getLoFunction(model, executionContext);
                Function hiFunc = this.getHiFunction(model, executionContext);
                if (recordCursorFactory.recordCursorSupportsRandomAccess()) {
                    if (this.canSortAndLimitBeOptimized(model, executionContext, loFunc, hiFunc)) {
                        long lo;
                        model.setLimitImplemented(true);
                        if (!preSortedByTs && loFunc.isConstant() && hiFunc == null && (lo = loFunc.getLong(null)) > 0L && lo <= Integer.MAX_VALUE) {
                            int index2;
                            int columnIndex;
                            if (this.listColumnFilterA.size() == 1 && recordCursorFactory.recordCursorSupportsLongTopK() && metadata.getColumnType(columnIndex = ((index2 = this.listColumnFilterA.getQuick(0)) > 0 ? index2 : -index2) - 1) == 6) {
                                return new LongTopKRecordCursorFactory(orderedMetadata, recordCursorFactory, columnIndex, (int)lo, index2 > 0);
                            }
                            boolean parallelTopKEnabled = executionContext.isParallelTopKEnabled();
                            if (parallelTopKEnabled && (recordCursorFactory.supportsPageFrameCursor() || recordCursorFactory.supportsFilterStealing())) {
                                QueryModel.restoreWhereClause(this.expressionNodePool, model);
                                RecordCursorFactory baseFactory = recordCursorFactory;
                                CompiledFilter compiledFilter = null;
                                MemoryCARW bindVarMemory = null;
                                ObjList<Function> bindVarFunctions = null;
                                Function filter = null;
                                if (recordCursorFactory.supportsFilterStealing()) {
                                    baseFactory = recordCursorFactory.getBaseFactory();
                                    compiledFilter = recordCursorFactory.getCompiledFilter();
                                    bindVarMemory = recordCursorFactory.getBindVarMemory();
                                    bindVarFunctions = recordCursorFactory.getBindVarFunctions();
                                    filter = recordCursorFactory.getFilter();
                                    recordCursorFactory.halfClose();
                                }
                                QueryModel nested = model.getNestedModel();
                                assert (nested != null);
                                return new AsyncTopKRecordCursorFactory(this.configuration, executionContext.getMessageBus(), orderedMetadata, baseFactory, this.reduceTaskFactory, filter, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), this.locatePotentiallyFurtherNestedWhereClause(nested), baseFactory.getMetadata()), compiledFilter, bindVarMemory, bindVarFunctions, this.recordComparatorCompiler, this.listColumnFilterA.copy(), metadata, lo, executionContext.getSharedQueryWorkerCount());
                            }
                        }
                        int baseCursorTimestampIndex = preSortedByTs ? timestampIndex : -1;
                        return new LimitedSizeSortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.newInstance(metadata, this.listColumnFilterA), loFunc, hiFunc, this.listColumnFilterA.copy(), baseCursorTimestampIndex);
                    }
                    int columnType = orderedMetadata.getColumnType(firstOrderByColumnIndex);
                    if (this.configuration.isSqlOrderBySortEnabled() && orderByColumnNames.size() == 1 && LongSortedLightRecordCursorFactory.isSupportedColumnType(columnType)) {
                        return new LongSortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.listColumnFilterA.copy());
                    }
                    return new SortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.newInstance(metadata, this.listColumnFilterA), this.listColumnFilterA.copy());
                }
                this.entityColumnFilter.of(orderedMetadata.getColumnCount());
                return new SortedRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, RecordSinkFactory.getInstance(this.asm, orderedMetadata, this.entityColumnFilter), this.recordComparatorCompiler.newInstance(metadata, this.listColumnFilterA), this.listColumnFilterA.copy());
            }
            return recordCursorFactory;
        }
        catch (CairoException | SqlException e) {
            recordCursorFactory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateQuery(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        RecordCursorFactory factory = this.generateQuery0(model, executionContext, processJoins);
        if (model.getUnionModel() != null) {
            return this.generateSetFactory(model, factory, executionContext);
        }
        return factory;
    }

    private RecordCursorFactory generateQuery0(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        return this.generateLimit(this.generateOrderBy(this.generateLatestBy(this.generateFilter(this.generateSelect(model, executionContext, processJoins), model, executionContext), model), model, executionContext), model, executionContext);
    }

    @NotNull
    private RecordCursorFactory generateSampleBy(QueryModel model, SqlExecutionContext executionContext, ExpressionNode sampleByNode, ExpressionNode sampleByUnits) throws SqlException {
        int timestampIndex;
        int sampleToFuncPos;
        Function sampleToFunc;
        int sampleFromFuncPos;
        Function sampleFromFunc;
        int offsetFuncPos;
        Function offsetFunc;
        int timezoneNameFuncPos;
        Function timezoneNameFunc;
        ExpressionNode timezoneName = model.getSampleByTimezoneName();
        ExpressionNode offset = model.getSampleByOffset();
        if (timezoneName != null) {
            timezoneNameFunc = this.functionParser.parseFunction(timezoneName, EmptyRecordMetadata.INSTANCE, executionContext);
            timezoneNameFuncPos = timezoneName.position;
            SqlCodeGenerator.coerceRuntimeConstantType(timezoneNameFunc, (short)11, executionContext, "timezone must be a constant expression of STRING or CHAR type", timezoneNameFuncPos);
        } else {
            timezoneNameFunc = StrConstant.NULL;
            timezoneNameFuncPos = 0;
        }
        if (offset != null) {
            offsetFunc = this.functionParser.parseFunction(offset, EmptyRecordMetadata.INSTANCE, executionContext);
            offsetFuncPos = offset.position;
            SqlCodeGenerator.coerceRuntimeConstantType(offsetFunc, (short)11, executionContext, "offset must be a constant expression of STRING or CHAR type", offsetFuncPos);
        } else {
            offsetFunc = StrConstant.NULL;
            offsetFuncPos = 0;
        }
        if (model.getSampleByFrom() != null) {
            sampleFromFunc = this.functionParser.parseFunction(model.getSampleByFrom(), EmptyRecordMetadata.INSTANCE, executionContext);
            sampleFromFuncPos = model.getSampleByFrom().position;
            SqlCodeGenerator.coerceRuntimeConstantType(sampleFromFunc, (short)8, executionContext, "from lower bound must be a constant expression convertible to a TIMESTAMP", sampleFromFuncPos);
        } else {
            sampleFromFunc = TimestampConstant.NULL;
            sampleFromFuncPos = 0;
        }
        if (model.getSampleByTo() != null) {
            sampleToFunc = this.functionParser.parseFunction(model.getSampleByTo(), EmptyRecordMetadata.INSTANCE, executionContext);
            sampleToFuncPos = model.getSampleByTo().position;
            SqlCodeGenerator.coerceRuntimeConstantType(sampleToFunc, (short)8, executionContext, "to upper bound must be a constant expression convertible to a TIMESTAMP", sampleToFuncPos);
        } else {
            sampleToFunc = TimestampConstant.NULL;
            sampleToFuncPos = 0;
        }
        boolean isFromTo = sampleFromFunc != TimestampConstant.NULL || sampleToFunc != TimestampConstant.NULL;
        RecordCursorFactory factory = null;
        executionContext.pushTimestampRequiredFlag(model.getTimestamp() == null);
        try {
            factory = this.generateSubQuery(model, executionContext);
            timestampIndex = this.getTimestampIndex(model, factory);
            if (timestampIndex == -1 || factory.getScanDirection() != 1) {
                throw SqlException.$(model.getModelPosition(), "base query does not provide ASC order over designated TIMESTAMP column");
            }
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        finally {
            executionContext.popTimestampRequiredFlag();
        }
        RecordMetadata baseMetadata = factory.getMetadata();
        ObjList<ExpressionNode> sampleByFill = model.getSampleByFill();
        int fillCount = sampleByFill.size();
        if (fillCount != 0 && model.getTopDownColumns().size() != 0) {
            int i;
            this.tempColumnsList.clear();
            int n = model.getBottomUpColumns().size();
            for (i = 0; i < n; ++i) {
                QueryColumn column = model.getBottomUpColumns().getQuick(i);
                if (column.isWindowColumn()) continue;
                ExpressionNode node = column.getAst();
                if (node.type != 6 || !this.functionParser.getFunctionFactoryCache().isGroupBy(node.token)) continue;
                this.tempColumnsList.add(column);
            }
            this.tempExpressionNodeList.clear();
            n = model.getTopDownColumns().size();
            for (i = 0; i < n; ++i) {
                int index = this.tempColumnsList.indexOf(model.getTopDownColumns().getQuick(i));
                if (index == -1 || fillCount <= index) continue;
                this.tempExpressionNodeList.add(sampleByFill.getQuick(index));
            }
            sampleByFill = this.tempExpressionNodeList;
            fillCount = sampleByFill.size();
        }
        try {
            SingleSymbolFilter symbolFilter;
            boolean allGroupsFirstLast;
            ObjList<Function> innerProjectionFunctions;
            TimestampSampler timestampSampler;
            if (sampleByUnits == null) {
                timestampSampler = TimestampSamplerFactory.getInstance(sampleByNode.token, sampleByNode.position);
            } else {
                Function sampleByPeriod = this.functionParser.parseFunction(sampleByNode, EmptyRecordMetadata.INSTANCE, executionContext);
                if (!sampleByPeriod.isConstant() || sampleByPeriod.getType() != 6 && sampleByPeriod.getType() != 5) {
                    Misc.free(sampleByPeriod);
                    throw SqlException.$(sampleByNode.position, "sample by period must be a constant expression of INT or LONG type");
                }
                long period = sampleByPeriod.getLong(null);
                sampleByPeriod.close();
                timestampSampler = TimestampSamplerFactory.getInstance(period, sampleByUnits.token, sampleByUnits.position);
            }
            this.keyTypes.clear();
            this.valueTypes.clear();
            this.listColumnFilterA.clear();
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "linear")) {
                this.valueTypes.add(2);
                int columnCount = baseMetadata.getColumnCount();
                ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
                ObjList<Function> outerProjectionFunctions = new ObjList<Function>(columnCount);
                innerProjectionFunctions = new ObjList(columnCount);
                GenericRecordMetadata projectionMetadata = new GenericRecordMetadata();
                PriorityMetadata priorityMetadata = new PriorityMetadata(columnCount, baseMetadata);
                IntList projectionFunctionFlags = new IntList(columnCount);
                GroupByUtils.assembleGroupByFunctions(this.functionParser, this.sqlNodeStack, model, executionContext, baseMetadata, timestampIndex, false, groupByFunctions, this.groupByFunctionPositions, outerProjectionFunctions, innerProjectionFunctions, this.recordFunctionPositions, projectionFunctionFlags, projectionMetadata, priorityMetadata, this.valueTypes, this.keyTypes, this.listColumnFilterA, sampleByFill, this.validateSampleByFillType);
                return new SampleByInterpolateRecordCursorFactory(this.asm, this.configuration, factory, projectionMetadata, groupByFunctions, outerProjectionFunctions, timestampSampler, model, this.listColumnFilterA, this.keyTypes, this.valueTypes, this.entityColumnFilter, this.groupByFunctionPositions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
            }
            this.valueTypes.add(8);
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            ObjList<Function> outerProjectionFunctions = new ObjList<Function>(columnCount);
            innerProjectionFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata projectionMetadata = new GenericRecordMetadata();
            PriorityMetadata priorityMetadata = new PriorityMetadata(columnCount, baseMetadata);
            IntList projectionFunctionFlags = new IntList(columnCount);
            GroupByUtils.assembleGroupByFunctions(this.functionParser, this.sqlNodeStack, model, executionContext, baseMetadata, timestampIndex, false, groupByFunctions, this.groupByFunctionPositions, outerProjectionFunctions, innerProjectionFunctions, this.recordFunctionPositions, projectionFunctionFlags, projectionMetadata, priorityMetadata, this.valueTypes, this.keyTypes, this.listColumnFilterA, sampleByFill, this.validateSampleByFillType);
            boolean isFillNone = fillCount == 0 || fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "none");
            boolean bl = allGroupsFirstLast = isFillNone && SqlCodeGenerator.allGroupsFirstLastWithSingleSymbolFilter(model, baseMetadata);
            if (allGroupsFirstLast && (symbolFilter = factory.convertToSampleByIndexPageFrameCursorFactory()) != null) {
                int symbolColIndex = this.getSampleBySymbolKeyIndex(model, baseMetadata);
                if (symbolColIndex == -1 || symbolFilter.getColumnIndex() == symbolColIndex) {
                    return new SampleByFirstLastRecordCursorFactory(this.configuration, factory, timestampSampler, projectionMetadata, model.getColumns(), baseMetadata, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, timestampIndex, symbolFilter, this.configuration.getSampleByIndexSearchPageSize(), sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
                }
                factory.revertFromSampleByIndexPageFrameCursorFactory();
            }
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "prev")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    return new SampleByFillPrevNotKeyedRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, projectionMetadata, groupByFunctions, outerProjectionFunctions, timestampIndex, this.valueTypes.getColumnCount(), timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
                }
                this.guardAgainstFromToWithKeyedSampleBy(isFromTo);
                return new SampleByFillPrevRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, this.listColumnFilterA, this.keyTypes, this.valueTypes, projectionMetadata, groupByFunctions, outerProjectionFunctions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
            }
            if (isFillNone) {
                if (this.keyTypes.getColumnCount() == 0) {
                    return new SampleByFillNoneNotKeyedRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, projectionMetadata, groupByFunctions, outerProjectionFunctions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
                }
                this.guardAgainstFromToWithKeyedSampleBy(isFromTo);
                return new SampleByFillNoneRecordCursorFactory(this.asm, this.configuration, factory, projectionMetadata, groupByFunctions, outerProjectionFunctions, timestampSampler, this.listColumnFilterA, this.keyTypes, this.valueTypes, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
            }
            if (fillCount == 1 && SqlKeywords.isNullKeyword(sampleByFill.getQuick((int)0).token)) {
                if (this.keyTypes.getColumnCount() == 0) {
                    return new SampleByFillNullNotKeyedRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, projectionMetadata, groupByFunctions, outerProjectionFunctions, this.recordFunctionPositions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
                }
                this.guardAgainstFromToWithKeyedSampleBy(isFromTo);
                return new SampleByFillNullRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, this.listColumnFilterA, this.keyTypes, this.valueTypes, projectionMetadata, groupByFunctions, outerProjectionFunctions, this.recordFunctionPositions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
            }
            assert (fillCount > 0);
            if (this.keyTypes.getColumnCount() == 0) {
                return new SampleByFillValueNotKeyedRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, sampleByFill, projectionMetadata, groupByFunctions, outerProjectionFunctions, this.recordFunctionPositions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
            }
            this.guardAgainstFromToWithKeyedSampleBy(isFromTo);
            return new SampleByFillValueRecordCursorFactory(this.asm, this.configuration, factory, timestampSampler, this.listColumnFilterA, sampleByFill, this.keyTypes, this.valueTypes, projectionMetadata, groupByFunctions, outerProjectionFunctions, this.recordFunctionPositions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateSelect(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        switch (model.getSelectModelType()) {
            case 1: {
                return this.generateSelectChoose(model, executionContext);
            }
            case 4: {
                return this.generateSelectGroupBy(model, executionContext);
            }
            case 2: {
                return this.generateSelectVirtual(model, executionContext);
            }
            case 3: {
                return this.generateSelectWindow(model, executionContext);
            }
            case 5: {
                return this.generateSelectDistinct(model, executionContext);
            }
            case 6: {
                return this.generateSelectCursor(model, executionContext);
            }
            case 7: {
                return model.getTableNameFunction();
            }
        }
        if (model.getJoinModels().size() > 1 && processJoins) {
            return this.generateJoins(model, executionContext);
        }
        return this.generateNoSelect(model, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordCursorFactory generateSelectChoose(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        int timestampIndex;
        boolean entity;
        int index;
        RecordCursorFactory factory;
        boolean overrideTimestampRequired = model.hasExplicitTimestamp() && executionContext.isTimestampRequired();
        try {
            if (overrideTimestampRequired) {
                executionContext.pushTimestampRequiredFlag(false);
            }
            factory = this.generateSubQuery(model, executionContext);
        }
        finally {
            if (overrideTimestampRequired) {
                executionContext.popTimestampRequiredFlag();
            }
        }
        RecordMetadata metadata = factory.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int selectColumnCount = columns.size();
        ExpressionNode timestamp = model.getTimestamp();
        if (model.isUpdate()) {
            boolean columnTypeMismatch = false;
            ObjList<CharSequence> updateColumnNames = model.getUpdateTableColumnNames();
            IntList updateColumnTypes = model.getUpdateTableColumnTypes();
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn queryColumn = columns.getQuick(i);
                CharSequence columnName = queryColumn.getAlias();
                index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
                assert (index > -1) : "wtf? " + String.valueOf(queryColumn.getAst().token);
                int updateColumnIndex = updateColumnNames.indexOf(columnName);
                int updateColumnType = updateColumnTypes.get(updateColumnIndex);
                if (updateColumnType == metadata.getColumnType(index)) continue;
                columnTypeMismatch = true;
                break;
            }
            if (columnTypeMismatch) {
                return this.generateSelectVirtualWithSubQuery(model, executionContext, factory);
            }
        }
        if (timestamp == null && metadata.getColumnCount() == selectColumnCount) {
            entity = true;
            for (int i = 0; i < selectColumnCount; ++i) {
                QueryColumn qc = columns.getQuick(i);
                if (Chars.equals((CharSequence)metadata.getColumnName(i), qc.getAst().token) && (qc.getAlias() == null || Chars.equals(qc.getAlias(), qc.getAst().token))) continue;
                entity = false;
                break;
            }
        } else {
            int tsIndex = metadata.getTimestampIndex();
            boolean bl = entity = timestamp != null && tsIndex != -1 && Chars.equalsIgnoreCase(timestamp.token, metadata.getColumnName(tsIndex));
        }
        if (entity) {
            model.setSkipped(true);
            return factory;
        }
        try {
            timestampIndex = this.getTimestampIndex(model, factory);
            if (executionContext.isTimestampRequired() && (timestampIndex == -1 || factory.getScanDirection() != 1)) {
                throw SqlException.$(model.getModelPosition(), "ASC order over TIMESTAMP column is required but not provided");
            }
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        IntList columnCrossIndex = new IntList(selectColumnCount);
        GenericRecordMetadata selectMetadata = new GenericRecordMetadata();
        boolean timestampSet = false;
        for (int i = 0; i < selectColumnCount; ++i) {
            QueryColumn queryColumn = columns.getQuick(i);
            index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
            assert (index > -1) : "wtf? " + String.valueOf(queryColumn.getAst().token);
            columnCrossIndex.add(index);
            if (queryColumn.getAlias() == null) {
                selectMetadata.add(metadata.getColumnMetadata(index));
            } else {
                selectMetadata.add(new TableColumnMetadata(Chars.toString(queryColumn.getAlias()), metadata.getColumnType(index), metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index), metadata.getMetadata(index)));
            }
            if (index != timestampIndex) continue;
            selectMetadata.setTimestampIndex(i);
            timestampSet = true;
        }
        if (!timestampSet && executionContext.isTimestampRequired()) {
            TableColumnMetadata colMetadata = metadata.getColumnMetadata(timestampIndex);
            selectMetadata.add(new TableColumnMetadata("", colMetadata.getColumnType(), colMetadata.isSymbolIndexFlag(), colMetadata.getIndexValueBlockCapacity(), colMetadata.isSymbolTableStatic(), metadata));
            selectMetadata.setTimestampIndex(selectMetadata.getColumnCount() - 1);
            columnCrossIndex.add(timestampIndex);
        }
        return new SelectedRecordCursorFactory(selectMetadata, columnCrossIndex, factory);
    }

    private RecordCursorFactory generateSelectCursor(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return new RecordAsAFieldRecordCursorFactory(this.generate(model.getNestedModel(), executionContext), model.getColumns().getQuick(0).getAlias());
    }

    private RecordCursorFactory generateSelectDistinct(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            Function limitHiFunc;
            Function limitLoFunc;
            if (factory.recordCursorSupportsRandomAccess() && factory.getMetadata().getTimestampIndex() != -1) {
                return new DistinctTimeSeriesRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm);
            }
            if (model.getOrderBy().size() == 0) {
                limitLoFunc = this.getLoFunction(model, executionContext);
                limitHiFunc = this.getHiFunction(model, executionContext);
            } else {
                limitLoFunc = null;
                limitHiFunc = null;
            }
            return new DistinctRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm, limitLoFunc, limitHiFunc);
        }
        catch (Throwable e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSelectGroupBy(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode sampleByNode = model.getSampleBy();
        if (sampleByNode != null) {
            return this.generateSampleBy(model, executionContext, sampleByNode, model.getSampleByUnit());
        }
        RecordCursorFactory factory = null;
        try {
            ExpressionNode columnExpr;
            ObjList<QueryColumn> columns = model.getColumns();
            if (columns.size() == 1) {
                CharSequence columnName = columns.getQuick(0).getName();
                columnExpr = columns.getQuick(0).getAst();
                if (columnExpr.type == 6 && columnExpr.paramCount == 0 && SqlKeywords.isCountKeyword(columnExpr.token)) {
                    GenericRecordMetadata metadata = SqlKeywords.isCountKeyword(columnName) ? CountRecordCursorFactory.DEFAULT_COUNT_METADATA : new GenericRecordMetadata().add(new TableColumnMetadata(Chars.toString(columnName), 6));
                    return new CountRecordCursorFactory(metadata, this.generateSubQuery(model, executionContext));
                }
            }
            this.tempKeyIndexesInBase.clear();
            this.tempKeyIndex.clear();
            this.arrayColumnTypes.clear();
            this.tempKeyKinds.clear();
            boolean pageFramingSupported = false;
            QueryModel.backupWhereClause(this.expressionNodePool, model);
            QueryModel nested = model.getNestedModel();
            assert (nested != null);
            int hourIndex = -1;
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn tableColumn;
                QueryColumn qc = columns.getQuick(i);
                if (qc.getAst() == null || qc.getAst().type != 6) {
                    hourIndex = -1;
                    break;
                }
                columnExpr = qc.getAst();
                if (!SqlKeywords.isHourKeyword(columnExpr.token) || columnExpr.paramCount != 1 || columnExpr.rhs.type != 7 || (tableColumn = nested.getAliasToColumnMap().get(columnExpr.rhs.token)) == null || tableColumn.getColumnType() != 8) continue;
                hourIndex = i;
            }
            if (hourIndex != -1) {
                factory = this.generateSubQuery(model, executionContext);
                pageFramingSupported = factory.supportsPageFrameCursor();
                if (pageFramingSupported) {
                    columnExpr = columns.getQuick(hourIndex).getAst();
                    this.tempKeyIndexesInBase.add(factory.getMetadata().getColumnIndex(columnExpr.rhs.token));
                    this.tempKeyIndex.add(hourIndex);
                    this.tempKeyKinds.add(1);
                    this.arrayColumnTypes.add(5);
                } else {
                    factory = Misc.free(factory);
                }
            }
            if (factory == null) {
                if (hourIndex != -1) {
                    QueryModel.restoreWhereClause(this.expressionNodePool, model);
                }
                factory = this.generateSubQuery(model, executionContext);
                pageFramingSupported = factory.supportsPageFrameCursor();
            }
            RecordMetadata baseMetadata = factory.getMetadata();
            boolean enableParallelGroupBy = executionContext.isParallelGroupByEnabled();
            if (enableParallelGroupBy && pageFramingSupported && this.assembleKeysAndFunctionReferences(columns, baseMetadata, hourIndex)) {
                int indexInBase;
                int i;
                GenericRecordMetadata meta = new GenericRecordMetadata();
                int n2 = this.tempKeyIndex.size();
                for (i = 0; i < n2; ++i) {
                    int indexInThis = this.tempKeyIndex.getQuick(i);
                    indexInBase = this.tempKeyIndexesInBase.getQuick(i);
                    int type = this.arrayColumnTypes.getColumnType(i);
                    if (ColumnType.isSymbol(type)) {
                        meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), type, false, 0, baseMetadata.isSymbolTableStatic(indexInBase), null));
                        continue;
                    }
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), type, null));
                }
                n2 = this.tempVecConstructors.size();
                for (i = 0; i < n2; ++i) {
                    VectorAggregateFunctionConstructor constructor = this.tempVecConstructors.getQuick(i);
                    indexInBase = this.tempVecConstructorArgIndexes.getQuick(i);
                    int indexInThis = this.tempAggIndex.getQuick(i);
                    VectorAggregateFunction vaf = constructor.create(this.tempKeyKinds.size() == 0 ? 0 : this.tempKeyKinds.getQuick(0), indexInBase, executionContext.getSharedQueryWorkerCount());
                    this.tempVaf.add(vaf);
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), vaf.getType(), null));
                }
                if (this.tempKeyIndexesInBase.size() == 0) {
                    return new GroupByNotKeyedVectorRecordCursorFactory(this.configuration, factory, meta, executionContext.getSharedQueryWorkerCount(), this.tempVaf);
                }
                if (this.tempKeyIndexesInBase.size() == 1) {
                    n2 = this.tempVaf.size();
                    for (i = 0; i < n2; ++i) {
                        this.tempVaf.getQuick(i).pushValueTypes(this.arrayColumnTypes);
                    }
                    if (this.tempVaf.size() == 0) {
                        int keyKind = hourIndex != -1 ? 1 : 0;
                        CountVectorAggregateFunction countFunction = new CountVectorAggregateFunction(keyKind);
                        countFunction.pushValueTypes(this.arrayColumnTypes);
                        this.tempVaf.add(countFunction);
                        this.tempSymbolSkewIndexes.clear();
                        this.tempSymbolSkewIndexes.add(0);
                    }
                    try {
                        GroupByUtils.validateGroupByColumns(this.sqlNodeStack, model, 1);
                    }
                    catch (Throwable e) {
                        Misc.freeObjList(this.tempVaf);
                        throw e;
                    }
                    this.guardAgainstFillWithKeyedGroupBy(model, this.keyTypes);
                    return this.generateFill(model, new io.questdb.griffin.engine.groupby.vect.GroupByRecordCursorFactory(this.configuration, factory, meta, this.arrayColumnTypes, executionContext.getSharedQueryWorkerCount(), this.tempVaf, this.tempKeyIndexesInBase.getQuick(0), this.tempKeyIndex.getQuick(0), this.tempSymbolSkewIndexes), executionContext);
                }
                Misc.freeObjList(this.tempVaf);
            }
            if (hourIndex != -1) {
                factory = Misc.free(factory);
                QueryModel.restoreWhereClause(this.expressionNodePool, model);
                factory = this.generateSubQuery(model, executionContext);
                baseMetadata = factory.getMetadata();
            }
            int timestampIndex = this.getTimestampIndex(model, factory);
            this.keyTypes.clear();
            this.valueTypes.clear();
            this.listColumnFilterA.clear();
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            ObjList<Function> outerProjectionFunctions = new ObjList<Function>(columnCount);
            ObjList<Function> innerProjectionFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata outerProjectionMetadata = new GenericRecordMetadata();
            PriorityMetadata priorityMetadata = new PriorityMetadata(columnCount, baseMetadata);
            IntList projectionFunctionFlags = new IntList(columnCount);
            GroupByUtils.assembleGroupByFunctions(this.functionParser, this.sqlNodeStack, model, executionContext, baseMetadata, timestampIndex, true, groupByFunctions, this.groupByFunctionPositions, outerProjectionFunctions, innerProjectionFunctions, this.recordFunctionPositions, projectionFunctionFlags, outerProjectionMetadata, priorityMetadata, this.valueTypes, this.keyTypes, this.listColumnFilterA, null, this.validateSampleByFillType);
            if (enableParallelGroupBy && this.keyTypes.getColumnCount() == 0 && GroupByUtils.isEarlyExitSupported(groupByFunctions) && factory.getFilter() == null) {
                enableParallelGroupBy = false;
            }
            ObjList<Function> keyFunctions = this.extractVirtualFunctionsFromProjection(innerProjectionFunctions, projectionFunctionFlags);
            if (enableParallelGroupBy && SqlUtil.isParallelismSupported(keyFunctions) && GroupByUtils.isParallelismSupported(groupByFunctions)) {
                boolean supportsParallelism = factory.supportsPageFrameCursor();
                CompiledFilter compiledFilter = null;
                MemoryCARW bindVarMemory = null;
                ObjList<Function> bindVarFunctions = null;
                Function filter = null;
                if (!supportsParallelism && factory.supportsFilterStealing()) {
                    RecordCursorFactory filterFactory = factory;
                    factory = factory.getBaseFactory();
                    assert (factory.supportsPageFrameCursor());
                    compiledFilter = filterFactory.getCompiledFilter();
                    bindVarMemory = filterFactory.getBindVarMemory();
                    bindVarFunctions = filterFactory.getBindVarFunctions();
                    filter = filterFactory.getFilter();
                    supportsParallelism = true;
                    filterFactory.halfClose();
                }
                if (supportsParallelism) {
                    QueryModel.restoreWhereClause(this.expressionNodePool, model);
                    ArrayColumnTypes keyTypesCopy = new ArrayColumnTypes().addAll(this.keyTypes);
                    ArrayColumnTypes valueTypesCopy = new ArrayColumnTypes().addAll(this.valueTypes);
                    ListColumnFilter listColumnFilterCopy = this.listColumnFilterA.copy();
                    if (keyTypesCopy.getColumnCount() == 0) {
                        assert (keyFunctions.size() == 0);
                        assert (outerProjectionFunctions.size() == groupByFunctions.size());
                        return new AsyncGroupByNotKeyedRecordCursorFactory(this.asm, this.configuration, executionContext.getMessageBus(), factory, outerProjectionMetadata, groupByFunctions, this.compileWorkerGroupByFunctionsConditionally(executionContext, model, groupByFunctions, executionContext.getSharedQueryWorkerCount(), factory.getMetadata()), valueTypesCopy.getColumnCount(), compiledFilter, bindVarMemory, bindVarFunctions, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), this.locatePotentiallyFurtherNestedWhereClause(nested), factory.getMetadata()), executionContext.getSharedQueryWorkerCount());
                    }
                    this.guardAgainstFillWithKeyedGroupBy(model, this.keyTypes);
                    ObjList<ObjList<Function>> perWorkerInnerProjectionFunctions = this.compilePerWorkerInnerProjectionFunctions(executionContext, model.getColumns(), innerProjectionFunctions, executionContext.getSharedQueryWorkerCount(), baseMetadata);
                    return this.generateFill(model, new AsyncGroupByRecordCursorFactory(this.asm, this.configuration, executionContext.getMessageBus(), factory, outerProjectionMetadata, listColumnFilterCopy, keyTypesCopy, valueTypesCopy, groupByFunctions, SqlCodeGenerator.extractWorkerFunctionsConditionally(innerProjectionFunctions, projectionFunctionFlags, perWorkerInnerProjectionFunctions, 2), keyFunctions, SqlCodeGenerator.extractWorkerFunctionsConditionally(innerProjectionFunctions, projectionFunctionFlags, perWorkerInnerProjectionFunctions, 1), outerProjectionFunctions, compiledFilter, bindVarMemory, bindVarFunctions, filter, this.reduceTaskFactory, this.compileWorkerFilterConditionally(executionContext, filter, executionContext.getSharedQueryWorkerCount(), this.locatePotentiallyFurtherNestedWhereClause(nested), factory.getMetadata()), executionContext.getSharedQueryWorkerCount()), executionContext);
                }
            }
            if (this.keyTypes.getColumnCount() == 0) {
                assert (outerProjectionFunctions.size() == groupByFunctions.size());
                return new GroupByNotKeyedRecordCursorFactory(this.asm, this.configuration, factory, outerProjectionMetadata, groupByFunctions, this.valueTypes.getColumnCount());
            }
            this.guardAgainstFillWithKeyedGroupBy(model, this.keyTypes);
            return this.generateFill(model, new GroupByRecordCursorFactory(this.asm, this.configuration, factory, this.listColumnFilterA, this.keyTypes, this.valueTypes, outerProjectionMetadata, groupByFunctions, keyFunctions, outerProjectionFunctions), executionContext);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateSelectVirtual(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        return this.generateSelectVirtualWithSubQuery(model, executionContext, factory);
    }

    @NotNull
    private VirtualRecordCursorFactory generateSelectVirtualWithSubQuery(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factory) throws SqlException {
        ObjList<QueryColumn> columns = model.getColumns();
        int columnCount = columns.size();
        ObjList<Function> functions = new ObjList<Function>(columnCount);
        RecordMetadata baseMetadata = factory.getMetadata();
        int virtualColumnReservedSlots = columnCount + 1;
        PriorityMetadata priorityMetadata = new PriorityMetadata(virtualColumnReservedSlots, baseMetadata);
        GenericRecordMetadata virtualMetadata = new GenericRecordMetadata();
        try {
            int timestampIndex = baseMetadata.getTimestampIndex();
            String timestampColumn = timestampIndex > -1 ? baseMetadata.getColumnName(timestampIndex) : null;
            for (int i = 0; i < columnCount; ++i) {
                int columnType;
                QueryColumn column = columns.getQuick(i);
                ExpressionNode node = column.getAst();
                if (node.type == 7 && Chars.equalsNc(node.token, timestampColumn)) {
                    virtualMetadata.setTimestampIndex(i);
                }
                Function function = this.functionParser.parseFunction(column.getAst(), priorityMetadata, executionContext);
                int targetColumnType = -1;
                if (model.isUpdate()) {
                    int columnIndex = model.getUpdateTableColumnNames().indexOf(column.getAlias());
                    targetColumnType = model.getUpdateTableColumnTypes().get(columnIndex);
                }
                if (model.isUpdate()) {
                    if (ColumnType.isUnderdefined(function.getType())) {
                        function.assignType(targetColumnType, executionContext.getBindVariableService());
                    }
                } else if (function.isUndefined()) {
                    function.assignType(11, executionContext.getBindVariableService());
                }
                if ((columnType = function.getType()) == 20) {
                    throw SqlException.$(node.position, "cursor function cannot be used as a column [column=").put(column.getAlias()).put(']');
                }
                if (targetColumnType != -1 && targetColumnType != columnType) {
                    if (ColumnType.isBuiltInWideningCast(function.getType(), targetColumnType)) {
                        columnType = targetColumnType;
                    } else {
                        Function castFunction = this.functionParser.createImplicitCast(column.getAst().position, function, targetColumnType);
                        if (castFunction != null) {
                            function = castFunction;
                            columnType = targetColumnType;
                        }
                    }
                }
                functions.add(function);
                TableColumnMetadata m = null;
                if (columnType == 12) {
                    if (function instanceof SymbolFunction) {
                        m = new TableColumnMetadata(Chars.toString(column.getAlias()), function.getType(), false, 0, ((SymbolFunction)function).isSymbolTableStatic(), function.getMetadata());
                    } else if (function instanceof NullConstant) {
                        m = new TableColumnMetadata(Chars.toString(column.getAlias()), 12, false, 0, false, function.getMetadata());
                        functions.setQuick(functions.size() - 1, SymbolConstant.NULL);
                    }
                } else {
                    m = new TableColumnMetadata(Chars.toString(column.getAlias()), columnType, function.getMetadata());
                }
                assert (m != null);
                virtualMetadata.add(m);
                priorityMetadata.add(m);
            }
            if (executionContext.isTimestampRequired() && timestampColumn != null && virtualMetadata.getTimestampIndex() == -1) {
                Function timestampFunction = FunctionParser.createColumn(0, timestampColumn, priorityMetadata);
                functions.add(timestampFunction);
                int n = model.getBottomUpColumns().size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn qc = model.getBottomUpColumns().getQuick(i);
                    if (qc.getAst().type != 7 || !Chars.equals((CharSequence)timestampColumn, qc.getAst().token)) continue;
                    virtualMetadata.setTimestampIndex(virtualMetadata.getColumnCount());
                    TableColumnMetadata m = new TableColumnMetadata(Chars.toString(qc.getAlias()), timestampFunction.getType(), timestampFunction.getMetadata());
                    virtualMetadata.add(m);
                    priorityMetadata.add(m);
                    break;
                }
            }
            return new VirtualRecordCursorFactory(virtualMetadata, priorityMetadata, functions, factory, virtualColumnReservedSlots, ALLOW_FUNCTION_MEMOIZATION);
        }
        catch (CairoException | SqlException e) {
            Misc.freeObjList(functions);
            factory.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private RecordCursorFactory generateSelectWindow(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory base = this.generateSubQuery(model, executionContext);
        RecordMetadata baseMetadata = base.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int columnCount = columns.size();
        this.groupedWindow.clear();
        this.valueTypes.clear();
        ArrayColumnTypes chainTypes = this.valueTypes;
        GenericRecordMetadata chainMetadata = new GenericRecordMetadata();
        GenericRecordMetadata factoryMetadata = new GenericRecordMetadata();
        ObjList<Function> functions = new ObjList<Function>();
        ObjList<WindowFunction> naturalOrderFunctions = null;
        ObjList<Function> partitionByFunctions = null;
        try {
            int i;
            void var15_21;
            boolean isFastPath = true;
            for (int i2 = 0; i2 < columnCount; ++i2) {
                QueryColumn queryColumn = columns.getQuick(i2);
                if (queryColumn.isWindowColumn()) {
                    Function f;
                    void var20_47;
                    int orderByPos;
                    VirtualRecord partitionByRecord;
                    WindowColumn ac = (WindowColumn)queryColumn;
                    ExpressionNode ast = queryColumn.getAst();
                    partitionByFunctions = null;
                    int psz = ac.getPartitionBy().size();
                    if (psz > 0) {
                        partitionByFunctions = new ObjList<Function>(psz);
                        for (int j = 0; j < psz; ++j) {
                            Function function = this.functionParser.parseFunction(ac.getPartitionBy().getQuick(j), baseMetadata, executionContext);
                            partitionByFunctions.add(function);
                            if (!(function instanceof GroupByFunction)) continue;
                            throw SqlException.$(ast.position, "aggregate functions in partition by are not supported");
                        }
                    }
                    if (partitionByFunctions != null) {
                        partitionByRecord = new VirtualRecord(partitionByFunctions);
                        this.keyTypes.clear();
                        int partitionByCount = partitionByFunctions.size();
                        for (int j = 0; j < partitionByCount; ++j) {
                            this.keyTypes.add(((Function)partitionByFunctions.getQuick(j)).getType());
                        }
                        this.entityColumnFilter.of(partitionByCount);
                        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, this.keyTypes, this.entityColumnFilter);
                    } else {
                        partitionByRecord = null;
                        Object var20_51 = null;
                    }
                    int osz = ac.getOrderBy().size();
                    LowerCaseCharSequenceIntHashMap orderHash = model.getOrderHash();
                    boolean dismissOrder = false;
                    int timestampIdx = base.getMetadata().getTimestampIndex();
                    int n = orderByPos = osz > 0 ? ac.getOrderBy().getQuick((int)0).position : -1;
                    if (base.followedOrderByAdvice() && osz > 0 && orderHash.size() > 0) {
                        dismissOrder = true;
                        for (int j = 0; j < osz; ++j) {
                            ExpressionNode node = ac.getOrderBy().getQuick(j);
                            int direction = ac.getOrderByDirection().getQuick(j);
                            if (Chars.equalsIgnoreCase(node.token, (CharSequence)orderHash.keys().get(j)) && orderHash.get(node.token) == direction) continue;
                            dismissOrder = false;
                            break;
                        }
                    }
                    if (!dismissOrder && osz == 1 && timestampIdx != -1 && orderHash.size() < 2) {
                        ExpressionNode orderByNode = ac.getOrderBy().getQuick(0);
                        int orderByDirection = ac.getOrderByDirection().getQuick(0);
                        if (baseMetadata.getColumnIndexQuiet(orderByNode.token) == timestampIdx && (orderByDirection == 0 && base.getScanDirection() == 1 || orderByDirection == 1 && base.getScanDirection() == 2)) {
                            dismissOrder = true;
                        }
                    }
                    executionContext.configureWindowContext(partitionByRecord, (RecordSink)var20_47, this.keyTypes, osz > 0, dismissOrder ? base.getScanDirection() : 0, orderByPos, base.recordCursorSupportsRandomAccess(), ac.getFramingMode(), ac.getRowsLo(), ac.getRowsLoKindPos(), ac.getRowsHi(), ac.getRowsHiKindPos(), ac.getExclusionKind(), ac.getExclusionKindPos(), baseMetadata.getTimestampIndex(), ac.isIgnoreNulls(), ac.getNullsDescPos());
                    try {
                        f = this.functionParser.parseFunction(ast, baseMetadata, executionContext);
                        if (!(f instanceof WindowFunction)) {
                            Misc.free(f);
                            throw SqlException.$(ast.position, "non-window function called in window context");
                        }
                        WindowFunction af = (WindowFunction)f;
                        functions.extendAndSet(i2, f);
                        if (osz > 0 && !dismissOrder || af.getPassCount() != 0) {
                            isFastPath = false;
                            break;
                        }
                    }
                    finally {
                        executionContext.clearWindowContext();
                    }
                    WindowFunction windowFunction = (WindowFunction)f;
                    windowFunction.setColumnIndex(i2);
                    factoryMetadata.add(new TableColumnMetadata(Chars.toString(queryColumn.getAlias()), windowFunction.getType(), false, 0, false, null));
                    continue;
                }
                int columnIndex = baseMetadata.getColumnIndexQuiet(queryColumn.getAst().token);
                TableColumnMetadata m = baseMetadata.getColumnMetadata(columnIndex);
                Function function = this.functionParser.parseFunction(queryColumn.getAst(), baseMetadata, executionContext);
                functions.extendAndSet(i2, function);
                if (baseMetadata.getTimestampIndex() != -1 && baseMetadata.getTimestampIndex() == columnIndex) {
                    factoryMetadata.setTimestampIndex(i2);
                }
                if (Chars.equalsIgnoreCase(queryColumn.getAst().token, queryColumn.getAlias())) {
                    factoryMetadata.add(i2, m);
                    continue;
                }
                factoryMetadata.add(i2, new TableColumnMetadata(Chars.toString(queryColumn.getAlias()), m.getColumnType(), m.isSymbolIndexFlag(), m.getIndexValueBlockCapacity(), m.isSymbolTableStatic(), baseMetadata));
            }
            if (isFastPath) {
                int n = functions.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    WindowColumn qc;
                    Function func = (Function)functions.getQuick(i2);
                    if (!(func instanceof WindowFunction) || (qc = (WindowColumn)columns.getQuick(i2)).getOrderBy().size() <= 0) continue;
                    chainTypes.clear();
                    ((WindowFunction)func).initRecordComparator(this, baseMetadata, chainTypes, null, qc.getOrderBy(), qc.getOrderByDirection());
                }
                return new WindowRecordCursorFactory(base, factoryMetadata, functions);
            }
            factoryMetadata.clear();
            Misc.freeObjListAndClear(functions);
            this.listColumnFilterA.clear();
            this.listColumnFilterB.clear();
            this.intHashSet.clear();
            IntList columnIndexes = new IntList();
            boolean bl = false;
            while (var15_21 < columnCount) {
                QueryColumn qc = columns.getQuick((int)var15_21);
                if (!qc.isWindowColumn()) {
                    int columnIndex = baseMetadata.getColumnIndexQuiet(qc.getAst().token);
                    TableColumnMetadata m = baseMetadata.getColumnMetadata(columnIndex);
                    chainMetadata.addIfNotExists((int)var15_21, m);
                    if (Chars.equalsIgnoreCase(qc.getAst().token, qc.getAlias())) {
                        factoryMetadata.add((int)var15_21, m);
                    } else {
                        factoryMetadata.add((int)var15_21, new TableColumnMetadata(Chars.toString(qc.getAlias()), m.getColumnType(), m.isSymbolIndexFlag(), m.getIndexValueBlockCapacity(), m.isSymbolTableStatic(), baseMetadata));
                    }
                    chainTypes.add((int)var15_21, m.getColumnType());
                    this.listColumnFilterA.extendAndSet((int)var15_21, (int)(var15_21 + true));
                    this.listColumnFilterB.extendAndSet((int)var15_21, columnIndex);
                    this.intHashSet.add(columnIndex);
                    columnIndexes.extendAndSet((int)var15_21, columnIndex);
                    if (baseMetadata.getTimestampIndex() != -1 && baseMetadata.getTimestampIndex() == columnIndex) {
                        factoryMetadata.setTimestampIndex((int)var15_21);
                    }
                }
                ++var15_21;
            }
            int n = columnCount;
            int n2 = baseMetadata.getColumnCount();
            for (i = 0; i < n2; ++i) {
                void var15_23;
                if (!this.intHashSet.excludes(i)) continue;
                TableColumnMetadata m = baseMetadata.getColumnMetadata(i);
                chainMetadata.add((int)var15_23, m);
                chainTypes.add((int)var15_23, m.getColumnType());
                this.listColumnFilterA.extendAndSet((int)var15_23, (int)(var15_23 + true));
                this.listColumnFilterB.extendAndSet((int)var15_23, i);
                columnIndexes.extendAndSet((int)var15_23, i);
                ++var15_23;
            }
            this.deferredWindowMetadata.clear();
            for (i = 0; i < columnCount; ++i) {
                Function f;
                int orderByPos;
                RecordSink partitionBySink;
                VirtualRecord partitionByRecord;
                QueryColumn qc = columns.getQuick(i);
                if (!qc.isWindowColumn()) continue;
                WindowColumn ac = (WindowColumn)qc;
                ExpressionNode ast = qc.getAst();
                partitionByFunctions = null;
                int n3 = ac.getPartitionBy().size();
                if (n3 > 0) {
                    partitionByFunctions = new ObjList(n3);
                    for (int j = 0; j < n3; ++j) {
                        Function function = this.functionParser.parseFunction(ac.getPartitionBy().getQuick(j), chainMetadata, executionContext);
                        partitionByFunctions.add(function);
                        if (!(function instanceof GroupByFunction)) continue;
                        throw SqlException.$(ast.position, "aggregate functions in partition by are not supported");
                    }
                }
                if (partitionByFunctions != null) {
                    partitionByRecord = new VirtualRecord(partitionByFunctions);
                    this.keyTypes.clear();
                    int partitionByCount = partitionByFunctions.size();
                    for (int j = 0; j < partitionByCount; ++j) {
                        this.keyTypes.add(((Function)partitionByFunctions.getQuick(j)).getType());
                    }
                    this.entityColumnFilter.of(partitionByCount);
                    partitionBySink = RecordSinkFactory.getInstance(this.asm, this.keyTypes, this.entityColumnFilter);
                } else {
                    partitionByRecord = null;
                    partitionBySink = null;
                }
                int osz = ac.getOrderBy().size();
                LowerCaseCharSequenceIntHashMap orderHash = model.getOrderHash();
                boolean dismissOrder = false;
                int timestampIdx = base.getMetadata().getTimestampIndex();
                int n4 = orderByPos = osz > 0 ? ac.getOrderBy().getQuick((int)0).position : -1;
                if (base.followedOrderByAdvice() && osz > 0 && orderHash.size() > 0) {
                    dismissOrder = true;
                    for (int j = 0; j < osz; ++j) {
                        ExpressionNode node = ac.getOrderBy().getQuick(j);
                        int direction = ac.getOrderByDirection().getQuick(j);
                        if (Chars.equalsIgnoreCase(node.token, (CharSequence)orderHash.keys().get(j)) && orderHash.get(node.token) == direction) continue;
                        dismissOrder = false;
                        break;
                    }
                }
                if (osz == 1 && timestampIdx != -1 && orderHash.size() < 2) {
                    ExpressionNode orderByNode = ac.getOrderBy().getQuick(0);
                    int orderByDirection = ac.getOrderByDirection().getQuick(0);
                    if (baseMetadata.getColumnIndexQuiet(orderByNode.token) == timestampIdx && (orderByDirection == 0 && base.getScanDirection() == 1 || orderByDirection == 1 && base.getScanDirection() == 2)) {
                        dismissOrder = true;
                    }
                }
                executionContext.configureWindowContext(partitionByRecord, partitionBySink, this.keyTypes, osz > 0, dismissOrder ? base.getScanDirection() : 0, orderByPos, base.recordCursorSupportsRandomAccess(), ac.getFramingMode(), ac.getRowsLo(), ac.getRowsLoKindPos(), ac.getRowsHi(), ac.getRowsHiKindPos(), ac.getExclusionKind(), ac.getExclusionKindPos(), chainMetadata.getTimestampIndex(), ac.isIgnoreNulls(), ac.getNullsDescPos());
                try {
                    f = this.functionParser.parseFunction(ast, chainMetadata, executionContext);
                    if (!(f instanceof WindowFunction)) {
                        Misc.free(f);
                        throw SqlException.$(ast.position, "non-window function called in window context");
                    }
                }
                finally {
                    executionContext.clearWindowContext();
                }
                WindowFunction windowFunction = (WindowFunction)f;
                if (osz > 0 && !dismissOrder) {
                    IntList directions = ac.getOrderByDirection();
                    if (windowFunction.getPass1ScanDirection() == WindowFunction.Pass1ScanDirection.BACKWARD) {
                        int size = directions.size();
                        for (int j = 0; j < size; ++j) {
                            directions.set(j, 1 - directions.getQuick(j));
                        }
                    }
                    IntList order = this.toOrderIndices(chainMetadata, ac.getOrderBy(), ac.getOrderByDirection());
                    windowFunction.initRecordComparator(this, chainMetadata, chainTypes, order, null, null);
                    ObjList<WindowFunction> funcs = this.groupedWindow.get(order);
                    if (funcs == null) {
                        funcs = new ObjList();
                        this.groupedWindow.put(order, funcs);
                    }
                    funcs.add(windowFunction);
                } else {
                    if (osz > 0) {
                        windowFunction.initRecordComparator(this, chainMetadata, chainTypes, null, ac.getOrderBy(), ac.getOrderByDirection());
                    }
                    if (naturalOrderFunctions == null) {
                        naturalOrderFunctions = new ObjList<WindowFunction>();
                    }
                    naturalOrderFunctions.add(windowFunction);
                }
                windowFunction.setColumnIndex(i);
                this.deferredWindowMetadata.extendAndSet(i, new TableColumnMetadata(Chars.toString(qc.getAlias()), windowFunction.getType(), false, 0, false, null));
                this.listColumnFilterA.extendAndSet(i, -i - 1);
            }
            n = this.deferredWindowMetadata.size();
            for (i = 0; i < n; ++i) {
                TableColumnMetadata m = this.deferredWindowMetadata.getQuick(i);
                if (m == null) continue;
                chainTypes.add(i, m.getColumnType());
                factoryMetadata.add(i, m);
            }
            ObjList<RecordComparator> windowComparators = new ObjList<RecordComparator>(this.groupedWindow.size());
            ObjList<ObjList<WindowFunction>> functionGroups = new ObjList<ObjList<WindowFunction>>(this.groupedWindow.size());
            ObjList<IntList> keys = new ObjList<IntList>();
            for (ObjObjHashMap.Entry entry : this.groupedWindow) {
                windowComparators.add(this.recordComparatorCompiler.newInstance(chainTypes, (IntList)entry.key));
                functionGroups.add((ObjList)entry.value);
                keys.add((IntList)entry.key);
            }
            RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, (ColumnTypes)chainTypes, (ColumnFilter)this.listColumnFilterA, this.listColumnFilterB, null);
            return new CachedWindowRecordCursorFactory(this.configuration, base, recordSink, factoryMetadata, chainTypes, windowComparators, functionGroups, naturalOrderFunctions, columnIndexes, keys, chainMetadata);
        }
        catch (Throwable th) {
            for (ObjObjHashMap.Entry<IntList, ObjList<WindowFunction>> entry : this.groupedWindow) {
                Misc.freeObjList((ObjList)entry.value);
            }
            Misc.free(base);
            Misc.freeObjList(functions);
            Misc.freeObjList(naturalOrderFunctions);
            Misc.freeObjList(partitionByFunctions);
            throw th;
        }
    }

    private RecordCursorFactory generateSetFactory(QueryModel model, RecordCursorFactory factoryA, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factoryB = null;
        ObjList<Function> castFunctionsA = null;
        ObjList<Function> castFunctionsB = null;
        try {
            factoryB = this.generateQuery0(model.getUnionModel(), executionContext, true);
            RecordMetadata metadataA = factoryA.getMetadata();
            RecordMetadata metadataB = factoryB.getMetadata();
            int positionA = model.getModelPosition();
            int positionB = model.getUnionModel().getModelPosition();
            switch (model.getSetOperationType()) {
                case 1: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, true);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : GenericRecordMetadata.removeTimestamp(metadataA);
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata, SET_UNION_CONSTRUCTOR);
                }
                case 0: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, true);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : GenericRecordMetadata.removeTimestamp(metadataA);
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateUnionAllFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata);
                }
                case 2: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata, SET_EXCEPT_CONSTRUCTOR);
                }
                case 3: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateIntersectOrExceptAllFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata, SET_EXCEPT_ALL_CONSTRUCTOR);
                }
                case 4: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata, SET_INTERSECT_CONSTRUCTOR);
                }
                case 5: {
                    RecordMetadata unionMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = unionMetadata = castIsRequired ? SqlCodeGenerator.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(unionMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(unionMetadata, metadataB, positionB);
                    }
                    return this.generateIntersectOrExceptAllFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, unionMetadata, SET_INTERSECT_ALL_CONSTRUCTOR);
                }
            }
            assert (false);
            return null;
        }
        catch (Throwable e) {
            Misc.free(factoryA);
            Misc.free(factoryB);
            Misc.freeObjList(castFunctionsA);
            Misc.freeObjList(castFunctionsB);
            throw e;
        }
    }

    private RecordCursorFactory generateSubQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        assert (model.getNestedModel() != null);
        return this.generateQuery(model.getNestedModel(), executionContext, true);
    }

    private RecordCursorFactory generateTableQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        boolean supportsRandomAccess;
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        CharSequence tableName = model.getTableName();
        if (Chars.startsWith(tableName, "*!*")) {
            BufferWindowCharSequence tab = (BufferWindowCharSequence)tableName;
            tab.shiftLo("*!*".length());
            supportsRandomAccess = false;
        } else {
            supportsRandomAccess = true;
        }
        TableToken tableToken = executionContext.getTableToken(tableName);
        if (model.isUpdate() && !executionContext.isWalApplication() && executionContext.getCairoEngine().isWalTable(tableToken)) {
            try (TableRecordMetadata metadata = executionContext.getMetadataForWrite(tableToken, model.getMetadataVersion());){
                RecordCursorFactory recordCursorFactory = this.generateTableQuery0(model, executionContext, latestBy, supportsRandomAccess, null, metadata);
                return recordCursorFactory;
            }
        }
        try (TableReader reader = executionContext.getReader(tableToken, model.getMetadataVersion());){
            RecordCursorFactory recordCursorFactory = this.generateTableQuery0(model, executionContext, latestBy, supportsRandomAccess, reader, reader.getMetadata());
            return recordCursorFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordCursorFactory generateTableQuery0(QueryModel model, SqlExecutionContext executionContext, ObjList<ExpressionNode> latestBy, boolean supportsRandomAccess, @Nullable TableReader reader, final TableRecordMetadata metadata) throws SqlException {
        ExpressionNode whereClause;
        ObjList<QueryColumn> topDownColumns = model.getTopDownColumns();
        int topDownColumnCount = topDownColumns.size();
        IntList columnIndexes = new IntList();
        IntList columnSizeShifts = new IntList();
        int readerTimestampIndex = this.getTimestampIndex(model, metadata);
        if (latestBy.size() > 0 && readerTimestampIndex != metadata.getTimestampIndex()) {
            throw SqlException.$(model.getTimestamp().position, "latest by over a table requires designated TIMESTAMP");
        }
        boolean requiresTimestamp = joinsRequiringTimestamp[model.getJoinType()];
        GenericRecordMetadata myMeta = new GenericRecordMetadata();
        try {
            if (requiresTimestamp) {
                executionContext.pushTimestampRequiredFlag(true);
            }
            boolean contextTimestampRequired = executionContext.isTimestampRequired();
            if (topDownColumnCount > 0 || contextTimestampRequired || model.isUpdate()) {
                for (int i = 0; i < topDownColumnCount; ++i) {
                    int columnIndex = metadata.getColumnIndexQuiet(topDownColumns.getQuick(i).getName());
                    int type = metadata.getColumnType(columnIndex);
                    int typeSize = ColumnType.sizeOf(type);
                    columnIndexes.add(columnIndex);
                    columnSizeShifts.add(Numbers.msb(typeSize));
                    myMeta.add(new TableColumnMetadata(Chars.toString(topDownColumns.getQuick(i).getName()), type, metadata.isColumnIndexed(columnIndex), metadata.getIndexValueBlockCapacity(columnIndex), metadata.isSymbolTableStatic(columnIndex), metadata.getMetadata(columnIndex), -1, false, 0, metadata.getColumnMetadata(columnIndex).isSymbolCacheFlag(), metadata.getColumnMetadata(columnIndex).getSymbolCapacity()));
                    if (columnIndex != readerTimestampIndex) continue;
                    myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                }
                if (readerTimestampIndex != -1 && myMeta.getTimestampIndex() == -1 && contextTimestampRequired) {
                    myMeta.add(new TableColumnMetadata(metadata.getColumnName(readerTimestampIndex), metadata.getColumnType(readerTimestampIndex), metadata.getMetadata(readerTimestampIndex)));
                    myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                    columnIndexes.add(readerTimestampIndex);
                    columnSizeShifts.add(Numbers.msb(8));
                }
            }
        }
        finally {
            if (requiresTimestamp) {
                executionContext.popTimestampRequiredFlag();
            }
        }
        if (reader == null) {
            return new AbstractRecordCursorFactory(myMeta){

                @Override
                public boolean recordCursorSupportsRandomAccess() {
                    return false;
                }

                @Override
                public boolean supportsUpdateRowId(TableToken tableToken) {
                    return metadata.getTableToken() == tableToken;
                }
            };
        }
        GenericRecordMetadata dfcFactoryMeta = GenericRecordMetadata.deepCopyOf(metadata);
        int latestByColumnCount = this.prepareLatestByColumnIndexes(latestBy, myMeta);
        TableToken tableToken = metadata.getTableToken();
        if (latestByColumnCount > 0 && this.configuration.useWithinLatestByOptimisation()) {
            ExpressionNode withinExtracted = this.whereClauseParser.extractWithin(model, model.getWhereClause(), myMeta, this.functionParser, executionContext, this.prefixes);
            boolean allSymbolsAreIndexed = true;
            if (this.prefixes.size() > 0) {
                for (int i = 0; i < latestByColumnCount; ++i) {
                    int idx = this.listColumnFilterA.getColumnIndexFactored(i);
                    if (ColumnType.isSymbol(myMeta.getColumnType(idx)) && myMeta.isColumnIndexed(idx)) continue;
                    allSymbolsAreIndexed = false;
                }
            }
            if (allSymbolsAreIndexed) {
                model.setWhereClause(withinExtracted);
            }
        }
        if ((whereClause = model.getWhereClause()) != null || executionContext.isOverriddenIntrinsics(reader.getTableToken())) {
            ObjList<ExpressionNode> orderByAdvice;
            int orderByAdviceSize;
            int indexDirection;
            boolean orderByKeyColumn;
            boolean intervalHitsOnlyOnePartition;
            AbstractPartitionFrameCursorFactory dfcFactory;
            int order;
            IntrinsicModel intrinsicModel;
            if (whereClause != null) {
                int latestByIndex;
                CharSequence preferredKeyColumn = null;
                if (latestByColumnCount == 1 && ColumnType.isSymbol(myMeta.getColumnType(latestByIndex = this.listColumnFilterA.getColumnIndexFactored(0)))) {
                    preferredKeyColumn = latestBy.getQuick((int)0).token;
                }
                intrinsicModel = this.whereClauseParser.extract(model, whereClause, metadata, preferredKeyColumn, readerTimestampIndex, this.functionParser, myMeta, executionContext, latestByColumnCount > 1, reader);
            } else {
                intrinsicModel = this.whereClauseParser.getEmpty();
            }
            executionContext.overrideWhereIntrinsics(reader.getTableToken(), intrinsicModel);
            model.setWhereClause(null);
            if (intrinsicModel.intrinsicValue == 2) {
                return new EmptyTableRecordCursorFactory(myMeta);
            }
            if (latestByColumnCount > 0) {
                Function filter = this.compileFilter(intrinsicModel, myMeta, executionContext);
                if (filter != null && filter.isConstant() && !filter.getBool(null)) {
                    model.getLatestBy().clear();
                    Misc.free(filter);
                    return new EmptyTableRecordCursorFactory(myMeta);
                }
                this.prepareLatestByColumnIndexes(latestBy, myMeta);
                return this.generateLatestByTableQuery(model, reader, myMeta, tableToken, intrinsicModel, filter, executionContext, readerTimestampIndex, columnIndexes, columnSizeShifts, this.prefixes);
            }
            int n = order = model.isForceBackwardScan() ? 1 : 0;
            if (intrinsicModel.hasIntervalFilters()) {
                RuntimeIntrinsicIntervalModel intervalModel = intrinsicModel.buildIntervalModel();
                dfcFactory = new IntervalPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), intervalModel, readerTimestampIndex, dfcFactoryMeta, order);
                intervalHitsOnlyOnePartition = intervalModel.allIntervalsHitOnePartition(reader.getPartitionedBy());
            } else {
                dfcFactory = new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, order);
                boolean bl = intervalHitsOnlyOnePartition = reader.getPartitionedBy() == 3;
            }
            if (intrinsicModel.keyColumn != null) {
                ObjList<ExpressionNode> orderByAdvice2;
                int orderByAdviceSize2;
                int keyColumnIndex = myMeta.getColumnIndexQuiet(intrinsicModel.keyColumn);
                int nKeyValues = intrinsicModel.keyValueFuncs.size();
                int nKeyExcludedValues = intrinsicModel.keyExcludedValueFuncs.size();
                if (intrinsicModel.keySubQuery != null) {
                    Function filter;
                    Record.CharSequenceFunction func;
                    RecordCursorFactory rcf = null;
                    try {
                        rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                        func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                        filter = this.compileFilter(intrinsicModel, myMeta, executionContext);
                    }
                    catch (Throwable th) {
                        Misc.free(dfcFactory);
                        Misc.free(rcf);
                        throw th;
                    }
                    if (filter != null && filter.isConstant() && !filter.getBool(null)) {
                        Misc.free(dfcFactory);
                        return new EmptyTableRecordCursorFactory(myMeta);
                    }
                    return new FilterOnSubQueryRecordCursorFactory(this.configuration, myMeta, dfcFactory, rcf, keyColumnIndex, filter, func, columnIndexes, columnSizeShifts);
                }
                assert (nKeyValues > 0 || nKeyExcludedValues > 0);
                orderByKeyColumn = false;
                indexDirection = 1;
                if (intervalHitsOnlyOnePartition && (orderByAdviceSize2 = (orderByAdvice2 = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize2 < 3) {
                    this.guardAgainstDotsInOrderByAdvice(model);
                    if (Chars.equals(orderByAdvice2.getQuick((int)0).token, intrinsicModel.keyColumn)) {
                        myMeta.setTimestampIndex(-1);
                        if (orderByAdviceSize2 == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice2.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                                indexDirection = 2;
                            }
                        }
                    }
                }
                boolean orderByTimestamp = false;
                if (!orderByKeyColumn && this.isOrderByDesignatedTimestampOnly(model)) {
                    int orderByDirection = SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0);
                    if (nKeyValues == 1 || nKeyValues > 1 && orderByDirection == 0) {
                        orderByTimestamp = true;
                        if (orderByDirection == 1) {
                            indexDirection = 2;
                        }
                    } else if (nKeyExcludedValues > 0 && orderByDirection == 0) {
                        orderByTimestamp = true;
                    }
                }
                if (nKeyExcludedValues == 0) {
                    Function filter;
                    try {
                        filter = this.compileFilter(intrinsicModel, myMeta, executionContext);
                    }
                    catch (Throwable th) {
                        Misc.free(dfcFactory);
                        throw th;
                    }
                    if (filter != null && filter.isConstant()) {
                        try {
                            if (!filter.getBool(null)) {
                                Misc.free(dfcFactory);
                                EmptyTableRecordCursorFactory th = new EmptyTableRecordCursorFactory(myMeta);
                                return th;
                            }
                        }
                        finally {
                            filter = Misc.free(filter);
                        }
                    }
                    if (nKeyValues == 1) {
                        int symbolKey;
                        Function symbolFunc = intrinsicModel.keyValueFuncs.get(0);
                        SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(keyColumnIndex));
                        int n2 = symbolKey = symbolFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolFunc.getStrA(null));
                        FunctionBasedRowCursorFactory rcf = symbolKey == -2 ? (filter == null ? new DeferredSymbolIndexRowCursorFactory(keyColumnIndex, symbolFunc, true, indexDirection) : new DeferredSymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolFunc, filter, true, indexDirection)) : (filter == null ? new SymbolIndexRowCursorFactory(keyColumnIndex, symbolKey, true, indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolKey, filter, true, indexDirection, null));
                        if (filter == null) {
                            return new DeferredSingleSymbolFilterPageFrameRecordCursorFactory(this.configuration, keyColumnIndex, symbolFunc, rcf, myMeta, dfcFactory, orderByKeyColumn || orderByTimestamp, columnIndexes, columnSizeShifts, supportsRandomAccess);
                        }
                        return new PageFrameRecordCursorFactory(this.configuration, myMeta, dfcFactory, rcf, orderByKeyColumn || orderByTimestamp, filter, false, columnIndexes, columnSizeShifts, supportsRandomAccess, false);
                    }
                    if (orderByKeyColumn) {
                        myMeta.setTimestampIndex(-1);
                    }
                    return new FilterOnValuesRecordCursorFactory(this.configuration, myMeta, dfcFactory, intrinsicModel.keyValueFuncs, keyColumnIndex, reader, filter, model.getOrderByAdviceMnemonic(), orderByKeyColumn, orderByTimestamp, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0), indexDirection, columnIndexes, columnSizeShifts);
                }
                if (nKeyExcludedValues > 0) {
                    if (reader.getSymbolMapReader(columnIndexes.getQuick(keyColumnIndex)).getSymbolCount() < this.configuration.getMaxSymbolNotEqualsCount()) {
                        Function filter;
                        try {
                            filter = this.compileFilter(intrinsicModel, myMeta, executionContext);
                        }
                        catch (Throwable th) {
                            Misc.free(dfcFactory);
                            throw th;
                        }
                        if (filter != null && filter.isConstant()) {
                            try {
                                if (!filter.getBool(null)) {
                                    Misc.free(dfcFactory);
                                    EmptyTableRecordCursorFactory th = new EmptyTableRecordCursorFactory(myMeta);
                                    return th;
                                }
                            }
                            finally {
                                filter = Misc.free(filter);
                            }
                        }
                        return new FilterOnExcludedValuesRecordCursorFactory(this.configuration, myMeta, dfcFactory, intrinsicModel.keyExcludedValueFuncs, keyColumnIndex, filter, model.getOrderByAdviceMnemonic(), orderByKeyColumn, orderByTimestamp, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0), indexDirection, columnIndexes, columnSizeShifts, this.configuration.getMaxSymbolNotEqualsCount());
                    }
                    if (intrinsicModel.keyExcludedNodes.size() > 0) {
                        ExpressionNode root = intrinsicModel.keyExcludedNodes.getQuick(0);
                        int n3 = intrinsicModel.keyExcludedNodes.size();
                        for (int i = 1; i < n3; ++i) {
                            ExpressionNode expression = intrinsicModel.keyExcludedNodes.getQuick(i);
                            OperatorExpression andOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("and");
                            ExpressionNode newRoot = this.expressionNodePool.next().of(9, andOp.operator.token, andOp.precedence, 0);
                            newRoot.paramCount = 2;
                            newRoot.lhs = expression;
                            newRoot.rhs = root;
                            root = newRoot;
                        }
                        if (intrinsicModel.filter == null) {
                            intrinsicModel.filter = root;
                        } else {
                            OperatorExpression andOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("and");
                            ExpressionNode filter = this.expressionNodePool.next().of(9, andOp.operator.token, andOp.precedence, 0);
                            filter.paramCount = 2;
                            filter.lhs = intrinsicModel.filter;
                            filter.rhs = root;
                            intrinsicModel.filter = filter;
                        }
                    }
                }
            }
            if (intervalHitsOnlyOnePartition && intrinsicModel.filter == null && (orderByAdviceSize = (orderByAdvice = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize < 3 && intrinsicModel.hasIntervalFilters()) {
                this.guardAgainstDotsInOrderByAdvice(model);
                int columnIndex = myMeta.getColumnIndexQuiet(model.getOrderByAdvice().getQuick((int)0).token);
                assert (columnIndex > -1);
                if (myMeta.isColumnIndexed(columnIndex)) {
                    orderByKeyColumn = false;
                    indexDirection = 1;
                    if (orderByAdviceSize == 1) {
                        orderByKeyColumn = true;
                    } else if (Chars.equals(orderByAdvice.getQuick((int)1).token, model.getTimestamp().token)) {
                        orderByKeyColumn = true;
                        if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                            indexDirection = 2;
                        }
                    }
                    if (orderByKeyColumn) {
                        myMeta.setTimestampIndex(-1);
                        return new SortedSymbolIndexRecordCursorFactory(this.configuration, myMeta, dfcFactory, columnIndex, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0) == 0, indexDirection, columnIndexes, columnSizeShifts);
                    }
                }
            }
            PageFrameRowCursorFactory rowFactory = new PageFrameRowCursorFactory(model.isForceBackwardScan() ? 1 : 0);
            model.setWhereClause(intrinsicModel.filter);
            return new PageFrameRecordCursorFactory(this.configuration, myMeta, dfcFactory, rowFactory, false, null, true, columnIndexes, columnSizeShifts, supportsRandomAccess, false);
        }
        if (latestByColumnCount == 0) {
            int order = model.isForceBackwardScan() ? 1 : 0;
            FullPartitionFrameCursorFactory cursorFactory = new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, order);
            PageFrameRowCursorFactory rowCursorFactory = new PageFrameRowCursorFactory(order);
            return new PageFrameRecordCursorFactory(this.configuration, myMeta, cursorFactory, rowCursorFactory, model.isOrderDescendingByDesignatedTimestampOnly(), null, true, columnIndexes, columnSizeShifts, supportsRandomAccess, false);
        }
        model.getLatestBy().clear();
        if (latestByColumnCount == 1) {
            int latestByColumnIndex = this.listColumnFilterA.getColumnIndexFactored(0);
            if (myMeta.isColumnIndexed(latestByColumnIndex)) {
                return new LatestByAllIndexedRecordCursorFactory(this.configuration, myMeta, new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, 1), this.listColumnFilterA.getColumnIndexFactored(0), columnIndexes, columnSizeShifts, this.prefixes);
            }
            if (ColumnType.isSymbol(myMeta.getColumnType(latestByColumnIndex)) && myMeta.isSymbolTableStatic(latestByColumnIndex)) {
                return new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, myMeta, new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, 1), latestByColumnIndex, null, columnIndexes, columnSizeShifts);
            }
        }
        boolean symbolKeysOnly = true;
        int n = this.keyTypes.getColumnCount();
        for (int i = 0; i < n; ++i) {
            symbolKeysOnly &= ColumnType.isSymbol(this.keyTypes.getColumnType(i));
        }
        if (symbolKeysOnly) {
            IntList partitionByColumnIndexes = new IntList(this.listColumnFilterA.size());
            int n4 = this.listColumnFilterA.size();
            for (int i = 0; i < n4; ++i) {
                partitionByColumnIndexes.add(this.listColumnFilterA.getColumnIndexFactored(i));
            }
            return new LatestByAllSymbolsFilteredRecordCursorFactory(this.configuration, myMeta, new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, 1), RecordSinkFactory.getInstance(this.asm, myMeta, this.listColumnFilterA), this.keyTypes, partitionByColumnIndexes, null, null, columnIndexes, columnSizeShifts);
        }
        return new LatestByAllFilteredRecordCursorFactory(this.configuration, myMeta, new FullPartitionFrameCursorFactory(tableToken, model.getMetadataVersion(), dfcFactoryMeta, 1), RecordSinkFactory.getInstance(this.asm, myMeta, this.listColumnFilterA), this.keyTypes, null, columnIndexes, columnSizeShifts);
    }

    private RecordCursorFactory generateUnionAllFactory(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordMetadata unionMetadata) throws SqlException {
        UnionAllRecordCursorFactory unionFactory = new UnionAllRecordCursorFactory(unionMetadata, factoryA, factoryB, castFunctionsA, castFunctionsB);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionFactory, executionContext);
        }
        return unionFactory;
    }

    private RecordCursorFactory generateUnionFactory(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordMetadata unionMetadata, SetRecordCursorFactoryConstructor constructor) throws SqlException {
        this.writeSymbolAsString.clear();
        this.valueTypes.clear();
        this.keyTypes.clear();
        int n = unionMetadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int columnType = unionMetadata.getColumnType(i);
            if (ColumnType.isSymbol(columnType)) {
                this.keyTypes.add(11);
                this.writeSymbolAsString.set(i);
                continue;
            }
            this.keyTypes.add(columnType);
        }
        this.entityColumnFilter.of(factoryA.getMetadata().getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, unionMetadata, this.entityColumnFilter, this.writeSymbolAsString);
        RecordCursorFactory unionFactory = constructor.create(this.configuration, unionMetadata, factoryA, factoryB, castFunctionsA, castFunctionsB, recordSink, this.keyTypes, this.valueTypes);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionFactory, executionContext);
        }
        return unionFactory;
    }

    @Nullable
    private Function getHiFunction(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.toLimitFunction(executionContext, model.getLimitHi(), null);
    }

    @Nullable
    private Function getLimitLoFunctionOnly(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (model.getLimitAdviceLo() != null && model.getLimitAdviceHi() == null) {
            return this.toLimitFunction(executionContext, model.getLimitAdviceLo(), LongConstant.ZERO);
        }
        return null;
    }

    @NotNull
    private Function getLoFunction(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.toLimitFunction(executionContext, model.getLimitLo(), LongConstant.ZERO);
    }

    private int getSampleBySymbolKeyIndex(QueryModel model, RecordMetadata metadata) {
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            int idx;
            int columnType;
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type != 7 || (columnType = metadata.getColumnType(idx = metadata.getColumnIndex(node.token))) != 12) continue;
            return idx;
        }
        return -1;
    }

    private int getTimestampIndex(QueryModel model, RecordCursorFactory factory) throws SqlException {
        return this.getTimestampIndex(model, factory.getMetadata());
    }

    private int getTimestampIndex(QueryModel model, RecordMetadata metadata) throws SqlException {
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null) {
            int timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
            if (timestampIndex == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
            if (!ColumnType.isTimestamp(metadata.getColumnType(timestampIndex))) {
                throw SqlException.$(timestamp.position, "not a TIMESTAMP");
            }
            return timestampIndex;
        }
        return metadata.getTimestampIndex();
    }

    private void guardAgainstDotsInOrderByAdvice(QueryModel model) throws SqlException {
        ObjList<ExpressionNode> advice = model.getOrderByAdvice();
        int n = advice.size();
        for (int i = 0; i < n; ++i) {
            if (Chars.indexOf(advice.getQuick((int)i).token, '.') <= -1) continue;
            throw SqlException.$(advice.getQuick((int)i).position, "cannot use table-prefixed names in order by");
        }
    }

    private void guardAgainstFillWithKeyedGroupBy(QueryModel model, ArrayColumnTypes keyTypes) throws SqlException {
        QueryModel curr;
        for (curr = model; curr != null && curr.getFillStride() == null; curr = curr.getNestedModel()) {
        }
        if (curr == null || curr.getFillStride() == null || curr.getFillValues() == null || curr.getFillValues().size() == 0) {
            return;
        }
        if (curr.getFillValues().size() == 1 && SqlKeywords.isNoneKeyword(curr.getFillValues().getQuick((int)0).token)) {
            return;
        }
        if (keyTypes.getColumnCount() == 1) {
            return;
        }
        throw SqlException.$(0, "cannot use FILL with a keyed GROUP BY");
    }

    private void guardAgainstFromToWithKeyedSampleBy(boolean isFromTo) throws SqlException {
        if (isFromTo) {
            throw SqlException.$(0, "FROM-TO intervals are not supported for keyed SAMPLE BY queries");
        }
    }

    private boolean isKeyedTemporalJoin(RecordMetadata masterMetadata, RecordMetadata slaveMetadata) {
        if (this.listColumnFilterA.size() == 1 && this.listColumnFilterB.size() == 1) {
            int masterIndex = this.listColumnFilterB.getColumnIndexFactored(0);
            int slaveIndex = this.listColumnFilterA.getColumnIndexFactored(0);
            return masterIndex != masterMetadata.getTimestampIndex() || slaveIndex != slaveMetadata.getTimestampIndex();
        }
        return this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0;
    }

    private boolean isOrderByDesignatedTimestampOnly(QueryModel model) {
        return model.getOrderByAdvice().size() == 1 && model.getTimestamp() != null && Chars.equalsIgnoreCase(model.getOrderByAdvice().getQuick((int)0).token, model.getTimestamp().token);
    }

    private boolean isSameTable(RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory) {
        return masterFactory.getTableToken() != null && masterFactory.getTableToken().equals(slaveFactory.getTableToken());
    }

    private ExpressionNode locatePotentiallyFurtherNestedWhereClause(QueryModel model) {
        QueryModel curr = model;
        ExpressionNode expr = curr.getWhereClause();
        while (curr.isSkipped() && expr == null) {
            expr = curr.getWhereClause();
            curr = curr.getNestedModel();
        }
        if (expr == null) {
            expr = curr.getWhereClause();
        }
        return expr;
    }

    private void lookupColumnIndexes(ListColumnFilter filter, ObjList<ExpressionNode> columnNames, RecordMetadata metadata) throws SqlException {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = columnNames.getQuick((int)i).token;
            int columnIndex = metadata.getColumnIndexQuiet(columnName);
            if (columnIndex <= -1) {
                int dot = Chars.indexOfLastUnquoted(columnName, '.');
                if (dot > -1 && (columnIndex = metadata.getColumnIndexQuiet(columnName, dot + 1, columnName.length())) > -1) {
                    filter.add(columnIndex + 1);
                    return;
                }
                throw SqlException.invalidColumn(columnNames.getQuick((int)i).position, columnName);
            }
            filter.add(columnIndex + 1);
        }
    }

    private void lookupColumnIndexesUsingVanillaNames(ListColumnFilter filter, ObjList<CharSequence> columnNames, RecordMetadata metadata) {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            filter.add(metadata.getColumnIndex(columnNames.getQuick(i)) + 1);
        }
    }

    private int prepareLatestByColumnIndexes(ObjList<ExpressionNode> latestBy, RecordMetadata myMeta) throws SqlException {
        this.keyTypes.clear();
        this.listColumnFilterA.clear();
        int latestByColumnCount = latestBy.size();
        if (latestByColumnCount > 0) {
            block3: for (int i = 0; i < latestByColumnCount; ++i) {
                ExpressionNode latestByNode = latestBy.getQuick(i);
                int index = myMeta.getColumnIndexQuiet(latestByNode.token);
                if (index == -1) {
                    throw SqlException.invalidColumn(latestByNode.position, latestByNode.token);
                }
                int columnType = myMeta.getColumnType(index);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: {
                        this.keyTypes.add(columnType);
                        this.listColumnFilterA.add(index + 1);
                        continue block3;
                    }
                    default: {
                        throw SqlException.position(latestByNode.position).put(latestByNode.token).put(" (").put(ColumnType.nameOf(columnType)).put("): invalid type, only [BOOLEAN, BYTE, SHORT, INT, LONG, DATE, TIMESTAMP, FLOAT, DOUBLE, LONG128, LONG256, CHAR, STRING, VARCHAR, SYMBOL, UUID, GEOHASH, IPv4] are supported in LATEST ON");
                    }
                }
            }
        }
        return latestByColumnCount;
    }

    private void processJoinContext(boolean vanillaMaster, boolean selfJoin, JoinContext jc, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterA, jc.aNames, slaveMetadata);
        if (vanillaMaster) {
            this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterB, jc.bNames, masterMetadata);
        } else {
            this.lookupColumnIndexes(this.listColumnFilterB, jc.bNodes, masterMetadata);
        }
        this.keyTypes.clear();
        this.writeSymbolAsString.clear();
        this.writeStringAsVarcharA.clear();
        this.writeStringAsVarcharB.clear();
        int m = this.listColumnFilterA.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int columnIndexA = this.listColumnFilterA.getColumnIndexFactored(k);
            int columnIndexB = this.listColumnFilterB.getColumnIndexFactored(k);
            int columnTypeA = slaveMetadata.getColumnType(columnIndexA);
            String columnNameA = slaveMetadata.getColumnName(columnIndexA);
            int columnTypeB = masterMetadata.getColumnType(columnIndexB);
            String columnNameB = masterMetadata.getColumnName(columnIndexB);
            if (!(columnTypeB == columnTypeA || ColumnType.isSymbolOrStringOrVarchar(columnTypeB) && ColumnType.isSymbolOrStringOrVarchar(columnTypeA))) {
                throw SqlException.$(jc.aNodes.getQuick((int)k).position, "join column type mismatch");
            }
            if (ColumnType.isVarchar(columnTypeA) || ColumnType.isVarchar(columnTypeB)) {
                this.keyTypes.add(26);
                if (ColumnType.isVarchar(columnTypeA)) {
                    this.writeStringAsVarcharB.set(columnIndexB);
                } else {
                    this.writeStringAsVarcharA.set(columnIndexA);
                }
                this.writeSymbolAsString.set(columnIndexA);
                this.writeSymbolAsString.set(columnIndexB);
                continue;
            }
            if (columnTypeB == 12) {
                if (selfJoin && Chars.equalsIgnoreCase(columnNameA, columnNameB)) {
                    this.keyTypes.add(12);
                    continue;
                }
                this.keyTypes.add(11);
                this.writeSymbolAsString.set(columnIndexA);
                this.writeSymbolAsString.set(columnIndexB);
                continue;
            }
            if (ColumnType.isString(columnTypeA) || ColumnType.isString(columnTypeB)) {
                this.keyTypes.add(columnTypeB);
                this.writeSymbolAsString.set(columnIndexA);
                this.writeSymbolAsString.set(columnIndexB);
                continue;
            }
            this.keyTypes.add(columnTypeB);
        }
    }

    private void processNodeQueryModels(ExpressionNode node, ModelOperator operator) {
        this.sqlNodeStack.clear();
        while (node != null) {
            if (node.queryModel != null) {
                operator.operate(this.expressionNodePool, node.queryModel);
            }
            if (node.lhs != null) {
                this.sqlNodeStack.push(node.lhs);
            }
            if (node.rhs != null) {
                node = node.rhs;
                continue;
            }
            if (!this.sqlNodeStack.isEmpty()) {
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = null;
        }
    }

    private void restoreWhereClause(ExpressionNode node) {
        this.processNodeQueryModels(node, RESTORE_WHERE_CLAUSE);
    }

    private Function toLimitFunction(SqlExecutionContext executionContext, ExpressionNode limit, ConstantFunction defaultValue) throws SqlException {
        if (limit == null) {
            return defaultValue;
        }
        Function limitFunc = this.functionParser.parseFunction(limit, EmptyRecordMetadata.INSTANCE, executionContext);
        SqlCodeGenerator.coerceRuntimeConstantType(limitFunc, (short)6, executionContext, "LIMIT expressions must be convertible to INT", limit.position);
        int limitFuncType = limitFunc.getType();
        if (limitTypes.excludes(limitFuncType)) {
            throw SqlException.$(limit.position, "invalid type: ").put(ColumnType.nameOf(limitFuncType));
        }
        return limitFunc;
    }

    private void validateBothTimestampOrders(RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int position) throws SqlException {
        if (masterFactory.getScanDirection() != 1) {
            throw SqlException.$(position, "left side of time series join doesn't have ASC timestamp order");
        }
        if (slaveFactory.getScanDirection() != 1) {
            throw SqlException.$(position, "right side of time series join doesn't have ASC timestamp order");
        }
    }

    private void validateBothTimestamps(QueryModel slaveModel, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        if (masterMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "left side of time series join has no timestamp");
        }
        if (slaveMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "right side of time series join has no timestamp");
        }
    }

    private void validateOuterJoinExpressions(QueryModel model, CharSequence joinType) throws SqlException {
        if (model.getOuterJoinExpressionClause() != null) {
            throw SqlException.$(model.getOuterJoinExpressionClause().position, "unsupported ").put(joinType).put(" join expression ").put("[expr='").put(model.getOuterJoinExpressionClause()).put("']");
        }
    }

    private Record.CharSequenceFunction validateSubQueryColumnAndGetGetter(IntrinsicModel intrinsicModel, RecordMetadata metadata) throws SqlException {
        int columnType = metadata.getColumnType(0);
        switch (columnType) {
            case 11: {
                return Record.GET_STR;
            }
            case 12: {
                return Record.GET_SYM;
            }
            case 26: {
                return Record.GET_VARCHAR;
            }
        }
        assert (intrinsicModel.keySubQuery.getColumns() != null);
        assert (intrinsicModel.keySubQuery.getColumns().size() > 0);
        throw SqlException.position(intrinsicModel.keySubQuery.getColumns().getQuick((int)0).getAst().position).put("unsupported column type: ").put(metadata.getColumnName(0)).put(": ").put(ColumnType.nameOf(columnType));
    }

    void setEnableJitNullChecks(boolean value) {
        this.enableJitNullChecks = value;
    }

    void setFullFatJoins(boolean fullFatJoins) {
        this.fullFatJoins = fullFatJoins;
    }

    static {
        SqlCodeGenerator.joinsRequiringTimestamp[1] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[2] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[3] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[4] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[5] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[6] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[7] = false;
        limitTypes.add(6);
        limitTypes.add(2);
        limitTypes.add(3);
        limitTypes.add(5);
        limitTypes.add(0);
        countConstructors.put(10, CountDoubleVectorAggregateFunction::new);
        countConstructors.put(5, CountIntVectorAggregateFunction::new);
        countConstructors.put(6, CountLongVectorAggregateFunction::new);
        countConstructors.put(7, CountLongVectorAggregateFunction::new);
        countConstructors.put(8, CountLongVectorAggregateFunction::new);
        sumConstructors.put(10, SumDoubleVectorAggregateFunction::new);
        sumConstructors.put(5, SumIntVectorAggregateFunction::new);
        sumConstructors.put(6, SumLongVectorAggregateFunction::new);
        sumConstructors.put(13, SumLong256VectorAggregateFunction::new);
        sumConstructors.put(3, SumShortVectorAggregateFunction::new);
        ksumConstructors.put(10, KSumDoubleVectorAggregateFunction::new);
        nsumConstructors.put(10, NSumDoubleVectorAggregateFunction::new);
        avgConstructors.put(10, AvgDoubleVectorAggregateFunction::new);
        avgConstructors.put(6, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(5, AvgIntVectorAggregateFunction::new);
        avgConstructors.put(3, AvgShortVectorAggregateFunction::new);
        minConstructors.put(10, MinDoubleVectorAggregateFunction::new);
        minConstructors.put(6, MinLongVectorAggregateFunction::new);
        minConstructors.put(7, MinDateVectorAggregateFunction::new);
        minConstructors.put(8, MinTimestampVectorAggregateFunction::new);
        minConstructors.put(5, MinIntVectorAggregateFunction::new);
        minConstructors.put(3, MinShortVectorAggregateFunction::new);
        maxConstructors.put(10, MaxDoubleVectorAggregateFunction::new);
        maxConstructors.put(6, MaxLongVectorAggregateFunction::new);
        maxConstructors.put(7, MaxDateVectorAggregateFunction::new);
        maxConstructors.put(8, MaxTimestampVectorAggregateFunction::new);
        maxConstructors.put(5, MaxIntVectorAggregateFunction::new);
        maxConstructors.put(3, MaxShortVectorAggregateFunction::new);
    }

    private static class RecordCursorFactoryStub
    implements RecordCursorFactory {
        final ExecutionModel model;
        RecordCursorFactory factory;

        protected RecordCursorFactoryStub(ExecutionModel model, RecordCursorFactory factory) {
            this.model = model;
            this.factory = factory;
        }

        @Override
        public void close() {
            this.factory = Misc.free(this.factory);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
            if (this.factory != null) {
                return this.factory.getCursor(executionContext);
            }
            return null;
        }

        @Override
        public RecordMetadata getMetadata() {
            return null;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(this.model.getTypeName());
            CharSequence tableName = this.model.getTableName();
            if (tableName != null) {
                sink.meta(this.model.getModelType() == 8 ? "view" : "table").val(tableName);
            }
            if (this.factory != null) {
                sink.child(this.factory);
            }
        }
    }

    @FunctionalInterface
    static interface ModelOperator {
        public void operate(ObjectPool<ExpressionNode> var1, QueryModel var2);
    }

    @FunctionalInterface
    public static interface FullFatJoinGenerator {
        public RecordCursorFactory create(CairoConfiguration var1, RecordMetadata var2, RecordCursorFactory var3, RecordCursorFactory var4, ColumnTypes var5, ColumnTypes var6, ColumnTypes var7, RecordSink var8, RecordSink var9, int var10, RecordValueSink var11, IntList var12, JoinContext var13, ColumnFilter var14, long var15, int var17);
    }
}

