/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.str.DirectUtf8Sequence;

public final class GeoHashAdapter
extends AbstractTypeAdapter {
    private static final IntObjHashMap<GeoHashAdapter> typeToAdapterMap = new IntObjHashMap();
    private final int type;

    private GeoHashAdapter(int type) {
        this.type = type;
    }

    public static GeoHashAdapter getInstance(int columnType) {
        int index = typeToAdapterMap.keyIndex(columnType);
        if (index > -1) {
            return null;
        }
        return typeToAdapterMap.valueAtQuick(index);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) {
        row.putGeoVarchar(column, SqlKeywords.isNullKeyword(value) ? null : value);
    }

    static {
        for (int b = 1; b <= 60; ++b) {
            int type = ColumnType.getGeoHashTypeWithBits(b);
            typeToAdapterMap.put(type, new GeoHashAdapter(type));
        }
    }
}

