/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxReader;
import io.questdb.cutlass.line.tcp.DirectUtf8SymbolLookup;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8StringIntHashMap;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class SymbolCache
implements DirectUtf8SymbolLookup,
Closeable {
    private final MicrosecondClock clock;
    private final SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl();
    private final Utf8StringIntHashMap symbolValueToKeyMap = new Utf8StringIntHashMap(256, 0.5, -2);
    private final StringSink tempSink = new StringSink();
    private final long waitIntervalBeforeReload;
    private int columnIndex;
    private long lastSymbolReaderReloadTimestamp;
    private int symbolIndexInTxFile;
    private TxReader txReader;
    private TableWriterAPI writerAPI;

    public SymbolCache(LineTcpReceiverConfiguration configuration) {
        this(configuration.getMicrosecondClock(), configuration.getSymbolCacheWaitBeforeReload());
    }

    public SymbolCache(MicrosecondClock microsecondClock, long waitIntervalBeforeReload) {
        this.clock = microsecondClock;
        this.waitIntervalBeforeReload = waitIntervalBeforeReload;
    }

    @Override
    public void close() {
        this.txReader = null;
        this.writerAPI = null;
        this.symbolMapReader.close();
        this.symbolValueToKeyMap.reset();
    }

    public int getCacheCapacity() {
        return this.symbolValueToKeyMap.capacity();
    }

    public int getCacheValueCount() {
        return this.symbolValueToKeyMap.size();
    }

    @Override
    public int keyOf(DirectUtf8Sequence value) {
        int symbolValueCount;
        int index = this.symbolValueToKeyMap.keyIndex(value);
        if (index < 0) {
            return this.symbolValueToKeyMap.valueAt(index);
        }
        long ticks = this.clock.getTicks();
        if (ticks - this.lastSymbolReaderReloadTimestamp > this.waitIntervalBeforeReload && (symbolValueCount = this.readSymbolCount(this.symbolIndexInTxFile, true)) > this.symbolMapReader.getSymbolCount()) {
            this.symbolMapReader.updateSymbolCount(symbolValueCount);
            this.lastSymbolReaderReloadTimestamp = ticks;
        }
        Utf8s.utf8ToUtf16Unchecked(value, this.tempSink);
        int symbolKey = this.symbolMapReader.keyOf(this.tempSink);
        if (symbolKey != -2) {
            this.symbolValueToKeyMap.putAt(index, Utf8String.newInstance(value), symbolKey);
        }
        return symbolKey;
    }

    public void of(CairoConfiguration configuration, TableWriterAPI writerAPI, int columnIndex, Path path, CharSequence columnName, int symbolIndexInTxFile, TxReader txReader, long columnNameTxn) {
        this.writerAPI = writerAPI;
        this.columnIndex = columnIndex;
        this.symbolIndexInTxFile = symbolIndexInTxFile;
        int plen = path.size();
        this.txReader = txReader;
        int symCount = this.readSymbolCount(symbolIndexInTxFile, false);
        path.trimTo(plen);
        this.symbolMapReader.of(configuration, path, columnName, columnNameTxn, symCount);
        this.symbolValueToKeyMap.clear();
    }

    private int readSymbolCount(int symbolIndexInTxFile, boolean initialStateOk) {
        int watermark = this.writerAPI.getSymbolCountWatermark(this.columnIndex);
        if (watermark != -1) {
            return watermark;
        }
        return this.safeReadUncommittedSymbolCount(symbolIndexInTxFile, initialStateOk);
    }

    private int safeReadUncommittedSymbolCount(int symbolIndexInTxFile, boolean initialStateOk) {
        boolean offsetReloadOk = initialStateOk;
        while (true) {
            if (offsetReloadOk) {
                int count = this.txReader.unsafeReadSymbolTransientCount(symbolIndexInTxFile);
                Unsafe.getUnsafe().loadFence();
                if (this.txReader.unsafeReadVersion() == this.txReader.getVersion()) {
                    return count;
                }
            }
            offsetReloadOk = this.txReader.unsafeLoadBaseOffset();
        }
    }
}

