/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ErrorTag;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class WarningsProcessor
implements HttpRequestProcessor,
HttpRequestHandler {
    private static final long RECOMMENDED_FILE_LIMIT = 0x100000L;
    private static final long RECOMMENDED_MAP_COUNT_LIMIT = 0x100000L;
    private static final String TAG = "tag";
    private static final String WARNING = "warning";
    private static final AtomicReference<StringSink> sinkRef = new AtomicReference<StringSink>(new StringSink());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarningsProcessor(CairoConfiguration configuration) {
        AtomicReference<StringSink> atomicReference = sinkRef;
        synchronized (atomicReference) {
            long mapCountLimit;
            StringSink sink = sinkRef.get();
            sink.clear();
            sink.putAscii('[');
            FilesFacade ff = configuration.getFilesFacade();
            String rootDir = configuration.getDbRoot();
            try (Path path = new Path();){
                long fsStatus = ff.getFileSystemStatus(path.of(rootDir).$());
                if (fsStatus >= 0L && (fsStatus != 0L || Os.type != 1 || Os.arch != 1)) {
                    ((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)sink.putAscii('{').putQuoted(TAG)).putAscii(':').putQuoted(ErrorTag.UNSUPPORTED_FILE_SYSTEM.text())).putAscii(',').putQuoted(WARNING)).putAscii(":\"").putAscii("Unsupported file system [dir=").put(rootDir)).putAscii(", magic=0x");
                    Numbers.appendHex(sink, fsStatus, false);
                    sink.putAscii("]\"}");
                }
            }
            long fileLimit = ff.getFileLimit();
            if (fileLimit < 0L) {
                throw CairoException.nonCritical().put("Could not read fs.file-max [errno=").put(Os.errno()).put("]");
            }
            if (fileLimit > 0L && fileLimit < 0x100000L) {
                if (sink.length() > 1) {
                    sink.putAscii(',');
                }
                ((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)sink.putAscii('{').putQuoted(TAG)).putAscii(':').putQuoted(ErrorTag.TOO_MANY_OPEN_FILES.text())).putAscii(',').putQuoted(WARNING)).putAscii(":\"").putAscii("fs.file-max limit is too low [current=").put(fileLimit)).putAscii(", recommended=").put(0x100000L)).putAscii("]\"}");
            }
            if ((mapCountLimit = ff.getMapCountLimit()) < 0L) {
                throw CairoException.nonCritical().put("Could not read vm.max_map_count [errno=").put(Os.errno()).put("]");
            }
            if (mapCountLimit > 0L && mapCountLimit < 0x100000L) {
                if (sink.length() > 1) {
                    sink.putAscii(',');
                }
                ((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)sink.putAscii('{').putQuoted(TAG)).putAscii(':').putQuoted(ErrorTag.OUT_OF_MMAP_AREAS.text())).putAscii(',').putQuoted(WARNING)).putAscii(":\"").putAscii("vm.max_map_count limit is too low [current=").put(mapCountLimit)).putAscii(", recommended=").put(0x100000L)).putAscii("]\"}");
            }
            sink.putAscii(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void override(@NotNull String tag, @NotNull String warning) {
        StringSink current = sinkRef.get();
        StringSink sink = new StringSink();
        AtomicReference<StringSink> atomicReference = sinkRef;
        synchronized (atomicReference) {
            if (tag.isEmpty()) {
                sink.putAscii("[]");
            } else {
                if (current.length() == 0) {
                    sink.putAscii('[');
                } else {
                    sink.put(current.subSequence(0, current.length() - 1));
                }
                if (sink.length() > 1) {
                    sink.putAscii(',');
                }
                ((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)sink.putAscii('{').putQuoted(TAG)).putAscii(':').putQuoted(ErrorTag.resolveTag(tag).text())).putAscii(',').putQuoted(WARNING)).putAscii(':').putQuoted(warning)).putAscii('}').putAscii(']');
            }
            sinkRef.set(sink);
        }
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return 0;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpChunkedResponse r = context.getChunkedResponse();
        r.status(200, "application/json");
        r.sendHeader();
        r.put(sinkRef.get());
        r.sendChunk(true);
    }
}

