/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cutlass.http.ConnectionAware;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.LineHttpTudCache;
import io.questdb.cutlass.http.processors.SendStatus;
import io.questdb.cutlass.line.tcp.AdaptiveRecvBuffer;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineProtocolException;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineWalAppender;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.cutlass.line.tcp.WalTableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sink;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class LineHttpProcessorState
implements QuietCloseable,
ConnectionAware {
    private static final AtomicLong ERROR_COUNT = new AtomicLong();
    private static final String ERROR_ID = LineHttpProcessorState.generateErrorId();
    private static Log LOG = LogFactory.getLog(LineHttpProcessorState.class);
    private final LineWalAppender appender;
    private final StringSink error = new StringSink();
    private final LineHttpTudCache ilpTudCache;
    private final boolean logMessageOnError;
    private final int maxResponseErrorMessageLength;
    private final LineTcpParser parser;
    private final AdaptiveRecvBuffer recvBuffer;
    private final WeakClosableObjectPool<SymbolCache> symbolCachePool;
    int errorLine = -1;
    private Status currentStatus = Status.OK;
    private long errorId;
    private long fd = -1L;
    private int line = 0;
    private SecurityContext securityContext;
    private SendStatus sendStatus = SendStatus.NONE;

    public LineHttpProcessorState(int initRecvBufSize, int maxResponseContentLength, CairoEngine engine, LineHttpProcessorConfiguration configuration) {
        assert (initRecvBufSize > 0);
        this.maxResponseErrorMessageLength = (int)((double)(maxResponseContentLength - 100) / 1.5);
        this.parser = new LineTcpParser(configuration.getCairoConfiguration());
        this.recvBuffer = new AdaptiveRecvBuffer(this.parser, 33).of(initRecvBufSize, configuration.getMaxRecvBufferSize());
        this.appender = new LineWalAppender(configuration.autoCreateNewColumns(), configuration.isStringToCharCastAllowed(), configuration.getTimestampAdapter(), engine.getConfiguration().getMaxFileNameLength(), configuration.getMicrosecondClock());
        DefaultColumnTypes defaultColumnTypes = new DefaultColumnTypes(configuration);
        this.ilpTudCache = new LineHttpTudCache(engine, configuration.autoCreateNewColumns(), configuration.autoCreateNewTables(), defaultColumnTypes, configuration.getDefaultPartitionBy());
        this.symbolCachePool = new WeakClosableObjectPool<SymbolCache>(() -> new SymbolCache(configuration.getMicrosecondClock(), configuration.getSymbolCacheWaitUsBeforeReload()), 5);
        this.logMessageOnError = configuration.logMessageOnError();
    }

    public void clear() {
        this.ilpTudCache.clear();
        this.recvBuffer.clear();
        this.error.clear();
        this.currentStatus = Status.OK;
        this.errorLine = 0;
        this.line = 0;
        this.sendStatus = SendStatus.NONE;
    }

    @Override
    public void close() {
        Misc.free(this.recvBuffer);
        Misc.free(this.ilpTudCache);
        Misc.free(this.symbolCachePool);
        Misc.free(this.parser);
    }

    public void commit() {
        try {
            this.ilpTudCache.commitAll();
        }
        catch (Throwable th) {
            this.ilpTudCache.setDistressed();
            this.currentStatus = this.handleCommitError(th);
        }
    }

    public void formatError(Utf8Sink sink) {
        sink.putAscii("{\"code\":\"").putAscii(this.currentStatus.codeStr);
        sink.putAscii("\",\"message\":\"");
        if (this.errorLine > -1) {
            sink.putAscii("failed to parse line protocol:");
            sink.putAscii("errors encountered on line(s):");
        }
        sink.escapeJsonStr(this.error, 0, Math.min(this.error.length(), this.maxResponseErrorMessageLength));
        if (this.errorLine > -1) {
            sink.putAscii("\",\"line\":").put(this.errorLine);
        } else {
            sink.putQuote();
        }
        ((Utf8Sink)sink.putAscii(",\"errorId\":\"").putAscii(ERROR_ID).put('-').put(this.errorId)).putAscii("\"").putAscii('}');
    }

    public int getHttpResponseCode() {
        return this.currentStatus.responseCode;
    }

    public SendStatus getSendStatus() {
        return this.sendStatus;
    }

    public boolean isOk() {
        return this.currentStatus == Status.OK;
    }

    public void of(long fd, byte timestampPrecision, SecurityContext securityContext) {
        this.fd = fd;
        this.securityContext = securityContext;
        this.appender.setTimestampAdapter(timestampPrecision);
    }

    @Override
    public void onDisconnected() {
        this.clear();
        this.ilpTudCache.reset();
    }

    public void onMessageComplete() {
        if (this.currentStatus == Status.NEEDS_READ) {
            long recvBufPos = this.recvBuffer.getBufPos();
            assert (recvBufPos < this.recvBuffer.getBufEnd());
            Unsafe.getUnsafe().putByte(recvBufPos, (byte)10);
            this.recvBuffer.setBufPos(recvBufPos + 1L);
            this.currentStatus = this.processLocalBuffer();
            if (this.currentStatus == Status.NEEDS_READ) {
                this.currentStatus = Status.OK;
            }
        }
        this.recvBuffer.tryToShrinkRecvBuffer(false);
    }

    public void parse(long lo, long hi) {
        if (this.stopParse()) {
            return;
        }
        long pos = lo;
        while (pos < hi) {
            pos = this.recvBuffer.copyToLocalBuffer(pos, hi);
            this.currentStatus = this.processLocalBuffer();
            if (!this.stopParse()) continue;
            return;
        }
    }

    public void reject(Status status, String errorText, long fd) {
        this.currentStatus = status;
        this.error.put(errorText);
        this.fd = fd;
        this.logError();
    }

    public void setSendStatus(SendStatus sendStatus) {
        this.sendStatus = sendStatus;
    }

    private static String generateErrorId() {
        return UUID.randomUUID().toString().substring(24, 36);
    }

    private Status appendMeasurement() throws LineHttpTudCache.TableCreateException {
        WalTableUpdateDetails tud = this.ilpTudCache.getTableUpdateDetails(this.securityContext, this.parser, this.symbolCachePool);
        try {
            this.appender.appendToWal(this.securityContext, this.parser, tud);
            return Status.OK;
        }
        catch (LineProtocolException e) {
            this.errorLine = ++this.line;
            int errorStartPos = this.error.length();
            ((Utf16Sink)this.error.put("\nerror in line ").put(this.errorLine)).put(": ");
            this.error.put(e.getFlyweightMessage());
            this.logError(this.parser, errorStartPos);
            return Status.APPEND_ERROR;
        }
        catch (CommitFailedException ex) {
            if (ex.isTableDropped()) {
                tud.setIsDropped();
                return Status.OK;
            }
            this.ilpTudCache.setDistressed();
            return this.handleCommitError(ex.getReason());
        }
        catch (CairoException e) {
            if (e.isTableDropped()) {
                tud.setIsDropped();
                return Status.OK;
            }
            this.ilpTudCache.setDistressed();
            throw e;
        }
        catch (Throwable th) {
            this.ilpTudCache.setDistressed();
            throw th;
        }
    }

    private long getErrorLogLineHi(LineTcpParser parser) {
        return Math.min(parser.getBufferAddress() + 1L, this.recvBuffer.getBufPos());
    }

    private Status handleCommitError(Throwable ex) {
        Status status;
        LogRecord errorRec;
        this.errorId = ERROR_COUNT.incrementAndGet();
        this.errorLine = -1;
        this.error.put("commit error for table: ").put(this.parser.getMeasurementName());
        if (ex instanceof CairoException) {
            CairoException exception = (CairoException)ex;
            ((Utf16Sink)((Utf16Sink)this.error.put(", errno: ").put(exception.getErrno())).put(", error: ")).put(exception.getFlyweightMessage());
            if (exception.isAuthorizationError()) {
                errorRec = LOG.error();
                status = Status.SECURITY_ERROR;
            } else {
                errorRec = LOG.critical();
                status = Status.INTERNAL_ERROR;
            }
        } else {
            this.error.put(", error: ").put(ex.getClass().getCanonicalName());
            errorRec = LOG.critical();
            status = Status.INTERNAL_ERROR;
        }
        errorRec.$('[').$(this.fd).$("] could not commit [table=").$(this.parser.getMeasurementName()).$(", errorId=").$(ERROR_ID).$('-').$(this.errorId).$(", ex=").$safe(ex.getMessage()).I$();
        return status;
    }

    private Status handleLineError(LineTcpParser parser) {
        this.errorLine = ++this.line;
        int errorPos = this.error.length();
        this.error.put("\nerror in line ").put(this.errorLine);
        switch (parser.getErrorCode()) {
            case NO_FIELDS: {
                this.error.put(": No fields were provided");
                break;
            }
            case MISSING_FIELD_VALUE: {
                this.error.put(": Could not parse entire line. Field value is missing: ").put(parser.getLastEntityName());
                break;
            }
            case MISSING_TAG_VALUE: {
                this.error.put(": Could not parse entire line. Symbol value is missing: ").put(parser.getLastEntityName());
                break;
            }
            case INVALID_TIMESTAMP: {
                this.error.put(": Could not parse timestamp: ").put(parser.getErrorTimestampValue());
                break;
            }
            case INVALID_FIELD_VALUE: {
                ((Utf16Sink)this.error.put(": Could not parse entire line, field value is invalid. Field: ").put(parser.getLastEntityName()).put("; value: ")).put(parser.getErrorFieldValue());
                break;
            }
            case INVALID_TAG_VALUE: {
                ((Utf16Sink)this.error.put(": Could not parse entire line, tag value is invalid. Tag: ").put(parser.getLastEntityName()).put("; value: ")).put(parser.getErrorFieldValue());
                break;
            }
            case INVALID_COLUMN_NAME: {
                ((Utf16Sink)this.error.put(": table: ").put(parser.getMeasurementName()).put("; invalid column name: ")).put(parser.getLastEntityName());
                break;
            }
            default: {
                this.error.put(": ").put(String.valueOf((Object)parser.getErrorCode()));
            }
        }
        this.logError(parser, errorPos);
        return Status.PARSE_ERROR;
    }

    private Status handleLineError(LineTcpParser parser, LineHttpTudCache.TableCreateException ex) {
        this.errorLine = ++this.line;
        int errorPos = this.error.length();
        this.error.put("\nerror in line ").put(this.errorLine);
        this.error.put(": table: ").put(parser.getMeasurementName());
        if (ex.getMsg() != null) {
            this.error.put("; ").put(ex.getMsg());
        }
        if (ex.getToken() != null) {
            this.error.put(": ").put(ex.getToken());
        }
        this.logError(parser, errorPos);
        return Status.PARSE_ERROR;
    }

    private Status handleLineError(LineTcpParser parser, CairoException ex) {
        this.errorId = ERROR_COUNT.incrementAndGet();
        LogRecord errorRec = ex.isCritical() ? LOG.critical() : LOG.error();
        errorRec.$('[').$(this.fd).$("] could not process line data 4 [table=").$(parser.getMeasurementName()).$(", errorId=").$(ERROR_ID).$('-').$(this.errorId).$(", errno=").$(ex.getErrno());
        if (this.logMessageOnError) {
            errorRec.$(", mangledLine=`").$safe(this.recvBuffer.getBufStartOfMeasurement(), this.getErrorLogLineHi(parser)).$('`');
        }
        errorRec.$(", ex=").$(ex.getFlyweightMessage()).I$();
        ((Utf16Sink)((Utf16Sink)((Utf16Sink)this.error.put("write error: ").put(parser.getMeasurementName()).put(", errno: ")).put(ex.getErrno())).put(", error: ")).put(ex.getFlyweightMessage());
        this.errorLine = this.line + 1;
        return ex.isAuthorizationError() ? Status.SECURITY_ERROR : Status.INTERNAL_ERROR;
    }

    private Status handleUnknownParseError(Throwable ex) {
        this.errorId = ERROR_COUNT.incrementAndGet();
        LogRecord errorRec = LOG.critical().$('[').$(this.fd).$("] could not process line data 3 [table=").$(this.parser.getMeasurementName()).$(", errorId=").$(ERROR_ID).$('-').$(this.errorId);
        if (this.logMessageOnError) {
            errorRec.$(", mangledLine=`").$safe(this.recvBuffer.getBufStartOfMeasurement(), this.getErrorLogLineHi(this.parser)).$('`');
        }
        errorRec.$(", ex=").$safe(ex.getMessage()).I$();
        ((Utf16Sink)this.error.put("write error: ").put(this.parser.getMeasurementName()).put(", error: ")).put(ex.getClass().getCanonicalName());
        this.errorLine = this.line + 1;
        return Status.INTERNAL_ERROR;
    }

    private void logError(LineTcpParser parser, int errorPos) {
        this.logError(parser, errorPos, false);
    }

    private void logError(LineTcpParser parser, int errorPos, boolean isError) {
        this.errorId = ERROR_COUNT.incrementAndGet();
        LogRecord errorRec = isError ? LOG.error() : LOG.info();
        errorRec.$("parse error [errorId=").$(ERROR_ID).$('-').$(this.errorId).$(", table=").$safe(parser.getMeasurementName()).$(", line=").$(this.errorLine).$(", error=").$safe(this.error.subSequence(errorPos, this.error.length())).$(", fd=").$(this.fd);
        if (this.logMessageOnError) {
            errorRec.$(", mangledLine=`").$safe(this.recvBuffer.getBufStartOfMeasurement(), parser.getBufferAddress()).$('`');
        }
        errorRec.I$();
    }

    private void logError() {
        this.errorId = ERROR_COUNT.incrementAndGet();
        LOG.info().$("parse error [errorId=").$(ERROR_ID).$('-').$(this.errorId).$(", error=").$safe(this.error).$(", fd=").$(this.fd).I$();
    }

    private Status processLocalBuffer() {
        Status status = Status.OK;
        while (this.recvBuffer.getBufPos() > this.recvBuffer.getBufStart()) {
            try {
                LineTcpParser.ParseResult rc = this.parser.parseMeasurement(this.recvBuffer.getBufPos());
                switch (rc) {
                    case MEASUREMENT_COMPLETE: {
                        status = this.appendMeasurement();
                        if (status != Status.OK) {
                            return status;
                        }
                        ++this.line;
                        this.recvBuffer.startNewMeasurement();
                        break;
                    }
                    case ERROR: {
                        return this.handleLineError(this.parser);
                    }
                    case BUFFER_UNDERFLOW: {
                        if (!this.recvBuffer.tryCompactOrGrowBuffer()) {
                            this.errorLine = ++this.line;
                            int errorPos = this.error.length();
                            ((Utf16Sink)this.error.putAscii("transaction is too large, either flush more frequently or increase buffer size \"line.http.max.recv.buffer.size\" [maxBufferSize=").putSize(this.recvBuffer.getMaxBufSize())).putAscii(']');
                            this.logError(this.parser, errorPos, true);
                            return Status.MESSAGE_TOO_LARGE;
                        }
                        return Status.NEEDS_READ;
                    }
                }
            }
            catch (LineHttpTudCache.TableCreateException parseException) {
                return this.handleLineError(this.parser, parseException);
            }
            catch (CairoException parseException) {
                return this.handleLineError(this.parser, parseException);
            }
            catch (Throwable ex) {
                return this.handleUnknownParseError(ex);
            }
        }
        return status;
    }

    private boolean stopParse() {
        return this.currentStatus != Status.OK && this.currentStatus != Status.NEEDS_READ;
    }

    public static enum Status {
        OK(null, 204),
        ENCODING_NOT_SUPPORTED("not supported", 415),
        PRECISION_NOT_SUPPORTED("not supported", 400),
        NEEDS_READ("invalid", 400),
        PARSE_ERROR("invalid", 400),
        APPEND_ERROR("invalid", 400),
        METHOD_NOT_SUPPORTED("invalid", 404),
        SECURITY_ERROR("unauthorised", 403),
        INTERNAL_ERROR("internal error", 500),
        MESSAGE_TOO_LARGE("request too large", 413),
        COLUMN_ADD_ERROR("invalid", 400),
        COMMITTED(null, 204);

        private final String codeStr;
        private final int responseCode;

        private Status(String codeStr, int responseCode) {
            this.codeStr = codeStr;
            this.responseCode = responseCode;
        }
    }
}

