/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.metrics.HealthMetricsImpl;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;

public class HealthCheckProcessor
implements HttpRequestProcessor,
HttpRequestHandler {
    private final boolean pessimisticMode;
    private final byte requiredAuthType;

    public HealthCheckProcessor(HttpServerConfiguration configuration) {
        this.pessimisticMode = configuration.isPessimisticHealthCheckEnabled();
        this.requiredAuthType = configuration.getRequiredAuthType();
    }

    @Override
    public HttpRequestProcessor getDefaultProcessor() {
        return this;
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HealthMetricsImpl metrics;
        long unhandledErrors;
        HttpChunkedResponse response = context.getChunkedResponse();
        if (this.pessimisticMode && (unhandledErrors = (metrics = context.getMetrics().healthMetrics()).unhandledErrorsCount()) > 0L) {
            response.status(500, "text/plain");
            response.sendHeader();
            response.putAscii("Status: Unhealthy\nUnhandled errors: ");
            response.put(unhandledErrors);
            response.sendChunk(true);
            return;
        }
        response.status(200, "text/plain");
        response.sendHeader();
        response.putAscii("Status: Healthy");
        response.sendChunk(true);
    }
}

