/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.client.impl;

import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;

public final class ConfStringParser {
    private ConfStringParser() {
    }

    public static boolean hasNext(CharSequence input, int pos) {
        if (pos == -1) {
            return false;
        }
        return pos != input.length();
    }

    public static int nextKey(CharSequence input, int pos, StringSink output) {
        output.clear();
        if (pos == -1) {
            return pos;
        }
        int n = input.length();
        int start = pos;
        while (pos < n) {
            char c = input.charAt(pos);
            if (c == '=') {
                if (pos == start) {
                    output.put("empty key");
                    return -1;
                }
                output.put(input, start, pos);
                return pos + 1;
            }
            if (c == ';') {
                output.put("incomplete key-value pair before end of input at position ").put(pos);
                return -1;
            }
            if (ConfStringParser.invalidIdentifierChar(c)) {
                ((Utf16Sink)((Utf16Sink)output.put("key must be consist of alpha-numerical ascii characters and underscore, not '").put(c)).put("' at position ")).put(pos);
                return -1;
            }
            ++pos;
        }
        output.clear();
        output.put("incomplete key-value pair before end of input at position ").put(pos);
        return -1;
    }

    public static int of(CharSequence input, StringSink output) {
        output.clear();
        if (input.length() == 0) {
            output.put("expected schema identifier, not an empty string at position 0");
            return -1;
        }
        int lastChar = 0;
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            if (lastChar == 58) {
                if (c == ':') {
                    if (i == 1) {
                        output.put("empty schema at position 0");
                        return -1;
                    }
                    output.put(input, 0, i - 1);
                    return i + 1;
                }
                ((Utf16Sink)((Utf16Sink)output.put("bad separator, expected '::' got ':").put(c)).put("' at position ")).put(i - 1);
                return -1;
            }
            if (c == ':') {
                lastChar = c;
                continue;
            }
            if (ConfStringParser.invalidIdentifierChar(c)) {
                ((Utf16Sink)((Utf16Sink)output.put("bad separator, expected ':' got '").put(c)).put("' at position ")).put(i);
                return -1;
            }
            lastChar = c;
        }
        output.put(input);
        return input.length();
    }

    public static int value(CharSequence input, int pos, StringSink output) {
        output.clear();
        if (pos == -1) {
            return -1;
        }
        int n = input.length();
        while (pos < n) {
            char c = input.charAt(pos);
            if (c == ';') {
                if (++pos == n || input.charAt(pos) != ';') {
                    return pos;
                }
                output.put(';');
            } else {
                if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                    output.put("invalid character '").putAsPrintable(c);
                    output.put("' at position ").put(pos);
                    return -1;
                }
                output.put(c);
            }
            ++pos;
        }
        return pos;
    }

    private static boolean invalidIdentifierChar(char c) {
        return !Character.isDigit(c) && c != '_' && !ConfStringParser.isAsciiLetter(c);
    }

    private static boolean isAsciiLetter(char c) {
        char lower = (char)(c | 0x20);
        return lower >= 'a' && lower <= 'z';
    }
}

