/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.arr.MutableArray;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.PlanSink;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class FunctionArray
extends MutableArray
implements FlatArrayView {
    private ObjList<Function> functions;
    private Record record;

    public FunctionArray(short elementType, int nDims) {
        this.setType(ColumnType.encodeArrayType(elementType, nDims));
        this.flatView = this;
    }

    @Override
    public void appendToMemFlat(MemoryA mem, int offset, int length) {
        short elemType = this.getElemType();
        switch (elemType) {
            case 2: {
                for (int i = 0; i < length; ++i) {
                    mem.putByte(this.functions.getQuick(offset + i).getByte(this.record));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < length; ++i) {
                    mem.putShort(this.functions.getQuick(offset + i).getShort(this.record));
                }
                break;
            }
            case 5: {
                for (int i = 0; i < length; ++i) {
                    mem.putInt(this.functions.getQuick(offset + i).getInt(this.record));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < length; ++i) {
                    mem.putLong(this.functions.getQuick(offset + i).getLong(this.record));
                }
                break;
            }
            case 7: {
                for (int i = 0; i < length; ++i) {
                    mem.putLong(this.functions.getQuick(offset + i).getDate(this.record));
                }
                break;
            }
            case 8: {
                for (int i = 0; i < length; ++i) {
                    mem.putLong(this.functions.getQuick(offset + i).getTimestamp(this.record));
                }
                break;
            }
            case 9: {
                for (int i = 0; i < length; ++i) {
                    mem.putFloat(this.functions.getQuick(offset + i).getFloat(this.record));
                }
                break;
            }
            case 10: {
                for (int i = 0; i < length; ++i) {
                    mem.putDouble(this.functions.getQuick(offset + i).getDouble(this.record));
                }
                break;
            }
            case 13: {
                for (int i = 0; i < length; ++i) {
                    Long256 v = this.functions.getQuick(offset + i).getLong256A(this.record);
                    mem.putLong256(v.getLong0(), v.getLong1(), v.getLong2(), v.getLong3());
                }
                break;
            }
            case 19: {
                for (int i = 0; i < length; ++i) {
                    mem.putLong128(this.functions.getQuick(offset + i).getLong128Lo(this.record), this.functions.getQuick(offset + i).getLong128Hi(this.record));
                }
                break;
            }
            case 25: {
                for (int i = 0; i < length; ++i) {
                    mem.putInt(this.functions.getQuick(offset + i).getIPv4(this.record));
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"impossible array element type");
            }
        }
    }

    public void applyShape(CairoConfiguration configuration, int errorPos) {
        this.resetToDefaultStrides(configuration.maxArrayElementCount(), errorPos);
        if (this.functions == null) {
            this.functions = new ObjList(this.flatViewLength);
        }
    }

    @Override
    public void close() {
        Misc.freeObjListAndClear(this.functions);
    }

    @Override
    public double getDoubleAtAbsIndex(int flatIndex) {
        return this.functions.getQuick(flatIndex).getDouble(this.record);
    }

    public Function getFunctionAtFlatIndex(int flatIndex) {
        return this.functions.getQuick(flatIndex);
    }

    public ObjList<Function> getFunctions() {
        return this.functions;
    }

    @Override
    public long getLongAtAbsIndex(int flatIndex) {
        return this.functions.getQuick(flatIndex).getLong(this.record);
    }

    @Override
    public int length() {
        return this.functions.size();
    }

    public void putFunction(int flatIndex, Function f) {
        this.functions.extendAndSet(flatIndex, f);
    }

    public void setRecord(Record rec) {
        this.record = rec;
    }

    public void toPlan(PlanSink sink) {
        sink.val('[');
        String comma = "";
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            sink.val(comma);
            sink.val(this.functions.getQuick(i));
            comma = ",";
        }
        sink.val(']');
    }
}

