/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.tasks.O3CopyTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3CopyJob
extends AbstractQueueConsumerJob<O3CopyTask> {
    private static final Log LOG = LogFactory.getLog(O3CopyJob.class);

    public O3CopyJob(MessageBus messageBus) {
        super(messageBus.getO3CopyQueue(), messageBus.getO3CopySubSeq());
    }

    public static void copy(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, long dstFixFd, long dstAuxAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        boolean mixedIOFlag = tableWriter.allowMixedIO();
        LOG.debug().$("o3 copy [blockType=").$(blockType).$(", columnType=").$(columnType).$(", dstFixFd=").$(dstFixFd).$(", dstFixSize=").$(dstFixSize).$(", dstFixOffset=").$(dstFixOffset).$(", dstVarFd=").$(dstVarFd).$(", dstVarSize=").$(dstVarSize).$(", dstVarOffset=").$(dstVarOffset).$(", srcDataLo=").$(srcDataLo).$(", srcDataHi=").$(srcDataHi).$(", srcDataMax=").$(srcDataMax).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", srcOooPartitionLo=").$(srcOooPartitionLo).$(", srcOooPartitionHi=").$(srcOooPartitionHi).$(", mixedIOFlag=").$(mixedIOFlag).$(", srcDataNewPartitionSize=").$(srcDataNewPartitionSize).$(", srcDataOldPartitionSize=").$(srcDataOldPartitionSize).$(", o3SplitPartitionSize=").$(o3SplitPartitionSize).I$();
        try {
            switch (blockType) {
                case 3: {
                    O3CopyJob.mergeCopy(columnType, timestampMergeIndexAddr, timestampMergeIndexSize / 16L, srcDataFixAddr + srcDataFixOffset - srcDataTop, srcDataVarAddr + srcDataVarOffset, srcOooFixAddr, srcOooVarAddr, dstAuxAddr + dstFixOffset, dstVarAddr, dstVarOffset);
                    break;
                }
                case 1: {
                    O3CopyJob.copyO3(tableWriter.getFilesFacade(), columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixFd, dstAuxAddr + dstFixOffset, Math.abs(dstFixSize) - dstFixOffset, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, mixedIOFlag);
                    break;
                }
                case 2: {
                    if (srcDataLo > srcDataHi) break;
                    O3CopyJob.copyData(tableWriter.getFilesFacade(), columnType, srcDataFixAddr + srcDataFixOffset, srcDataVarAddr + srcDataVarOffset, srcDataLo, srcDataHi, dstAuxAddr + dstFixOffset, Math.abs(dstFixSize) - dstFixOffset, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, mixedIOFlag);
                    break;
                }
            }
        }
        catch (Throwable th) {
            tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(th));
            if (partCounter == null || partCounter.decrementAndGet() == 0) {
                O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstAuxAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
            }
            throw th;
        }
        O3CopyJob.copyTail(columnCounter, partCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, timestampMin, partitionTimestamp, dstFixFd, dstAuxAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
    }

    public static void copy(O3CopyTask task, long cursor, Sequence subSeq) {
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int columnType = task.getColumnType();
        int blockType = task.getBlockType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long timestampMergeIndexSize = task.getTimestampMergeIndexSize();
        long srcDataFixFd = task.getSrcDataFixFd();
        long srcDataFixAddr = task.getSrcDataFixAddr();
        long srcDataFixOffset = task.getSrcDataFixOffset();
        long srcDataFixSize = task.getSrcDataFixSize();
        long srcDataVarFd = task.getSrcDataVarFd();
        long srcDataVarAddr = task.getSrcDataVarAddr();
        long srcDataVarOffset = task.getSrcDataVarOffset();
        long srcDataVarSize = task.getSrcDataVarSize();
        long srcDataTop = task.getSrcDataTop();
        long srcDataLo = task.getSrcDataLo();
        long srcDataMax = task.getSrcDataMax();
        long srcDataHi = task.getSrcDataHi();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long srcOooPartitionLo = task.getSrcOooPartitionLo();
        long srcOooPartitionHi = task.getSrcOooPartitionHi();
        long timestampMin = task.getTimestampMin();
        long partitionTimestamp = task.getPartitionTimestamp();
        long dstFixFd = task.getDstFixFd();
        long dstAuxAddr = task.getDstFixAddr();
        long dstFixOffset = task.getDstFixOffset();
        long dstFixFileOffset = task.getDstFixFileOffset();
        long dstFixSize = task.getDstFixSize();
        long dstVarFd = task.getDstVarFd();
        long dstVarAddr = task.getDstVarAddr();
        long dstVarOffset = task.getDstVarOffset();
        long dstVarAdjust = task.getDstVarAdjust();
        long dstVarSize = task.getDstVarSize();
        long dstKFd = task.getDstKFd();
        long dskVFd = task.getDstVFd();
        long dstIndexOffset = task.getDstIndexOffset();
        long dstIndexAdjust = task.getDstIndexAdjust();
        int indexBlockCapacity = task.getIndexBlockCapacity();
        long srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        boolean partitionMutates = task.isPartitionMutates();
        long srcDataNewPartitionSize = task.getSrcDataNewPartitionSize();
        long srcDataOldPartitionSize = task.getSrcDataOldPartitionSize();
        long o3SplitPartitionSize = task.getO3SplitPartitionSize();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        long partitionUpdateSinkAddr = task.getPartitionUpdateSinkAddr();
        subSeq.done(cursor);
        try {
            O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstAuxAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dskVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        }
        catch (Throwable th) {
            LOG.error().$("o3 copy failed [table=").$(tableWriter.getTableToken()).$(", partition=").$ts(partitionTimestamp).$(", columnType=").$(columnType).$(", exception=").$(th).I$();
            throw th;
        }
    }

    public static void copyFixedSizeCol(FilesFacade ff, long src, long srcLo, long srcHi, long dstFixAddr, long dstFixFileOffset, long dstFd, int shl, boolean mixedIOFlag) {
        long len = srcHi - srcLo + 1L << shl;
        O3Utils.copyFixedSizeCol(ff, src, srcLo, dstFixAddr, dstFixFileOffset, dstFd, mixedIOFlag, len, shl);
    }

    public static void mergeCopy(int columnType, long timestampMergeIndexAddr, long timestampMergeIndexCount, long srcDataFixAddr, long srcDataVarAddr, long srcOooFixAddr, long srcOooVarAddr, long dstFixAddr, long dstVarAddr, long dstVarOffset) {
        if (ColumnType.isVarSize(columnType)) {
            ColumnType.getDriver(columnType).o3ColumnMerge(timestampMergeIndexAddr, timestampMergeIndexCount, srcDataFixAddr, srcDataVarAddr, srcOooFixAddr, srcOooVarAddr, dstFixAddr, dstVarAddr, dstVarOffset);
        } else if (ColumnType.isDesignatedTimestamp(columnType)) {
            Vect.oooCopyIndex(timestampMergeIndexAddr, timestampMergeIndexCount, dstFixAddr);
        } else {
            switch (ColumnType.tagOf(columnType)) {
                case 1: 
                case 2: 
                case 14: {
                    Vect.mergeShuffle8Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    Vect.mergeShuffle16Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
                case 5: 
                case 9: 
                case 12: 
                case 16: 
                case 25: {
                    Vect.mergeShuffle32Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 17: {
                    Vect.mergeShuffle64Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
                case 19: 
                case 24: {
                    Vect.mergeShuffle128Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
                case 13: {
                    Vect.mergeShuffle256Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, timestampMergeIndexCount);
                    break;
                }
            }
        }
    }

    public static void o3ColumnCopy(FilesFacade ff, int columnType, long srcAuxAddr, long srcDataAddr, long srcLo, long srcHi, long dstAuxAddr, long dstAuxAddrSize, long dstAuxFd, long dstAuxFileOffset, long dstDataAddr, long dstDataFd, long dstDataOffset, long dstDataAdjust, long dstDataSize, boolean mixedIOFlag) {
        assert (srcLo <= srcHi) : String.format("srcLo %,d > srcHi %,d", srcLo, srcHi);
        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
        long srcDataOffset = columnTypeDriver.getDataVectorOffset(srcAuxAddr, srcLo);
        assert (srcDataOffset >= 0L);
        long len = columnTypeDriver.getDataVectorSize(srcAuxAddr, srcLo, srcHi);
        assert (len <= Math.abs(dstDataSize) - dstDataOffset) : String.format("columnType %d srcLo %,d srcHi %,d srcDataOffset %,d dstDataOffset %,d len %,d dstDataSize %,d dst_diff %,d", columnType, srcLo, srcHi, srcDataOffset, dstDataOffset, len, dstDataSize, dstDataOffset + len - Math.abs(dstDataSize));
        long offset = dstDataOffset + dstDataAdjust;
        if (mixedIOFlag) {
            if (ff.write(Math.abs(dstDataFd), srcDataAddr + srcDataOffset, len, offset) != len) {
                throw CairoException.critical(ff.errno()).put("cannot copy var data column prefix [fd=").put(dstDataFd).put(", offset=").put(offset).put(", len=").put(len).put(']');
            }
        } else {
            Vect.memcpy(dstDataAddr + dstDataOffset, srcDataAddr + srcDataOffset, len);
        }
        if (srcDataOffset == offset) {
            columnTypeDriver.o3copyAuxVector(ff, srcAuxAddr, srcLo, srcHi, dstAuxAddr, dstAuxFileOffset, dstAuxFd, mixedIOFlag);
        } else {
            columnTypeDriver.shiftCopyAuxVector(srcDataOffset - offset, srcAuxAddr, srcLo, srcHi, dstAuxAddr, dstAuxAddrSize);
        }
    }

    private static void copyData(FilesFacade ff, int columnType, long srcAuxAddr, long srcVarAddr, long srcLo, long srcHi, long dstFixAddr, long dstFixAddrSize, long dstFixFd, long dstFixFileOffset, long dstVarAddr, long dstVarFd, long dstVarOffset, long dstVarAdjust, long dstVarSize, boolean mixedIOFlag) {
        if (ColumnType.isVarSize(columnType)) {
            O3CopyJob.o3ColumnCopy(ff, columnType, srcAuxAddr, srcVarAddr, srcLo, srcHi, dstFixAddr, dstFixAddrSize, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, mixedIOFlag);
        } else {
            O3CopyJob.copyFixedSizeCol(ff, srcAuxAddr, srcLo, srcHi, dstFixAddr, dstFixFileOffset, dstFixFd, ColumnType.pow2SizeOf(Math.abs(columnType)), mixedIOFlag);
        }
    }

    private static void copyTail(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long timestampMin, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            int commitMode;
            FilesFacade ff = tableWriter.getFilesFacade();
            if (indexBlockCapacity > -1) {
                O3CopyJob.updateIndex(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, indexBlockCapacity);
            }
            if ((commitMode = tableWriter.getConfiguration().getCommitMode()) != 2) {
                O3CopyJob.syncColumns(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, commitMode);
            }
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            int columnsRemaining = columnCounter.decrementAndGet();
            LOG.debug().$("organic [columnsRemaining=").$(columnsRemaining).I$();
            if (columnsRemaining == 0) {
                O3CopyJob.updatePartition(timestampMergeIndexAddr, timestampMergeIndexSize, timestampMin, partitionTimestamp, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, partitionUpdateSinkAddr, tableWriter);
            }
        }
    }

    private static void syncColumns(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, FilesFacade ff, int commitMode) {
        try {
            boolean async;
            boolean bl = async = commitMode == 0;
            if (dstFixAddr != 0L && dstFixSize > 0L) {
                ff.msync(dstFixAddr, dstFixSize, async);
                if (dstFixFd != -1L && dstFixFd != 0L) {
                    ff.fsync(Math.abs(dstFixFd));
                }
            }
            if (dstVarAddr != 0L && dstVarSize > 0L) {
                ff.msync(dstVarAddr, dstVarSize, async);
                if (dstVarFd != -1L && dstVarFd != 0L) {
                    ff.fsync(Math.abs(dstVarFd));
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("sync error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount(false);
            O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateIndex(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, int indexBlockCapacity) {
        try {
            boolean closed;
            long row = dstIndexOffset / 4L;
            boolean bl = closed = !indexWriter.isOpen();
            if (closed) {
                indexWriter.of(tableWriter.getConfiguration(), dstKFd, dstVFd, row == 0L, indexBlockCapacity);
            }
            try {
                O3CopyJob.updateIndex(dstFixAddr, Math.abs(dstFixSize), indexWriter, dstIndexOffset / 4L, dstIndexAdjust);
                indexWriter.commit();
            }
            finally {
                if (closed) {
                    Misc.free(indexWriter);
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("index error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount(false);
            O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
    }

    private static void updateIndex(long dstFixAddr, long dstFixSize, BitmapIndexWriter w, long row, long rowAdjust) {
        w.rollbackConditionally(row + rowAdjust);
        long count = dstFixSize / 4L;
        while (row < count) {
            w.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(dstFixAddr + row * 4L)), row + rowAdjust);
            ++row;
        }
        w.setMaxValue(row + rowAdjust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePartition(long timestampMergeIndexAddr, long timestampMergeIndexSize, long timestampMin, long partitionTimestamp, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, long partitionUpdateSinkAddr, TableWriter tableWriter) {
        FilesFacade ff = tableWriter.getFilesFacade();
        O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
        try {
            try {
                O3Utils.close(ff, srcTimestampFd);
            }
            finally {
                O3CopyJob.o3NotifyPartitionUpdate(tableWriter, partitionUpdateSinkAddr, timestampMin, partitionTimestamp, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, partitionMutates);
            }
        }
        finally {
            if (timestampMergeIndexAddr != 0L) {
                Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
            }
            tableWriter.o3CountDownDoneLatch();
        }
    }

    static void closeColumnIdle(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        int columnsRemaining = columnCounter.decrementAndGet();
        LOG.debug().$("idle [table=").$safe(tableWriter.getTableToken().getTableName()).$(", columnsRemaining=").$(columnsRemaining).I$();
        if (columnsRemaining == 0) {
            O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeColumnIdleQuick(long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            if (timestampMergeIndexAddr != 0L) {
                Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
            }
        }
        finally {
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
        }
    }

    static void copyO3(FilesFacade ff, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long dstFixFd, long dstFixAddr, long dstFixAddrSize, long dstFixFileOffset, long dstVarAddr, long dstVarFd, long dstVarOffset, long dstVarAdjust, long dstVarSize, boolean mixedIOFlag) {
        if (ColumnType.isVarSize(columnType)) {
            O3CopyJob.o3ColumnCopy(ff, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixAddrSize, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, mixedIOFlag);
        } else if (ColumnType.isDesignatedTimestamp(columnType)) {
            O3Utils.copyFromTimestampIndex(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr);
        } else {
            O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, ColumnType.pow2SizeOf(columnType), mixedIOFlag);
        }
    }

    static void o3NotifyPartitionUpdate(TableWriter tableWriter, long partitionUpdateSinkAddr, long timestampMin, long partitionTimestamp, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, boolean partitionMutates) {
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 8L, timestampMin);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 16L, srcDataNewPartitionSize);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 24L, srcDataOldPartitionSize);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 32L, partitionMutates ? 1L : 0L);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 40L, o3SplitPartitionSize);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 56L, -1L);
        LOG.debug().$("sending partition update [partitionTimestamp=").$ts(partitionTimestamp).$(", partitionTimestamp=").$ts(timestampMin).$(", srcDataNewPartitionSize=").$(srcDataNewPartitionSize).$(", srcDataOldPartitionSize=").$(srcDataOldPartitionSize).$(", o3SplitPartitionSize=").$(o3SplitPartitionSize).$();
        tableWriter.o3ClockDownPartitionUpdateCount();
    }

    static void unmapAndClose(AtomicInteger columnCounter, AtomicInteger partCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstKFd, long dstVFd, TableWriter tableWriter) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unmapAndCloseAllPartsComplete(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
        }
        finally {
            O3CopyJob.closeColumnIdle(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        try {
            O3CopyJob.copy((O3CopyTask)this.queue.get(cursor), cursor, this.subSeq);
        }
        catch (CairoException cairoException) {
            // empty catch block
        }
        return true;
    }
}

