/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolCountProvider;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;

public interface MapWriter
extends SymbolCountProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSymbolMapFiles(FilesFacade ff, MemoryMA mem, Path path, CharSequence columnName, long columnNameTxn, int symbolCapacity, boolean symbolCacheFlag) {
        int plen = path.size();
        try {
            mem.smallFile(ff, TableUtils.offsetFileName(path.trimTo(plen), columnName, columnNameTxn), 5);
            mem.jumpTo(0L);
            mem.putInt(symbolCapacity);
            mem.putBool(symbolCacheFlag);
            mem.jumpTo(64L);
            mem.sync(false);
            mem.close();
            if (!ff.touch(TableUtils.charFileName(path.trimTo(plen), columnName, columnNameTxn))) {
                throw CairoException.critical(ff.errno()).put("Cannot create ").put(path);
            }
            mem.smallFile(ff, BitmapIndexUtils.keyFileName(path.trimTo(plen), columnName, columnNameTxn), 5);
            BitmapIndexWriter.initKeyMemory(mem, TableUtils.MIN_INDEX_VALUE_BLOCK_SIZE);
            mem.sync(false);
            ff.touch(BitmapIndexUtils.valueFileName(path.trimTo(plen), columnName, columnNameTxn));
        }
        finally {
            path.trimTo(plen);
            Misc.free(mem);
        }
    }

    public boolean getNullFlag();

    public int getSymbolCapacity();

    public MemoryR getSymbolOffsetsMemory();

    public MemoryR getSymbolValuesMemory();

    public boolean isCached();

    public int put(char var1);

    public int put(CharSequence var1);

    public int put(CharSequence var1, SymbolValueCountCollector var2);

    public void rollback(int var1);

    public void setSymbolIndexInTxWriter(int var1);

    public void sync(boolean var1);

    public void truncate();

    public void updateCacheFlag(boolean var1);

    public void updateNullFlag(boolean var1);
}

