/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tsdb;

import java.util.List;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.entity.message.CollectRep;

public interface HistoryDataWriter {
    public boolean isServerAvailable();

    public void saveData(CollectRep.MetricsData var1);

    default public void saveLogData(LogEntry logEntry) {
        throw new UnsupportedOperationException("save log data is not supported");
    }

    default public boolean batchDeleteLogs(List<Long> timeUnixNanos) {
        throw new UnsupportedOperationException("batch delete logs is not supported");
    }

    default public void saveLogDataBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        for (LogEntry logEntry : logEntries) {
            this.saveLogData(logEntry);
        }
    }
}

