/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.ssl;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.utils.RandomUtils;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreSSLVerificationFactory {
    private static final Logger logger = LoggerFactory.getLogger(IgnoreSSLVerificationFactory.class);
    private static final HostnameVerifier HOST_VERIFIER = (hostname, sslSession) -> true;
    private static final X509TrustManager TRUST_ALL_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    private IgnoreSSLVerificationFactory() {
    }

    public static X509TrustManager getTrustAllManager() {
        return TRUST_ALL_MANAGER;
    }

    public static HostnameVerifier getHostnameVerifier() {
        return HOST_VERIFIER;
    }

    public static SSLContext getSSLContext() {
        return IgnoreSSLVerificationFactory.getSSLContext(RandomUtils.getDefaultSecureRandom());
    }

    public static SSLContext getSSLContext(SecureRandom secureRandom) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{TRUST_ALL_MANAGER}, secureRandom);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Init SSL Context Error", (Throwable)e);
            throw new SdkException("Init SSL Context Error", e);
        }
        catch (KeyManagementException e) {
            logger.error("Init SSL KeyManagement Error", (Throwable)e);
            throw new SdkException("Init SSL KeyManagement Error", e);
        }
    }
}

