/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "value", "type"})
public class AttributeNameValueModel {
    @JsonProperty(value="name")
    @Nonnull
    private String name;
    @JsonProperty(value="value")
    @Nonnull
    private Object value;
    @Nullable
    @JsonProperty(value="type")
    private Type type;

    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    public AttributeNameValueModel withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="value")
    @Nullable
    public Object getValue() {
        return this.value;
    }

    public AttributeNameValueModel withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    public AttributeNameValueModel withType(Type type) {
        this.type = type;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AttributeNameValueModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AttributeNameValueModel)) {
            return false;
        }
        AttributeNameValueModel rhs = (AttributeNameValueModel)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum Type {
        STRING("string"),
        BOOL("bool"),
        INT("int"),
        DOUBLE("double"),
        STRING_ARRAY("string_array"),
        BOOL_ARRAY("bool_array"),
        INT_ARRAY("int_array"),
        DOUBLE_ARRAY("double_array");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

