/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.SupportsConcurrentExecutionAttempts;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemCommitter;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.OutputFormatFactory;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.PartitionCommitPolicyFactory;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.connector.file.table.PartitionWriterFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSystemOutputFormat<T>
implements OutputFormat<T>,
FinalizeOnMaster,
Serializable,
SupportsConcurrentExecutionAttempts {
    private static final long serialVersionUID = 1L;
    private final FileSystemFactory fsFactory;
    private final TableMetaStoreFactory msFactory;
    private final boolean overwrite;
    private final boolean isToLocal;
    private final Path stagingPath;
    private final String[] partitionColumns;
    private final boolean dynamicGrouped;
    private final LinkedHashMap<String, String> staticPartitions;
    private final PartitionComputer<T> computer;
    private final OutputFormatFactory<T> formatFactory;
    private final OutputFileConfig outputFileConfig;
    private final ObjectIdentifier identifier;
    private final PartitionCommitPolicyFactory partitionCommitPolicyFactory;
    private transient PartitionWriter<T> writer;
    private transient Configuration parameters;

    private FileSystemOutputFormat(FileSystemFactory fsFactory, TableMetaStoreFactory msFactory, boolean overwrite, boolean isToLocal, Path stagingPath, String[] partitionColumns, boolean dynamicGrouped, LinkedHashMap<String, String> staticPartitions, OutputFormatFactory<T> formatFactory, PartitionComputer<T> computer, OutputFileConfig outputFileConfig, ObjectIdentifier identifier, PartitionCommitPolicyFactory partitionCommitPolicyFactory) {
        this.fsFactory = fsFactory;
        this.msFactory = msFactory;
        this.overwrite = overwrite;
        this.isToLocal = isToLocal;
        this.stagingPath = stagingPath;
        this.partitionColumns = partitionColumns;
        this.dynamicGrouped = dynamicGrouped;
        this.staticPartitions = staticPartitions;
        this.formatFactory = formatFactory;
        this.computer = computer;
        this.outputFileConfig = outputFileConfig;
        this.identifier = identifier;
        this.partitionCommitPolicyFactory = partitionCommitPolicyFactory;
        FileSystemOutputFormat.createStagingDirectory(this.stagingPath);
    }

    private static void createStagingDirectory(Path stagingPath) {
        try {
            FileSystem stagingFileSystem = stagingPath.getFileSystem();
            Preconditions.checkState((!stagingFileSystem.exists(stagingPath) ? 1 : 0) != 0, (String)"Staging dir %s already exists", (Object[])new Object[]{stagingPath});
            stagingFileSystem.mkdirs(stagingPath);
        }
        catch (IOException e) {
            throw new RuntimeException("An IO error occurred while accessing the staging FileSystem.", e);
        }
    }

    public void finalizeGlobal(FinalizeOnMaster.FinalizationContext context) {
        try {
            List<PartitionCommitPolicy> policies = Collections.emptyList();
            if (this.partitionCommitPolicyFactory != null) {
                policies = this.partitionCommitPolicyFactory.createPolicyChain(Thread.currentThread().getContextClassLoader(), () -> {
                    try {
                        return this.fsFactory.create(this.stagingPath.toUri());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            FileSystemCommitter committer = new FileSystemCommitter(this.fsFactory, this.msFactory, this.overwrite, this.stagingPath, this.partitionColumns.length, this.isToLocal, this.identifier, this.staticPartitions, policies);
            committer.commitPartitions((subtaskIndex, attemptNumber) -> {
                try {
                    if (context.getFinishedAttempt(subtaskIndex.intValue()) == attemptNumber.intValue()) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return false;
            });
        }
        catch (Exception e) {
            throw new TableException("Exception in finalizeGlobal", (Throwable)e);
        }
        finally {
            try {
                this.fsFactory.create(this.stagingPath.toUri()).delete(this.stagingPath, true);
            }
            catch (IOException iOException) {}
        }
    }

    public void configure(Configuration parameters) {
        this.parameters = parameters;
    }

    public void open(OutputFormat.InitializationContext context) throws IOException {
        try {
            PartitionTempFileManager fileManager = new PartitionTempFileManager(this.fsFactory, this.stagingPath, context.getTaskNumber(), context.getAttemptNumber(), this.outputFileConfig);
            PartitionWriter.Context<T> writerContext = new PartitionWriter.Context<T>(this.parameters, this.formatFactory);
            this.writer = PartitionWriterFactory.get(this.partitionColumns.length - this.staticPartitions.size() > 0, this.dynamicGrouped, this.staticPartitions).create(writerContext, fileManager, this.computer, new PartitionWriter.DefaultPartitionWriterListener());
        }
        catch (Exception e) {
            throw new TableException("Exception in open", (Throwable)e);
        }
    }

    public void writeRecord(T record) {
        try {
            this.writer.write(record);
        }
        catch (Exception e) {
            throw new TableException("Exception in writeRecord", (Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new TableException("Exception in close", (Throwable)e);
        }
    }

    public static class Builder<T> {
        private String[] partitionColumns;
        private OutputFormatFactory<T> formatFactory;
        private TableMetaStoreFactory metaStoreFactory;
        private Path stagingPath;
        private LinkedHashMap<String, String> staticPartitions = new LinkedHashMap();
        private boolean dynamicGrouped = false;
        private boolean overwrite = false;
        private boolean isToLocal = false;
        private FileSystemFactory fileSystemFactory = FileSystem::get;
        private PartitionComputer<T> computer;
        private OutputFileConfig outputFileConfig = new OutputFileConfig("", "");
        private ObjectIdentifier identifier;
        private PartitionCommitPolicyFactory partitionCommitPolicyFactory;

        public Builder<T> setPartitionColumns(String[] partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public Builder<T> setStaticPartitions(LinkedHashMap<String, String> staticPartitions) {
            this.staticPartitions = staticPartitions;
            return this;
        }

        public Builder<T> setDynamicGrouped(boolean dynamicGrouped) {
            this.dynamicGrouped = dynamicGrouped;
            return this;
        }

        public Builder<T> setFormatFactory(OutputFormatFactory<T> formatFactory) {
            this.formatFactory = formatFactory;
            return this;
        }

        public Builder<T> setFileSystemFactory(FileSystemFactory fileSystemFactory) {
            this.fileSystemFactory = fileSystemFactory;
            return this;
        }

        public Builder<T> setMetaStoreFactory(TableMetaStoreFactory metaStoreFactory) {
            this.metaStoreFactory = metaStoreFactory;
            return this;
        }

        public Builder<T> setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder<T> setIsToLocal(boolean isToLocal) {
            this.isToLocal = isToLocal;
            return this;
        }

        public Builder<T> setPath(Path parentPath) {
            this.stagingPath = this.toStagingPath(parentPath);
            return this;
        }

        @VisibleForTesting
        Builder<T> setStagingPath(Path stagingPath) {
            this.stagingPath = stagingPath;
            return this;
        }

        private Path toStagingPath(Path parentPath) {
            return new Path(parentPath, String.format(".staging_%d_%s", System.currentTimeMillis(), UUID.randomUUID()));
        }

        public Builder<T> setPartitionComputer(PartitionComputer<T> computer) {
            this.computer = computer;
            return this;
        }

        public Builder<T> setOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return this;
        }

        public Builder<T> setIdentifier(ObjectIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder<T> setPartitionCommitPolicyFactory(PartitionCommitPolicyFactory partitionCommitPolicyFactory) {
            this.partitionCommitPolicyFactory = partitionCommitPolicyFactory;
            return this;
        }

        public FileSystemOutputFormat<T> build() {
            Preconditions.checkNotNull((Object)this.partitionColumns, (String)"partitionColumns should not be null");
            Preconditions.checkNotNull(this.formatFactory, (String)"formatFactory should not be null");
            Preconditions.checkNotNull((Object)this.metaStoreFactory, (String)"metaStoreFactory should not be null");
            Preconditions.checkNotNull((Object)this.stagingPath, (String)"stagingPath should not be null");
            Preconditions.checkNotNull(this.computer, (String)"partitionComputer should not be null");
            return new FileSystemOutputFormat<T>(this.fileSystemFactory, this.metaStoreFactory, this.overwrite, this.isToLocal, this.stagingPath, this.partitionColumns, this.dynamicGrouped, this.staticPartitions, this.formatFactory, this.computer, this.outputFileConfig, this.identifier, this.partitionCommitPolicyFactory);
        }
    }
}

