/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.FilterCondition;
import org.apache.flink.table.runtime.generated.GeneratedFilterCondition;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.deduplicate.SyncStateDeduplicateFunctionBase;
import org.apache.flink.table.runtime.operators.deduplicate.utils.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class ProcTimeDeduplicateKeepLastRowFunction
extends SyncStateDeduplicateFunctionBase<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -291348892087180350L;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final boolean inputIsInsertOnly;
    private final boolean isStateTtlEnabled;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private final GeneratedFilterCondition genFilterCondition;
    private transient RecordEqualiser equaliser;
    private transient FilterCondition filterCondition;

    public ProcTimeDeduplicateKeepLastRowFunction(InternalTypeInfo<RowData> typeInfo, long stateRetentionTime, boolean generateUpdateBefore, boolean generateInsert, boolean inputInsertOnly, GeneratedRecordEqualiser genRecordEqualiser, GeneratedFilterCondition filterCondition) {
        super(typeInfo, null, stateRetentionTime);
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.inputIsInsertOnly = inputInsertOnly;
        this.genRecordEqualiser = genRecordEqualiser;
        this.genFilterCondition = filterCondition;
        this.isStateTtlEnabled = stateRetentionTime > 0L;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        if (this.genFilterCondition != null) {
            this.filterCondition = (FilterCondition)this.genFilterCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
            FunctionUtils.setFunctionRuntimeContext((Function)this.filterCondition, (RuntimeContext)this.getRuntimeContext());
            FunctionUtils.openFunction((Function)this.filterCondition, (OpenContext)openContext);
        }
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        if (this.inputIsInsertOnly) {
            DeduplicateFunctionHelper.processLastRowOnProcTime(input, this.generateUpdateBefore, this.generateInsert, (ValueState<RowData>)this.state, out, this.isStateTtlEnabled, this.equaliser);
        } else if (this.filterCondition != null) {
            DeduplicateFunctionHelper.processLastRowOnChangelogWithFilter(FilterCondition.Context.of(ctx), input, this.generateUpdateBefore, (ValueState<RowData>)this.state, out, this.isStateTtlEnabled, this.equaliser, this.filterCondition);
        } else {
            DeduplicateFunctionHelper.processLastRowOnChangelog(input, this.generateUpdateBefore, (ValueState<RowData>)this.state, out, this.isStateTtlEnabled, this.equaliser);
        }
    }
}

