/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.legacy.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.deltajoin.AsyncDeltaJoinRunner;
import org.apache.flink.table.runtime.operators.join.deltajoin.StreamingDeltaJoinOperator;
import org.apache.flink.table.types.logical.RowType;

public class StreamingDeltaJoinOperatorFactory
extends AbstractStreamOperatorFactory<RowData>
implements TwoInputStreamOperatorFactory<RowData, RowData, RowData>,
YieldingOperatorFactory<RowData> {
    private final AsyncDeltaJoinRunner rightLookupTableAsyncFunction;
    private final AsyncDeltaJoinRunner leftLookupTableAsyncFunction;
    private final RowDataKeySelector leftJoinKeySelector;
    private final RowDataKeySelector rightJoinKeySelector;
    private final long timeout;
    private final int capacity;
    private final long leftSideCacheSize;
    private final long rightSideCacheSize;
    private final RowType leftStreamType;
    private final RowType rightStreamType;

    public StreamingDeltaJoinOperatorFactory(AsyncDeltaJoinRunner rightLookupTableAsyncFunction, AsyncDeltaJoinRunner leftLookupTableAsyncFunction, RowDataKeySelector leftJoinKeySelector, RowDataKeySelector rightJoinKeySelector, long timeout, int capacity, long leftSideCacheSize, long rightSideCacheSize, RowType leftStreamType, RowType rightStreamType) {
        this.rightLookupTableAsyncFunction = rightLookupTableAsyncFunction;
        this.leftLookupTableAsyncFunction = leftLookupTableAsyncFunction;
        this.leftJoinKeySelector = leftJoinKeySelector;
        this.rightJoinKeySelector = rightJoinKeySelector;
        this.timeout = timeout;
        this.capacity = capacity;
        this.leftSideCacheSize = leftSideCacheSize;
        this.rightSideCacheSize = rightSideCacheSize;
        this.leftStreamType = leftStreamType;
        this.rightStreamType = rightStreamType;
    }

    public <T extends StreamOperator<RowData>> T createStreamOperator(StreamOperatorParameters<RowData> parameters) {
        MailboxExecutor mailboxExecutor = this.getMailboxExecutor();
        StreamingDeltaJoinOperator deltaJoinOperator = new StreamingDeltaJoinOperator(this.rightLookupTableAsyncFunction, this.leftLookupTableAsyncFunction, this.leftJoinKeySelector, this.rightJoinKeySelector, this.timeout, this.capacity, this.processingTimeService, mailboxExecutor, this.leftSideCacheSize, this.rightSideCacheSize, this.leftStreamType, this.rightStreamType);
        deltaJoinOperator.setup((StreamTask<?, ?>)parameters.getContainingTask(), parameters.getStreamConfig(), (Output<StreamRecord<RowData>>)parameters.getOutput());
        return (T)((Object)deltaJoinOperator);
    }

    public Class<? extends StreamOperator<?>> getStreamOperatorClass(ClassLoader classLoader) {
        return StreamingDeltaJoinOperator.class;
    }
}

