/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLookupJoin;
import org.apache.flink.table.planner.plan.nodes.exec.spec.TemporalTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.lookup.KeyedLookupJoinWrapper;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="stream-exec-lookup-join", version=1, producedTransformations={"lookup-join"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecLookupJoin
extends CommonExecLookupJoin
implements StreamExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_REQUIRE_UPSERT_MATERIALIZE = "requireUpsertMaterialize";
    public static final String PARTITIONER_TRANSFORMATION_LOOKUP_JOIN = "partitioner";
    public static final String FIELD_NAME_LOOKUP_KEY_CONTAINS_PRIMARY_KEY = "lookupKeyContainsPrimaryKey";
    public static final String STATE_NAME = "lookupJoinState";
    public static final String FIELD_NAME_INPUT_UPSERT_KEY = "inputUpsertKey";
    @JsonProperty(value="lookupKeyContainsPrimaryKey")
    private final boolean lookupKeyContainsPrimaryKey;
    @JsonProperty(value="requireUpsertMaterialize")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean upsertMaterialize;
    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;
    @Nullable
    @JsonProperty(value="inputUpsertKey")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final int[] inputUpsertKey;

    public StreamExecLookupJoin(ReadableConfig tableConfig, FlinkJoinType joinType, @Nullable RexNode preFilterCondition, @Nullable RexNode remainingJoinCondition, TemporalTableSourceSpec temporalTableSourceSpec, Map<Integer, FunctionCallUtil.FunctionParam> lookupKeys, @Nullable List<RexNode> projectionOnTemporalTable, @Nullable RexNode filterOnTemporalTable, boolean lookupKeyContainsPrimaryKey, boolean upsertMaterialize, @Nullable FunctionCallUtil.AsyncOptions asyncLookupOptions, @Nullable LookupJoinUtil.RetryLookupOptions retryOptions, ChangelogMode inputChangelogMode, @Nullable int[] inputUpsertKey, InputProperty inputProperty, RowType outputType, String description, boolean preferCustomShuffle) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecLookupJoin.class), ExecNodeContext.newPersistedConfig(StreamExecLookupJoin.class, tableConfig), joinType, preFilterCondition, remainingJoinCondition, temporalTableSourceSpec, lookupKeys, projectionOnTemporalTable, filterOnTemporalTable, lookupKeyContainsPrimaryKey, upsertMaterialize, asyncLookupOptions, retryOptions, inputChangelogMode, inputUpsertKey, upsertMaterialize ? StateMetadata.getOneInputOperatorDefaultMeta(tableConfig, STATE_NAME) : null, Collections.singletonList(inputProperty), outputType, description, preferCustomShuffle);
    }

    @JsonCreator
    public StreamExecLookupJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinType") FlinkJoinType joinType, @JsonProperty(value="preFilterCondition") @Nullable RexNode preFilterCondition, @JsonProperty(value="joinCondition") @Nullable RexNode remainingJoinCondition, @JsonProperty(value="temporalTable") TemporalTableSourceSpec temporalTableSourceSpec, @JsonProperty(value="lookupKeys") Map<Integer, FunctionCallUtil.FunctionParam> lookupKeys, @JsonProperty(value="projectionOnTemporalTable") @Nullable List<RexNode> projectionOnTemporalTable, @JsonProperty(value="filterOnTemporalTable") @Nullable RexNode filterOnTemporalTable, @JsonProperty(value="lookupKeyContainsPrimaryKey") boolean lookupKeyContainsPrimaryKey, @JsonProperty(value="requireUpsertMaterialize") boolean upsertMaterialize, @JsonProperty(value="asyncOptions") @Nullable FunctionCallUtil.AsyncOptions asyncLookupOptions, @JsonProperty(value="retryOptions") @Nullable LookupJoinUtil.RetryLookupOptions retryOptions, @JsonProperty(value="inputChangelogMode") @Nullable ChangelogMode inputChangelogMode, @JsonProperty(value="inputUpsertKey") @Nullable int[] inputUpsertKey, @JsonProperty(value="state") @Nullable List<StateMetadata> stateMetadataList, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="preferCustomShuffle") boolean preferCustomShuffle) {
        super(id, context, persistedConfig, joinType, preFilterCondition, remainingJoinCondition, temporalTableSourceSpec, lookupKeys, projectionOnTemporalTable, filterOnTemporalTable, asyncLookupOptions, retryOptions, inputChangelogMode, inputProperties, outputType, description, preferCustomShuffle);
        this.lookupKeyContainsPrimaryKey = lookupKeyContainsPrimaryKey;
        this.upsertMaterialize = upsertMaterialize;
        this.inputUpsertKey = inputUpsertKey;
        this.stateMetadataList = stateMetadataList;
    }

    @Override
    public Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        return this.createJoinTransformation(planner, config, this.upsertMaterialize, this.lookupKeyContainsPrimaryKey);
    }

    @Override
    protected Transformation<RowData> createKeyOrderedAsyncLookupJoin(Transformation<RowData> inputTransformation, RelOptTable temporalTable, ExecNodeConfig config, ClassLoader classLoader, Map<Integer, FunctionCallUtil.FunctionParam> allLookupKeys, AsyncTableFunction<Object> asyncLookupFunction, RelBuilder relBuilder, RowType inputRowType, RowType tableSourceRowType, RowType resultRowType, boolean isLeftOuterJoin, FunctionCallUtil.AsyncOptions asyncLookupOptions) {
        RowDataKeySelector keySelector = this.getKeySelector(classLoader, inputRowType);
        Transformation<RowData> partitionedTransform = this.createPartitionTransformation(keySelector, inputTransformation, config);
        StreamOperatorFactory<RowData> operatorFactory = this.createAsyncLookupJoin(temporalTable, config, classLoader, allLookupKeys, asyncLookupFunction, relBuilder, inputRowType, tableSourceRowType, resultRowType, isLeftOuterJoin, asyncLookupOptions, keySelector);
        OneInputTransformation<RowData, RowData> transform = ExecNodeUtil.createOneInputTransformation(partitionedTransform, this.createTransformationMeta("lookup-join-key-ordered", config), operatorFactory, InternalTypeInfo.of((RowType)resultRowType), partitionedTransform.getParallelism(), false);
        transform.setStateKeySelector((KeySelector)keySelector);
        transform.setStateKeyType((TypeInformation)keySelector.getProducedType());
        return transform;
    }

    @Override
    protected Transformation<RowData> createSyncLookupJoinWithState(Transformation<RowData> inputTransformation, RelOptTable temporalTable, ExecNodeConfig config, ClassLoader classLoader, Map<Integer, FunctionCallUtil.FunctionParam> allLookupKeys, TableFunction<?> syncLookupFunction, RelBuilder relBuilder, RowType inputRowType, RowType tableSourceRowType, RowType resultRowType, boolean isLeftOuterJoin, boolean isObjectReuseEnabled, boolean lookupKeyContainsPrimaryKey) {
        long stateRetentionTime = StateMetadata.getStateTtlForOneInputOperator(config, this.stateMetadataList);
        ProcessFunction<RowData, RowData> processFunction = this.createSyncLookupJoinFunction(temporalTable, config, classLoader, allLookupKeys, syncLookupFunction, relBuilder, inputRowType, tableSourceRowType, resultRowType, isLeftOuterJoin, isObjectReuseEnabled);
        RowType rightRowType = this.getRightOutputRowType(this.getProjectionOutputRelDataType(relBuilder), tableSourceRowType);
        KeyedLookupJoinWrapper keyedLookupJoinWrapper = new KeyedLookupJoinWrapper((LookupJoinRunner)processFunction, StateConfigUtil.createTtlConfig((long)stateRetentionTime), (TypeSerializer)InternalSerializers.create((RowType)rightRowType), lookupKeyContainsPrimaryKey);
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)keyedLookupJoinWrapper);
        RowDataKeySelector keySelector = this.getKeySelector(classLoader, inputRowType);
        Transformation<RowData> partitionedTransform = this.createPartitionTransformation(keySelector, inputTransformation, config);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(partitionedTransform, this.createTransformationMeta("lookup-join-materialize", config), operator, InternalTypeInfo.of((RowType)resultRowType), partitionedTransform.getParallelism(), false);
        transform.setStateKeySelector((KeySelector)keySelector);
        transform.setStateKeyType((TypeInformation)keySelector.getProducedType());
        return transform;
    }

    private RowDataKeySelector getKeySelector(ClassLoader classLoader, RowType inputRowType) {
        int[] shuffleKeys = this.inputUpsertKey;
        if (shuffleKeys == null || shuffleKeys.length == 0) {
            shuffleKeys = IntStream.range(0, inputRowType.getFieldCount()).toArray();
        } else {
            Arrays.sort(shuffleKeys);
        }
        RowDataKeySelector keySelector = KeySelectorUtil.getRowDataSelector(classLoader, shuffleKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        return keySelector;
    }

    private Transformation<RowData> createPartitionTransformation(RowDataKeySelector keySelector, Transformation<RowData> inputTransformation, ExecNodeConfig config) {
        KeyGroupStreamPartitioner partitioner = new KeyGroupStreamPartitioner((KeySelector)keySelector, 128);
        PartitionTransformation partitionedTransform = new PartitionTransformation(inputTransformation, (StreamPartitioner)partitioner);
        this.createTransformationMeta(PARTITIONER_TRANSFORMATION_LOOKUP_JOIN, "Partitioner", "Partitioner", config).fill(partitionedTransform);
        partitionedTransform.setParallelism(inputTransformation.getParallelism(), false);
        return partitionedTransform;
    }
}

