/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import java.util.Optional;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropPrimaryKey;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SchemaReferencesManager;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableDropPrimaryKeyConverter
extends AbstractAlterTableConverter<SqlAlterTableDropPrimaryKey> {
    @Override
    public Operation convertToOperation(SqlAlterTableDropPrimaryKey sqlAlterTable, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        Optional pkConstraint = oldTable.getResolvedSchema().getPrimaryKey();
        if (pkConstraint.isEmpty()) {
            throw new ValidationException(String.format("%sThe base table does not define any primary key.", "Failed to execute ALTER TABLE statement.\n"));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        SchemaReferencesManager.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> builder.fromColumns(List.of(column)));
        SchemaReferencesManager.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(sqlAlterTable, List.of(TableChange.dropConstraint((String)((UniqueConstraint)pkConstraint.get()).getName())), schemaBuilder.build(), oldTable, context.getCatalogManager());
    }
}

