/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class ArrayToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<ArrayData, String> {
    static final ArrayToStringCastRule INSTANCE = new ArrayToStringCastRule();

    private ArrayToStringCastRule() {
        super(CastRulePredicate.builder().predicate((input, target) -> input.is(LogicalTypeRoot.ARRAY) && target.is(LogicalTypeFamily.CHARACTER_STRING) && CastRuleProvider.exists(((ArrayType)input).getElementType(), target)).build());
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        LogicalType innerInputType = ((ArrayType)inputLogicalType).getElementType();
        CodeGeneratorContext codeGeneratorContext = context.getCodeGeneratorContext();
        String builderTerm = CodeGenUtils.newName(codeGeneratorContext, "builder");
        context.declareClassField(CodeGenUtils.className(StringBuilder.class), builderTerm, CastRuleUtils.constructorCall(StringBuilder.class, new Object[0]));
        String resultStringTerm = CodeGenUtils.newName(codeGeneratorContext, "resultString");
        int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter().stmt(CastRuleUtils.methodCall(builderTerm, "setLength", 0)).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("["))).forStmt(CastRuleUtils.methodCall(inputTerm, "size", new Object[0]), (indexTerm, loopBodyWriter) -> {
            String elementTerm = CodeGenUtils.newName(codeGeneratorContext, "element");
            String elementIsNullTerm = CodeGenUtils.newName(codeGeneratorContext, "elementIsNull");
            CastCodeBlock codeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, elementTerm, innerInputType, (LogicalType)VarCharType.STRING_TYPE);
            if (!context.legacyBehaviour() && CharVarCharTrimPadCastRule.couldTrim(length)) {
                loopBodyWriter.ifStmt(CharVarCharTrimPadCastRule.stringExceedsLength(builderTerm, length), CastRuleUtils.CodeWriter::breakStmt);
            }
            loopBodyWriter.ifStmt(indexTerm + " != 0", thenBodyWriter -> thenBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(", ")))).declPrimitiveStmt(innerInputType, elementTerm).declStmt(Boolean.TYPE, elementIsNullTerm, CastRuleUtils.methodCall(inputTerm, "isNullAt", indexTerm)).ifStmt("!" + elementIsNullTerm, thenBodyWriter -> thenBodyWriter.assignStmt(elementTerm, CodeGenUtils.rowFieldReadAccess(indexTerm, inputTerm, innerInputType)).append(codeBlock).stmt(CastRuleUtils.methodCall(builderTerm, "append", codeBlock.getReturnTerm())), elseBodyWriter -> elseBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.nullLiteral(context.legacyBehaviour()))));
        }, codeGeneratorContext).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("]")));
        return CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(writer, targetLogicalType, context.legacyBehaviour(), length, resultStringTerm, builderTerm, codeGeneratorContext).assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)).toString();
    }
}

