/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SingleColumnAliasRelDataType
implements RelDataType {
    private final RelDataType original;
    private final RelDataType alias;

    public SingleColumnAliasRelDataType(RelDataType original, RelDataType alias) {
        assert (original.isStruct() && original.getFieldCount() == 1);
        assert (alias.isStruct() && alias.getFieldCount() == 1);
        this.original = original;
        this.alias = alias;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.original.getFieldList();
    }

    @Override
    public List<String> getFieldNames() {
        return this.original.getFieldNames();
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public StructKind getStructKind() {
        return this.original.getStructKind();
    }

    @Override
    public @Nullable RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        RelDataTypeField originalField = this.original.getField(fieldName, caseSensitive, elideRecord);
        return originalField == null ? this.alias.getField(fieldName, caseSensitive, elideRecord) : originalField;
    }

    @Override
    public boolean isNullable() {
        return this.original.isNullable();
    }

    @Override
    public @Nullable RelDataType getComponentType() {
        return this.original.getComponentType();
    }

    @Override
    public @Nullable RelDataType getKeyType() {
        return this.original.getKeyType();
    }

    @Override
    public @Nullable RelDataType getValueType() {
        return this.original.getValueType();
    }

    @Override
    public @Nullable Charset getCharset() {
        return this.original.getCharset();
    }

    @Override
    public @Nullable SqlCollation getCollation() {
        return this.original.getCollation();
    }

    @Override
    public @Nullable SqlIntervalQualifier getIntervalQualifier() {
        return this.original.getIntervalQualifier();
    }

    @Override
    public int getPrecision() {
        return this.original.getPrecision();
    }

    @Override
    public int getScale() {
        return this.original.getScale();
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return this.original.getSqlTypeName();
    }

    @Override
    public @Nullable SqlIdentifier getSqlIdentifier() {
        return this.original.getSqlIdentifier();
    }

    @Override
    public String getFullTypeString() {
        return this.original.getFullTypeString();
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this.original.getFamily();
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return this.original.getPrecedenceList();
    }

    @Override
    public RelDataTypeComparability getComparability() {
        return this.original.getComparability();
    }

    @Override
    public boolean isDynamicStruct() {
        return this.original.isDynamicStruct();
    }
}

