/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Map;
import java.util.Objects;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.wrappers.PreprocessorWrapper;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;
import org.osgi.service.servlet.whiteboard.Preprocessor;

public class PreprocessorInfo
extends WhiteboardServiceInfo<Preprocessor> {
    private final Map<String, String> initParams;

    public PreprocessorInfo(ServiceReference<Preprocessor> ref) {
        super(ref);
        this.initParams = this.getInitParams(ref, "preprocessor.init.");
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }

    @Override
    @NotNull
    public String getType() {
        return "Preprocessor";
    }

    @NotNull
    public String getClassName(@NotNull Preprocessor preprocessor) {
        if (preprocessor instanceof PreprocessorWrapper) {
            return ((PreprocessorWrapper)preprocessor).getPreprocessor().getClass().getName();
        }
        return preprocessor.getClass().getName();
    }

    @Override
    public boolean isSame(AbstractInfo<Preprocessor> other) {
        if (!super.isSame(other)) {
            return false;
        }
        PreprocessorInfo o = (PreprocessorInfo)other;
        return Objects.equals(this.initParams, o.initParams);
    }
}

