/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.registry.RegistryService;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryFactory.class);
    private static final Map<String, RegistryService> META_CACHE = new HashMap<String, RegistryService>(16);

    public static RegistryService getInstance(String registryPluginType) {
        return META_CACHE.computeIfAbsent(registryPluginType, RegistryFactory::registryBuilder);
    }

    private static RegistryService registryBuilder(String registryPluginType) {
        RegistryService registryServiceExt = (RegistryService)EventMeshExtensionFactory.getExtension(RegistryService.class, (String)registryPluginType);
        if (registryServiceExt == null) {
            String errorMsg = "can't load the registry plugin, please check.";
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        log.info("build registry plugin [{}] by type [{}] success", (Object)registryServiceExt.getClass().getSimpleName(), (Object)registryPluginType);
        return registryServiceExt;
    }
}

