/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.admin.command;

import java.util.UUID;
import lombok.Generated;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.storage.rocketmq.config.ClientConfiguration;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public abstract class Command {
    protected DefaultMQAdminExt adminExt;
    protected String nameServerAddr;
    protected String clusterName;

    public void init() {
        ConfigService configService = ConfigService.getInstance();
        ClientConfiguration clientConfiguration = (ClientConfiguration)configService.buildConfigInstance(ClientConfiguration.class);
        this.nameServerAddr = clientConfiguration.getNamesrvAddr();
        this.clusterName = clientConfiguration.getClusterName();
        String accessKey = clientConfiguration.getAccessKey();
        String secretKey = clientConfiguration.getSecretKey();
        AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
        this.adminExt = new DefaultMQAdminExt((RPCHook)rpcHook);
        String groupId = UUID.randomUUID().toString();
        this.adminExt.setAdminExtGroup("admin_ext_group-" + groupId);
        this.adminExt.setNamesrvAddr(this.nameServerAddr);
    }

    public abstract void execute() throws Exception;

    @Generated
    public Command() {
    }

    @Generated
    public DefaultMQAdminExt getAdminExt() {
        return this.adminExt;
    }

    @Generated
    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public void setAdminExt(DefaultMQAdminExt adminExt) {
        this.adminExt = adminExt;
    }

    @Generated
    public void setNameServerAddr(String nameServerAddr) {
        this.nameServerAddr = nameServerAddr;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command other = (Command)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DefaultMQAdminExt this$adminExt = this.getAdminExt();
        DefaultMQAdminExt other$adminExt = other.getAdminExt();
        if (this$adminExt == null ? other$adminExt != null : !this$adminExt.equals(other$adminExt)) {
            return false;
        }
        String this$nameServerAddr = this.getNameServerAddr();
        String other$nameServerAddr = other.getNameServerAddr();
        if (this$nameServerAddr == null ? other$nameServerAddr != null : !this$nameServerAddr.equals(other$nameServerAddr)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        return !(this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Command;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultMQAdminExt $adminExt = this.getAdminExt();
        result = result * 59 + ($adminExt == null ? 43 : $adminExt.hashCode());
        String $nameServerAddr = this.getNameServerAddr();
        result = result * 59 + ($nameServerAddr == null ? 43 : $nameServerAddr.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Command(adminExt=" + this.getAdminExt() + ", nameServerAddr=" + this.getNameServerAddr() + ", clusterName=" + this.getClusterName() + ")";
    }
}

