/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.spring;

import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.instance.core.CanalInstanceGenerator;
import com.alibaba.otter.canal.parse.CanalEventParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCanalInstanceGenerator
implements CanalInstanceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SpringCanalInstanceGenerator.class);
    private String springXml;
    private String defaultName = "instance";
    private BeanFactory beanFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CanalInstance generate(String destination) {
        Class<CanalEventParser> clazz = CanalEventParser.class;
        synchronized (CanalEventParser.class) {
            try {
                System.setProperty("canal.instance.destination", destination);
                this.beanFactory = this.getBeanFactory(this.springXml);
                String beanName = destination;
                if (!this.beanFactory.containsBean(beanName)) {
                    beanName = this.defaultName;
                }
                CanalInstance canalInstance = (CanalInstance)this.beanFactory.getBean(beanName);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return canalInstance;
            }
            catch (Throwable e) {
                logger.error("generator instance failed.", e);
                throw new CanalException(e);
            }
            finally {
                System.setProperty("canal.instance.destination", "");
            }
        }
    }

    private BeanFactory getBeanFactory(String springXml) {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(springXml);
        return applicationContext;
    }

    public void setSpringXml(String springXml) {
        this.springXml = springXml;
    }
}

