/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ThreadMXBeanUtils {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean OBJECT_MONITOR_USAGE_SUPPORT = THREAD_MX_BEAN.isObjectMonitorUsageSupported();
    private static final boolean SYNCHRONIZER_USAGE_SUPPORT = THREAD_MX_BEAN.isSynchronizerUsageSupported();
    private static final boolean CONTENTION_MONITORING_SUPPORT = THREAD_MX_BEAN.isThreadContentionMonitoringSupported();
    private static final int DEFAULT_STACK_TRACE_MAX_DEPTH = 32;

    private ThreadMXBeanUtils() {
    }

    static String getOption() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThreadMXBean SupportOption:{OBJECT_MONITOR_USAGE_SUPPORT=");
        builder.append(OBJECT_MONITOR_USAGE_SUPPORT);
        builder.append("}, {SYNCHRONIZER_USAGE_SUPPORT=");
        builder.append(SYNCHRONIZER_USAGE_SUPPORT);
        builder.append("}, {CONTENTION_MONITORING_SUPPORT=");
        builder.append(CONTENTION_MONITORING_SUPPORT);
        builder.append('}');
        return builder.toString();
    }

    public static ThreadInfo[] dumpAllThread() {
        return THREAD_MX_BEAN.dumpAllThreads(OBJECT_MONITOR_USAGE_SUPPORT, SYNCHRONIZER_USAGE_SUPPORT);
    }

    public static ThreadInfo getThreadInfo(long id) {
        return ThreadMXBeanUtils.getThreadInfo(id, 32);
    }

    public static ThreadInfo getThreadInfo(long id, int stackTraceMaxDepth) {
        if (stackTraceMaxDepth <= 0) {
            return THREAD_MX_BEAN.getThreadInfo(id);
        }
        return THREAD_MX_BEAN.getThreadInfo(id, stackTraceMaxDepth);
    }

    public static ThreadInfo[] findThread(long[] id, int stackTraceMaxDepth) {
        if (stackTraceMaxDepth <= 0) {
            return THREAD_MX_BEAN.getThreadInfo(id);
        }
        return THREAD_MX_BEAN.getThreadInfo(id, stackTraceMaxDepth);
    }

    public static List<ThreadInfo> findThread(String threadName) {
        Objects.requireNonNull(threadName, "threadName");
        ThreadInfo[] threadInfos = ThreadMXBeanUtils.dumpAllThread();
        if (threadInfos == null) {
            return Collections.emptyList();
        }
        ArrayList<ThreadInfo> threadInfoList = new ArrayList<ThreadInfo>(1);
        for (ThreadInfo threadInfo : threadInfos) {
            if (!threadName.equals(threadInfo.getThreadName())) continue;
            threadInfoList.add(threadInfo);
        }
        return threadInfoList;
    }

    public static boolean findThreadName(ThreadInfo[] threadInfos, String threadName) {
        if (threadInfos == null) {
            return false;
        }
        if (threadName == null) {
            return false;
        }
        for (ThreadInfo threadInfo : threadInfos) {
            if (!threadInfo.getThreadName().equals(threadName)) continue;
            return true;
        }
        return false;
    }

    public static boolean findThreadName(String threadName) {
        if (threadName == null) {
            return false;
        }
        ThreadInfo[] threadInfos = ThreadMXBeanUtils.dumpAllThread();
        return ThreadMXBeanUtils.findThreadName(threadInfos, threadName);
    }

    public static long[] findDeadlockedThreads() {
        return THREAD_MX_BEAN.findDeadlockedThreads();
    }
}

