/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.StringUtils;

public final class ArrayUtils {
    private static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 32;
    private static final char DELIMITER = ',';

    private ArrayUtils() {
    }

    public static String abbreviate(byte[] bytes) {
        return ArrayUtils.abbreviate(bytes, 32);
    }

    public static String abbreviate(byte[] bytes, int maxWidth) {
        if (bytes == null) {
            return "null";
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth");
        }
        if (bytes.length == 0) {
            return "[]";
        }
        if (maxWidth == 0) {
            return "[...(" + bytes.length + ")]";
        }
        int bytesMaxLength = Math.min(bytes.length, maxWidth);
        StringBuilder sb = new StringBuilder(ArrayUtils.abbreviateBufferSize(bytes, maxWidth));
        sb.append('[');
        int lastIndex = bytesMaxLength - 1;
        for (int i = 0; i < bytesMaxLength; ++i) {
            sb.append(bytes[i]);
            if (i >= lastIndex) continue;
            sb.append(',');
        }
        if (bytes.length <= maxWidth) {
            sb.append(']');
        } else {
            sb.append(',');
            sb.append("...(");
            sb.append(bytes.length);
            sb.append(")]");
        }
        return sb.toString();
    }

    static int stringLength(byte[] bytes, int toOffset) {
        int length = 0;
        for (int i = 0; i < toOffset; ++i) {
            byte b = bytes[i];
            length += StringUtils.stringLength(b);
        }
        return length;
    }

    static int abbreviateBufferSize(byte[] bytes, int maxWidth) {
        int min = Math.min(bytes.length, maxWidth);
        int delimiter = Math.max(min - 1, 0);
        int defaultBufferSize = ArrayUtils.stringLength(bytes, min) + delimiter;
        if (bytes.length <= maxWidth) {
            return defaultBufferSize + "[]".length();
        }
        int size = defaultBufferSize + StringUtils.stringLength(bytes.length);
        if (defaultBufferSize == 0) {
            return size + "[...()]".length();
        }
        return size + "[,...()]".length();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean hasLength(T[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(long[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(int[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(short[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(char[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(byte[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(double[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(float[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(boolean[] array) {
        return array != null && array.length != 0;
    }

    public static int getLength(long[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(int[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(short[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(char[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(byte[] array) {
        return ArrayUtils.getLength(array, 0);
    }

    public static int getLength(byte[] array, int nullValue) {
        if (array == null) {
            return nullValue;
        }
        return array.length;
    }

    public static int getLength(double[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(float[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(boolean[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static <T> int getLength(T[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static <T> T get(T[] array, int index) {
        return ArrayUtils.get(array, index, null);
    }

    public static <T> T get(T[] array, int index, T defaultValue) {
        return ArrayUtils.isArrayIndexValid(array, index) ? array[index] : defaultValue;
    }

    public static <T> boolean isArrayIndexValid(T[] array, int index) {
        return index >= 0 && ArrayUtils.getLength(array) > index;
    }
}

