/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import java.util.EnumSet;

public enum UriStatHistogramBucket {
    UNDER_100(0L, 100L, 0),
    RANGE_100_300(100L, 300L, 1),
    RANGE_300_500(300L, 500L, 2),
    RANGE_500_1000(500L, 1000L, 3),
    RANGE_1000_3000(1000L, 3000L, 4),
    RANGE_3000_5000(3000L, 5000L, 5),
    RANGE_5000_8000(5000L, 8000L, 6),
    OVER_8000MS(8000L, Long.MAX_VALUE, 7);

    private final long from;
    private final long to;
    private final int index;
    private final String description;
    private static final EnumSet<UriStatHistogramBucket> BUCKETS;
    private static final int SIZE;

    private UriStatHistogramBucket(long from, long to, int index) {
        this.from = from;
        this.to = to;
        this.index = index;
        this.description = to == Long.MAX_VALUE ? from + " ~ " : from + " ~ " + to;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.description;
    }

    public static Layout getLayout() {
        return Layout.INSTANCE;
    }

    static {
        BUCKETS = EnumSet.allOf(UriStatHistogramBucket.class);
        SIZE = BUCKETS.size();
    }

    public static class Layout {
        static final Layout INSTANCE = new Layout();

        public UriStatHistogramBucket getBucket(long elapsed) {
            for (UriStatHistogramBucket histogram : BUCKETS) {
                if (elapsed >= histogram.getTo()) continue;
                return histogram;
            }
            return OVER_8000MS;
        }

        public UriStatHistogramBucket getBucketByIndex(int index) {
            for (UriStatHistogramBucket histogram : BUCKETS) {
                if (histogram.getIndex() != index) continue;
                return histogram;
            }
            throw new IndexOutOfBoundsException("Can not find index. index:" + index);
        }

        public int getBucketSize() {
            return SIZE;
        }

        public byte getBucketVersion() {
            return 0;
        }
    }
}

