/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import java.nio.ByteBuffer;

public class ByteBufferUtils {
    public static final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    public static ByteBuffer slice(ByteBuffer orig, int begin, int length) {
        int pos = orig.position();
        int limit = orig.limit();
        orig.limit(begin + length);
        orig.position(begin);
        ByteBuffer result = orig.slice();
        orig.limit(limit);
        orig.position(pos);
        return result;
    }

    public static int copy(ByteBuffer from, ByteBuffer to) {
        int toCopy = Math.min(from.remaining(), to.remaining());
        int originalFromLimit = from.limit();
        from.limit(from.position() + toCopy);
        to.put(from);
        from.limit(originalFromLimit);
        return toCopy;
    }
}

