/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.SinkConfig;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.openconnect.ConnectorWorker;
import org.apache.eventmesh.openconnect.SinkWorker;
import org.apache.eventmesh.openconnect.SourceWorker;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.Connector;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    public static final Map<String, Connector> CONNECTOR_MAP = new HashMap<String, Connector>();
    public static final String CREATE_EXTENSION_KEY = "createExtension";
    private Map<String, String> extensions;

    public Application() {
    }

    public Application(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public void run(Class<? extends Connector> clazz) throws Exception {
        ConnectorWorker worker;
        Config config;
        Connector connector = null;
        try {
            String spiKey;
            ConnectorCreateService createService;
            if (MapUtils.isNotEmpty(this.extensions) && this.extensions.containsKey(CREATE_EXTENSION_KEY) && (createService = (ConnectorCreateService)EventMeshExtensionFactory.getExtension(ConnectorCreateService.class, (String)(spiKey = this.extensions.get(CREATE_EXTENSION_KEY)))) != null) {
                connector = createService.create();
            }
            if (connector == null) {
                connector = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("new connector error", (Throwable)e);
            return;
        }
        try {
            config = ConfigUtil.parse(connector.configClass());
        }
        catch (Exception e) {
            log.error("parse config error", (Throwable)e);
            return;
        }
        if (Application.isSink(clazz)) {
            worker = new SinkWorker((Sink)connector, (SinkConfig)config);
        } else if (Application.isSource(clazz)) {
            worker = new SourceWorker((Source)connector, (SourceConfig)config);
        } else {
            log.error("class {} is not sink and source", clazz);
            return;
        }
        worker.init();
        CONNECTOR_MAP.putIfAbsent(connector.name(), connector);
        Connector finalConnector = connector;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            worker.stop();
            log.info("connector {} stopped", (Object)finalConnector.name());
        }));
        worker.start();
        log.info("connector {} started", (Object)connector.name());
    }

    public static boolean isAssignableFrom(Class<?> c, Class<?> cls) {
        Class<?>[] clazzArr;
        for (Class<?> clazz : clazzArr = c.getInterfaces()) {
            if (!clazz.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSink(Class<?> c) {
        while (c != null && c != Object.class) {
            if (Application.isAssignableFrom(c, Sink.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isSource(Class<?> c) {
        while (c != null && c != Object.class) {
            if (Application.isAssignableFrom(c, Source.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }
}

