/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RSetCache;
import org.redisson.client.RedisClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.BaseTransactionalSet;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.set.AddCacheOperation;
import org.redisson.transaction.operation.set.MoveOperation;
import org.redisson.transaction.operation.set.RemoveCacheOperation;

public class TransactionalSetCache<V>
extends BaseTransactionalSet<V> {
    private final RSetCache<V> set;
    private final String transactionId;

    public TransactionalSetCache(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RSetCache<V> set, String transactionId) {
        super(commandExecutor, timeout, operations, set, transactionId);
        this.set = set;
        this.transactionId = transactionId;
    }

    @Override
    protected ScanResult<Object> scanIteratorSource(String name, RedisClient client, String startPos, String pattern, int count) {
        return ((ScanIterator)((Object)this.set)).scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    protected RFuture<Set<V>> readAllAsyncSource() {
        return this.set.readAllAsync();
    }

    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit ttlUnit) {
        long threadId = Thread.currentThread().getId();
        return this.addAsync(value, new AddCacheOperation(this.set, value, ttl, ttlUnit, this.transactionId, threadId));
    }

    @Override
    protected TransactionalOperation createAddOperation(V value, long threadId) {
        return new AddCacheOperation(this.set, value, this.transactionId, threadId);
    }

    @Override
    protected MoveOperation createMoveOperation(String destination, V value, long threadId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TransactionalOperation createRemoveOperation(Object value, long threadId) {
        return new RemoveCacheOperation(this.set, value, this.transactionId, threadId);
    }
}

