/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.Version;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.SerializationException;

public class VersionImpl
implements Version,
Serializable {
    public static final long NO_SEGMENT_ID = Long.MIN_VALUE;
    private final long segmentId;
    private final TableSegmentKeyVersion segmentVersion;

    VersionImpl(long segmentId, long segmentVersion) {
        this(segmentId, TableSegmentKeyVersion.from(segmentVersion));
    }

    public long getSegmentVersion() {
        return this.segmentVersion.getSegmentVersion();
    }

    @Override
    public VersionImpl asImpl() {
        return this;
    }

    @Override
    public String toString() {
        return String.format("%d:%d", this.segmentId, this.getSegmentVersion());
    }

    public static VersionImpl fromString(String str) {
        String[] tokens = str.split(":");
        if (tokens.length == 2) {
            return new VersionImpl(Long.parseLong(tokens[0]), Long.parseLong(tokens[1]));
        }
        throw new SerializationException(String.format("Not a valid KeyVersion serialization: '%s'.", str));
    }

    @ConstructorProperties(value={"segmentId", "segmentVersion"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VersionImpl(long segmentId, TableSegmentKeyVersion segmentVersion) {
        this.segmentId = segmentId;
        this.segmentVersion = segmentVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionImpl)) {
            return false;
        }
        VersionImpl other = (VersionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSegmentId() != other.getSegmentId()) {
            return false;
        }
        return this.getSegmentVersion() == other.getSegmentVersion();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VersionImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $segmentId = this.getSegmentId();
        result = result * 59 + (int)($segmentId >>> 32 ^ $segmentId);
        long $segmentVersion = this.getSegmentVersion();
        result = result * 59 + (int)($segmentVersion >>> 32 ^ $segmentVersion);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    long getSegmentId() {
        return this.segmentId;
    }
}

