/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.presto.visitor;

import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterFunctionStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.presto.visitor.PrestoVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.math.BigDecimal;
import java.util.List;

public class PrestoOutputVisitor
extends SQLASTOutputVisitor
implements PrestoVisitor {
    public PrestoOutputVisitor(StringBuilder appender) {
        super(appender);
    }

    public PrestoOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLLimit x) {
        if (x.getOffset() != null) {
            this.print0(this.ucase ? " OFFSET " : " offset ");
            x.getOffset().accept(this);
        }
        this.print0(this.ucase ? " LIMIT " : " limit ");
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDecimalExpr x) {
        BigDecimal value = x.getValue();
        this.print0(this.ucase ? "DECIMAL '" : "decimal '");
        this.print(value.toString());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        SQLSelect select;
        List<SQLAssignItem> options;
        this.printCreateTable(x, false);
        if (null != x.getComment()) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            this.printExpr(x.getComment());
        }
        if ((options = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH (" : "with (");
            this.printAndAccept(options, ", ");
            this.print(')');
        }
        if ((select = x.getSelect()) != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            this.visit(select);
        }
        return false;
    }

    @Override
    public boolean visit(PrestoAlterFunctionStatement x) {
        this.print0(this.ucase ? "ALTER FUNCTION " : "alter function ");
        x.getName().accept(this);
        if (x.isCalledOnNullInput()) {
            this.print0(" CALLED ON NULL INPUT");
        }
        if (x.isReturnsNullOnNullInput()) {
            this.print0(" RETURNS NULL ON NULL INPUT");
        }
        return false;
    }

    @Override
    public boolean visit(PrestoAlterSchemaStatement x) {
        this.print0(this.ucase ? "ALTER SCHEMA " : "alter achema ");
        x.getSchemaName().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getNewName().accept(this);
        return false;
    }
}

