/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.kafka.producer;

import io.cloudevents.CloudEvent;
import io.cloudevents.kafka.CloudEventSerializer;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    private final KafkaProducer<String, CloudEvent> producer;
    private final Properties properties = new Properties();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public ProducerImpl(Properties props) {
        this.properties.put("bootstrap.servers", props.getProperty("bootstrap.servers"));
        this.properties.put("key.serializer", StringSerializer.class);
        this.properties.put("value.serializer", CloudEventSerializer.class);
        this.producer = new KafkaProducer(this.properties);
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
    }

    public void init(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void send(CloudEvent cloudEvent) {
        try {
            this.producer.send(new ProducerRecord(Objects.requireNonNull(cloudEvent.getSubject()), (Object)cloudEvent));
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", cloudEvent), (Throwable)e);
        }
    }

    public void checkTopicExist(String topic) throws ExecutionException, InterruptedException, StorageRuntimeException {
        try (Admin admin = Admin.create((Properties)this.properties);){
            Set topicNames = (Set)admin.listTopics().names().get();
            boolean exist = topicNames.contains(topic);
            if (!exist) {
                throw new StorageRuntimeException(String.format("topic:%s is not exist", topic));
            }
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new StorageRuntimeException("Request is not supported");
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new StorageRuntimeException("Reply is not supported");
    }

    public void sendOneway(CloudEvent message) {
    }

    public void sendAsync(CloudEvent cloudEvent, SendCallback sendCallback) {
        try {
            this.producer.send(new ProducerRecord(Objects.requireNonNull(cloudEvent.getSubject()), (Object)cloudEvent), (metadata, exception) -> {
                if (exception != null) {
                    StorageRuntimeException onsEx = new StorageRuntimeException(exception.getMessage(), (Throwable)exception);
                    OnExceptionContext context = new OnExceptionContext();
                    context.setTopic(cloudEvent.getSubject());
                    context.setException(onsEx);
                    sendCallback.onException(context);
                } else {
                    SendResult sendResult = new SendResult();
                    sendResult.setTopic(cloudEvent.getSubject());
                    sendResult.setMessageId(cloudEvent.getId());
                    sendCallback.onSuccess(sendResult);
                }
            });
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", cloudEvent), (Throwable)e);
        }
    }
}

