/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.selector;

import com.alibaba.nacos.api.selector.client.Selector;
import com.alibaba.nacos.client.selector.ListenerInvoker;
import com.alibaba.nacos.common.notify.Event;
import java.util.Objects;

public abstract class AbstractSelectorWrapper<S extends Selector<?, ?>, E, T extends Event> {
    private final S selector;
    private final ListenerInvoker<E> listener;

    public AbstractSelectorWrapper(S selector, ListenerInvoker<E> listener) {
        this.selector = selector;
        this.listener = listener;
    }

    protected abstract boolean isSelectable(T var1);

    protected abstract boolean isCallable(E var1);

    protected abstract E buildListenerEvent(T var1);

    public void notifyListener(T event) {
        if (!this.isSelectable(event)) {
            return;
        }
        E newEvent = this.buildListenerEvent(event);
        if (this.isCallable(newEvent)) {
            this.listener.invoke(newEvent);
        }
    }

    public ListenerInvoker<E> getListener() {
        return this.listener;
    }

    public S getSelector() {
        return this.selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSelectorWrapper that = (AbstractSelectorWrapper)o;
        return Objects.equals(this.selector, that.selector) && Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.listener);
    }
}

