/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc.stream;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamExecutor<ReqT> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ExecutorService executor;

    public StreamExecutor(ExecutorService executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public Future<?> execute(Runnable runnable) {
        this.logger.info("stream execute {}", (Object)runnable);
        try {
            return this.executor.submit(runnable);
        }
        catch (RejectedExecutionException reject) {
            this.logger.error("stream job rejected {}", (Object)runnable, (Object)reject);
            return null;
        }
    }

    public String toString() {
        return "StreamExecutor{}";
    }
}

