/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamEventListener;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamJob;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultStreamEventListener<ReqT>
implements StreamEventListener<ReqT> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Reconnector reconnector;
    private final StreamJob<ReqT> streamJob;
    private volatile Future<?> handle;

    public DefaultStreamEventListener(Reconnector reconnector, StreamJob<ReqT> streamJob) {
        this.reconnector = Objects.requireNonNull(reconnector, "reconnector");
        this.streamJob = Objects.requireNonNull(streamJob, "streamTask");
    }

    @Override
    public void start(ClientCallStreamObserver<ReqT> requestStream) {
        this.handle = this.streamJob.start(requestStream);
        this.reconnector.reset();
    }

    @Override
    public void onError(Throwable t) {
        Future<?> handle = this.handle;
        if (handle != null) {
            handle.cancel(true);
        }
        this.reconnector.reconnect();
    }

    @Override
    public void onCompleted() {
        Future<?> handle = this.handle;
        if (handle != null) {
            handle.cancel(true);
        }
        this.reconnector.reconnect();
    }

    public String toString() {
        return "DefaultStreamEventListener{" + this.streamJob + '}';
    }
}

