/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.common.util.MathUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingSampler
implements Sampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final int samplingRate;

    public CountingSampler(int samplingRate) {
        if (samplingRate <= 0) {
            throw new IllegalArgumentException("Invalid samplingRate " + samplingRate);
        }
        this.samplingRate = samplingRate;
    }

    public boolean isSampling() {
        int samplingCount = this.counter.getAndIncrement();
        int isSampling = MathUtils.floorMod((int)samplingCount, (int)this.samplingRate);
        return isSampling == 0;
    }

    public String toString() {
        return "SamplingRateSampler{counter=" + this.counter + "samplingRate=" + this.samplingRate + '}';
    }
}

