/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classreading;

import com.navercorp.pinpoint.profiler.instrument.classreading.SimpleClassMetadata;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.util.Collections;
import java.util.List;

public class DefaultSimpleClassMetadata
implements SimpleClassMetadata {
    private final int version;
    private final int accessFlag;
    private final String className;
    private final String superClassName;
    private final List<String> interfaceNames;
    private final byte[] classBinary;

    public DefaultSimpleClassMetadata(int version, int accessFlag, String classInternalName, String superClassInternalName, List<String> interfaceInternalNames, byte[] classBinary) {
        this.version = version;
        this.accessFlag = accessFlag;
        this.className = JavaAssistUtils.jvmNameToJavaName(classInternalName);
        this.superClassName = this.defaultSuperClassName(superClassInternalName);
        this.interfaceNames = this.defaultInterfaceName(interfaceInternalNames);
        this.classBinary = classBinary;
    }

    private String defaultSuperClassName(String superClassInternalName) {
        if (superClassInternalName == null) {
            return null;
        }
        return JavaAssistUtils.jvmNameToJavaName(superClassInternalName);
    }

    private List<String> defaultInterfaceName(List<String> interfaceInternalNames) {
        if (interfaceInternalNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(JavaAssistUtils.jvmNameToJavaName(interfaceInternalNames));
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public List<String> getInterfaceNames() {
        return this.interfaceNames;
    }

    @Override
    public byte[] getClassBinary() {
        return this.classBinary;
    }
}

