/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.cpu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.UnsupportedMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.cpu.DefaultCpuLoadMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import java.util.Objects;

public class CpuLoadMetricCollectorProvider
implements Provider<AgentStatMetricCollector<CpuLoadMetricSnapshot>> {
    private final CpuLoadMetric cpuLoadMetric;

    @Inject
    public CpuLoadMetricCollectorProvider(CpuLoadMetric cpuLoadMetric) {
        this.cpuLoadMetric = Objects.requireNonNull(cpuLoadMetric, "cpuLoadMetric");
    }

    public AgentStatMetricCollector<CpuLoadMetricSnapshot> get() {
        if (this.cpuLoadMetric == CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC) {
            return new UnsupportedMetricCollector<CpuLoadMetricSnapshot>();
        }
        return new DefaultCpuLoadMetricCollector(this.cpuLoadMetric);
    }
}

