/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.DebugTransformerClassInjector;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.profiler.instrument.transformer.BypassLambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.DebugTransformer;
import com.navercorp.pinpoint.profiler.instrument.transformer.DebugTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultLambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.LambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.MatchableTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.plugin.PluginInstrumentContext;
import com.navercorp.pinpoint.profiler.transformer.DefaultClassFileTransformerDispatcher;
import com.navercorp.pinpoint.profiler.transformer.DelegateTransformerRegistry;
import com.navercorp.pinpoint.profiler.transformer.DynamicTransformerRegistry;
import com.navercorp.pinpoint.profiler.transformer.PinpointClassFilter;
import com.navercorp.pinpoint.profiler.transformer.UnmodifiableClassFilter;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassFileTransformerProvider
implements Provider<ClassFileTransformer> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final InstrumentConfig instrumentConfig;
    private final InstrumentMatcherCacheConfig instrumentMatcherCacheConfig;
    private final PluginContextLoadResult pluginContextLoadResult;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final DynamicTransformerRegistry dynamicTransformerRegistry;

    @Inject
    public ClassFileTransformerProvider(ProfilerConfig profilerConfig, InstrumentConfig instrumentConfig, InstrumentMatcherCacheConfig instrumentMatcherCacheConfig, InstrumentEngine instrumentEngine, PluginContextLoadResult pluginContextLoadResult, DynamicTransformTrigger dynamicTransformTrigger, DynamicTransformerRegistry dynamicTransformerRegistry) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.instrumentConfig = Objects.requireNonNull(instrumentConfig, "instrumentConfig");
        this.instrumentMatcherCacheConfig = Objects.requireNonNull(instrumentMatcherCacheConfig, "instrumentMatcherCacheConfig");
        this.instrumentEngine = Objects.requireNonNull(instrumentEngine, "instrumentEngine");
        this.pluginContextLoadResult = Objects.requireNonNull(pluginContextLoadResult, "pluginContextLoadResult");
        this.dynamicTransformTrigger = Objects.requireNonNull(dynamicTransformTrigger, "dynamicTransformTrigger");
        this.dynamicTransformerRegistry = Objects.requireNonNull(dynamicTransformerRegistry, "dynamicTransformerRegistry");
    }

    public ClassFileTransformer get() {
        LambdaClassFileResolver lambdaClassFileResolver = this.newLambdaClassFileResolver(this.instrumentConfig.isSupportLambdaExpressions());
        TransformerRegistry transformerRegistry = this.newTransformerRegistry();
        String classFilterBasePackage = StringUtils.defaultString((String)this.instrumentConfig.getPinpointBasePackage(), (String)"com/navercorp/pinpoint/");
        List<String> excludeSub = StringUtils.tokenizeToStringList((String)this.instrumentConfig.getPinpointExcludeSubPackage(), (String)",");
        if (excludeSub.isEmpty()) {
            excludeSub = PinpointClassFilter.DEFAULT_EXCLUDES;
        }
        PinpointClassFilter pinpointClassFilter = new PinpointClassFilter(classFilterBasePackage, excludeSub);
        List<String> allowJdkClassName = this.instrumentConfig.getAllowJdkClassName();
        UnmodifiableClassFilter unmodifiableFilter = new UnmodifiableClassFilter(allowJdkClassName);
        return new DefaultClassFileTransformerDispatcher(pinpointClassFilter, unmodifiableFilter, transformerRegistry, this.dynamicTransformerRegistry, lambdaClassFileResolver);
    }

    private TransformerRegistry newTransformerRegistry() {
        List<MatchableClassFileTransformer> matchableClassFileTransformerList = this.getMatchableTransformers(this.pluginContextLoadResult);
        TransformerRegistry transformerRegistry = this.newDefaultTransformerRegistry(matchableClassFileTransformerList);
        TransformerRegistry debugTransformerRegistry = this.newDebugTransformerRegistry();
        return new DelegateTransformerRegistry(transformerRegistry, debugTransformerRegistry);
    }

    private TransformerRegistry newDebugTransformerRegistry() {
        DebugTransformer debugTransformer = this.newDebugTransformer(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger);
        Filter<String> debugTargetFilter = this.instrumentConfig.getProfilableClassFilter();
        return new DebugTransformerRegistry(debugTargetFilter, debugTransformer);
    }

    private DebugTransformer newDebugTransformer(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger) {
        DebugTransformerClassInjector classInjector = new DebugTransformerClassInjector();
        ClassFileTransformerLoader transformerRegistry = new ClassFileTransformerLoader(profilerConfig, dynamicTransformTrigger);
        PluginInstrumentContext debugContext = new PluginInstrumentContext(profilerConfig, instrumentEngine, dynamicTransformTrigger, classInjector, transformerRegistry);
        return new DebugTransformer(instrumentEngine, debugContext);
    }

    private LambdaClassFileResolver newLambdaClassFileResolver(boolean isSupportLambdaExpressions) {
        if (isSupportLambdaExpressions) {
            return new DefaultLambdaClassFileResolver();
        }
        return new BypassLambdaClassFileResolver();
    }

    private TransformerRegistry newDefaultTransformerRegistry(List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        if (this.instrumentMatcherCacheConfig.isInstrumentMatcherEnable()) {
            return new MatchableTransformerRegistry(this.instrumentMatcherCacheConfig, matchableClassFileTransformerList);
        }
        return new DefaultTransformerRegistry(matchableClassFileTransformerList);
    }

    private List<MatchableClassFileTransformer> getMatchableTransformers(PluginContextLoadResult pluginContexts) {
        Objects.requireNonNull(pluginContexts, "pluginContexts");
        ArrayList<MatchableClassFileTransformer> matcherList = new ArrayList<MatchableClassFileTransformer>();
        for (ClassFileTransformer transformer : pluginContexts.getClassFileTransformer()) {
            if (transformer instanceof MatchableClassFileTransformer) {
                MatchableClassFileTransformer t = (MatchableClassFileTransformer)transformer;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registering class file transformer {} for {} ", (Object)t, (Object)t.getMatcher());
                }
                matcherList.add(t);
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Ignore class file transformer {}", (Object)transformer);
        }
        return matcherList;
    }
}

