/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.grpc.trace.PExceptionMetaData;
import com.navercorp.pinpoint.grpc.trace.PStackTraceElement;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionMetaData;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ExceptionMetaDataMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.TraceIdMapStructUtils;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;

public class ExceptionMetaDataMapperImpl
implements ExceptionMetaDataMapper {
    @Override
    public PExceptionMetaData toProto(ExceptionMetaData model) {
        TraceId traceId;
        if (model == null) {
            return null;
        }
        PExceptionMetaData.Builder pExceptionMetaData = this.getpExceptionMetaDataBuilder();
        if (model.getExceptionWrappers() != null) {
            for (ExceptionWrapper exceptionWrapper : model.getExceptionWrappers()) {
                pExceptionMetaData.addExceptions(this.toProto(exceptionWrapper));
            }
        }
        if ((traceId = this.modelTraceRootTraceId(model)) != null) {
            pExceptionMetaData.setTransactionId(TraceIdMapStructUtils.newTransactionId(traceId));
        }
        pExceptionMetaData.setSpanId(this.modelTraceRootTraceIdSpanId(model));
        String uriTemplate = this.modelTraceRootSharedUriTemplate(model);
        if (uriTemplate != null) {
            pExceptionMetaData.setUriTemplate(uriTemplate);
        }
        return pExceptionMetaData.build();
    }

    @Override
    public PStackTraceElement toProto(StackTraceElement model) {
        if (model == null) {
            return null;
        }
        PStackTraceElement.Builder pStackTraceElement = this.getpStackTraceElementBuilder();
        if (model.getClassName() != null) {
            pStackTraceElement.setClassName(model.getClassName());
        } else {
            pStackTraceElement.setClassName("");
        }
        if (model.getFileName() != null) {
            pStackTraceElement.setFileName(model.getFileName());
        } else {
            pStackTraceElement.setFileName("");
        }
        pStackTraceElement.setLineNumber(model.getLineNumber());
        if (model.getMethodName() != null) {
            pStackTraceElement.setMethodName(model.getMethodName());
        } else {
            pStackTraceElement.setMethodName("");
        }
        return pStackTraceElement.build();
    }

    private TraceId modelTraceRootTraceId(ExceptionMetaData exceptionMetaData) {
        if (exceptionMetaData == null) {
            return null;
        }
        TraceRoot traceRoot = exceptionMetaData.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return null;
        }
        return traceId;
    }

    private long modelTraceRootTraceIdSpanId(ExceptionMetaData exceptionMetaData) {
        if (exceptionMetaData == null) {
            return 0L;
        }
        TraceRoot traceRoot = exceptionMetaData.getTraceRoot();
        if (traceRoot == null) {
            return 0L;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0L;
        }
        long spanId = traceId.getSpanId();
        return spanId;
    }

    private String modelTraceRootSharedUriTemplate(ExceptionMetaData exceptionMetaData) {
        if (exceptionMetaData == null) {
            return null;
        }
        TraceRoot traceRoot = exceptionMetaData.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return null;
        }
        String uriTemplate = shared.getUriTemplate();
        if (uriTemplate == null) {
            return null;
        }
        return uriTemplate;
    }
}

