/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.SinkConfig;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);

    public static Config parse(Class<? extends Config> c) throws Exception {
        if (c == null) {
            return null;
        }
        if (ConfigUtil.isSourceConfig(c)) {
            return ConfigUtil.parseSourceConfig(c);
        }
        if (ConfigUtil.isSinkConfig(c)) {
            return ConfigUtil.parseSinkConfig(c);
        }
        throw new RuntimeException("illegal config, parse config error");
    }

    public static <T> T parse(Class<T> c, String filePathName) throws Exception {
        ObjectMapper objectMapper = filePathName.endsWith("json") ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        File file = new File(filePathName);
        if (file.exists()) {
            return (T)objectMapper.readValue(file, c);
        }
        URL url = ConfigUtil.class.getClassLoader().getResource(filePathName);
        if (url == null) {
            throw new FileNotFoundException(filePathName);
        }
        return (T)objectMapper.readValue(url, c);
    }

    public static <T> T parse(Map<String, Object> map, Class<T> c) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.convertValue(map, c);
    }

    private static Config parseSourceConfig(Class<? extends Config> c) throws Exception {
        String configFile = System.getProperty("sourceConnectorConf", System.getenv("sourceConnectorConf"));
        if (configFile == null || configFile.isEmpty()) {
            configFile = "source-config.yml";
        }
        return ConfigUtil.parse(c, configFile);
    }

    private static Config parseSinkConfig(Class<? extends Config> c) throws Exception {
        String configFile = System.getProperty("sinkConnectorConf", System.getenv("sinkConnectorConf"));
        if (configFile == null || configFile.isEmpty()) {
            configFile = "sink-config.yml";
        }
        return ConfigUtil.parse(c, configFile);
    }

    public static boolean isSinkConfig(Class<?> c) {
        if (c != null && c != Object.class) {
            return SinkConfig.class.isAssignableFrom(c);
        }
        return false;
    }

    public static boolean isSourceConfig(Class<?> c) {
        if (c != null && c != Object.class) {
            return SourceConfig.class.isAssignableFrom(c);
        }
        return false;
    }
}

