/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import java.util.Arrays;

public class MethodFilters {
    public static final int SYNTHETIC = 4096;
    public static final MethodFilter ACCEPT_ALL = new MethodFilter(){

        @Override
        public boolean accept(InstrumentMethod method) {
            return true;
        }
    };

    private MethodFilters() {
    }

    public static MethodFilter name(String ... names) {
        return new MethodNameFilter(null, names, false);
    }

    public static MethodFilter nameExclude(String ... names) {
        return new MethodNameFilter(null, names, true);
    }

    public static MethodFilter modifier(int required) {
        return MethodFilters.modifier(required, 0);
    }

    public static MethodFilter modifierNot(int rejected) {
        return MethodFilters.modifier(0, rejected);
    }

    public static MethodFilter modifier(int required, int rejected) {
        return new ModifierFilter(required, rejected);
    }

    public static MethodFilter argAt(int index, String type) {
        return new ArgAtFilter(index, type);
    }

    public static MethodFilter args(String ... types) {
        return new ArgsFilter(types);
    }

    public static MethodFilter chain(MethodFilter ... methodFilters) {
        return new ChainFilter(methodFilters);
    }

    private static final class ChainFilter
    implements MethodFilter {
        private final MethodFilter[] methodFilters;

        public ChainFilter(MethodFilter[] methodFilters) {
            this.methodFilters = methodFilters;
        }

        @Override
        public boolean accept(InstrumentMethod method) {
            if (this.methodFilters == null) {
                return false;
            }
            for (MethodFilter methodFilter : this.methodFilters) {
                if (methodFilter != null && methodFilter.accept(method)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "ChainFilter{methodFilters=" + Arrays.toString(this.methodFilters) + '}';
        }
    }

    private static final class ArgsFilter
    implements MethodFilter {
        private final String[] types;

        public ArgsFilter(String[] types) {
            this.types = types;
        }

        @Override
        public boolean accept(InstrumentMethod method) {
            Object[] paramTypes = method.getParameterTypes();
            return Arrays.equals(paramTypes, this.types);
        }

        public String toString() {
            return "ArgsFilter{types=" + Arrays.toString(this.types) + '}';
        }
    }

    private static final class ArgAtFilter
    implements MethodFilter {
        private final int index;
        private final String type;

        public ArgAtFilter(int index, String type) {
            this.index = index;
            this.type = type;
        }

        @Override
        public boolean accept(InstrumentMethod method) {
            String[] paramTypes = method.getParameterTypes();
            if (paramTypes.length < this.index + 1) {
                return false;
            }
            return this.type != null && this.type.equals(paramTypes[this.index]);
        }

        public String toString() {
            return "ArgAtFilter{index=" + this.index + ", type='" + this.type + '\'' + '}';
        }
    }

    private static final class ModifierFilter
    implements MethodFilter {
        private final int required;
        private final int rejected;

        public ModifierFilter(int required, int rejected) {
            this.required = required;
            this.rejected = rejected;
        }

        @Override
        public boolean accept(InstrumentMethod method) {
            int modifier = method.getModifiers();
            return (this.required & modifier) == this.required && (this.rejected & modifier) == 0;
        }

        public String toString() {
            return "ModifierFilter{required=" + this.required + ", rejected=" + this.rejected + '}';
        }
    }

    private static final class MethodNameFilter
    implements MethodFilter {
        private final String[] names;
        private final boolean inverter;

        public MethodNameFilter(int[] rejectModifiers, String[] names, boolean inverter) {
            this.names = names;
            this.inverter = inverter;
        }

        @Override
        public boolean accept(InstrumentMethod method) {
            if (this.names == null) {
                return false;
            }
            for (String name : this.names) {
                if (name == null || !name.equals(method.getName())) continue;
                return true ^ this.inverter;
            }
            return false ^ this.inverter;
        }

        public String toString() {
            return "MethodNameFilter{names=" + Arrays.toString(this.names) + ", inverter=" + this.inverter + '}';
        }
    }
}

