/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.BootLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;

final class LauncherBootLoader
implements BootLoader {
    private final URLClassPath bootstrapClassPath = LauncherBootLoader.getBootstrapClassPath();
    private static final Method FIND_BOOTSTRAP_CLASS_OR_NULL = LauncherBootLoader.findBootstrapClassOrNullMethod();

    private static Method findBootstrapClassOrNullMethod() {
        try {
            Method findBootstrapClassOrNull = ClassLoader.class.getDeclaredMethod("findBootstrapClassOrNull", String.class);
            findBootstrapClassOrNull.setAccessible(true);
            return findBootstrapClassOrNull;
        }
        catch (NoSuchMethodException ex) {
            NoSuchMethodException rootException = ex;
            try {
                Method findBootstrapClass0 = ClassLoader.class.getDeclaredMethod("findBootstrapClass0", String.class);
                findBootstrapClass0.setAccessible(true);
                return findBootstrapClass0;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("ClassLoader.findBootstrapClassOrNull api not found", rootException);
            }
        }
    }

    LauncherBootLoader() {
    }

    private static URLClassPath getBootstrapClassPath() {
        return Launcher.getBootstrapClassPath();
    }

    @Override
    public URL findResource(String name) {
        Resource res = this.bootstrapClassPath.getResource(name);
        if (res == null) {
            return null;
        }
        return res.getURL();
    }

    @Override
    public Class<?> findBootstrapClassOrNull(ClassLoader classLoader, String name) {
        try {
            return (Class)FIND_BOOTSTRAP_CLASS_OR_NULL.invoke((Object)classLoader, name);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(FIND_BOOTSTRAP_CLASS_OR_NULL.getName() + "() access fail " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ClassNotFoundException) {
                return null;
            }
            throw new IllegalStateException(FIND_BOOTSTRAP_CLASS_OR_NULL.getName() + "() internal error " + ex.getMessage(), ex);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enumeration = this.bootstrapClassPath.getResources(name);
        return new URLEnumeration(enumeration);
    }

    static {
        new URLEnumeration(null);
    }

    private static class URLEnumeration
    implements Enumeration<URL> {
        private final Enumeration<Resource> enumeration;

        private URLEnumeration(Enumeration<Resource> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public URL nextElement() {
            Resource resource = this.enumeration.nextElement();
            return resource.getURL();
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }
    }
}

