/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.service.verify;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.stub.StreamObserver;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.eventmesh.common.enums.ConnectorStage;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.request.ReportVerifyRequest;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.runtime.connector.ConnectorRuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyService.class);
    private final ExecutorService reportVerifyExecutor;
    private StreamObserver<Payload> requestObserver;
    private StreamObserver<Payload> responseObserver;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;
    private ConnectorRuntimeConfig connectorRuntimeConfig;

    public VerifyService(AdminServiceGrpc.AdminServiceStub adminServiceStub, AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub, ConnectorRuntimeConfig connectorRuntimeConfig) {
        this.adminServiceStub = adminServiceStub;
        this.adminServiceBlockingStub = adminServiceBlockingStub;
        this.connectorRuntimeConfig = connectorRuntimeConfig;
        this.reportVerifyExecutor = Executors.newSingleThreadExecutor();
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.debug("verify service receive message: {}|{} ", (Object)response.getMetadata(), (Object)response.getBody());
            }

            public void onError(Throwable t) {
                log.error("verify service receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("verify service finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
    }

    public void reportVerifyRequest(ConnectRecord record, ConnectorStage connectorStage) {
        this.reportVerifyExecutor.submit(() -> {
            try {
                byte[] data = (byte[])record.getData();
                String md5Str = this.md5(Arrays.toString(data) + record.getExtension("recordUniqueId"));
                ReportVerifyRequest reportVerifyRequest = new ReportVerifyRequest();
                reportVerifyRequest.setTaskID(this.connectorRuntimeConfig.getTaskID());
                reportVerifyRequest.setJobID(this.connectorRuntimeConfig.getJobID());
                reportVerifyRequest.setRecordID(record.getExtension("recordUniqueId"));
                reportVerifyRequest.setRecordSig(md5Str);
                reportVerifyRequest.setConnectorName(IPUtils.getLocalAddress() + "_" + this.connectorRuntimeConfig.getJobID() + "_" + this.connectorRuntimeConfig.getRegion());
                reportVerifyRequest.setConnectorStage(connectorStage.name());
                reportVerifyRequest.setPosition(JsonUtils.toJSONString((Object)record.getPosition()));
                Metadata metadata = Metadata.newBuilder().setType(ReportVerifyRequest.class.getSimpleName()).build();
                Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)reportVerifyRequest)))).build()).build();
                this.requestObserver.onNext((Object)request);
            }
            catch (Exception e) {
                log.error("Failed to report verify request", (Throwable)e);
            }
        });
    }

    private String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : messageDigest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.reportVerifyExecutor.shutdown();
        if (this.requestObserver != null) {
            this.requestObserver.onCompleted();
        }
    }
}

