/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.registry.QueryInstances;
import org.apache.eventmesh.registry.RegisterServerInfo;
import org.apache.eventmesh.registry.RegistryFactory;
import org.apache.eventmesh.registry.RegistryService;
import org.apache.eventmesh.runtime.Runtime;
import org.apache.eventmesh.runtime.RuntimeFactory;
import org.apache.eventmesh.runtime.RuntimeInstanceConfig;
import org.apache.eventmesh.runtime.connector.ConnectorRuntimeFactory;
import org.apache.eventmesh.runtime.function.FunctionRuntimeFactory;
import org.apache.eventmesh.runtime.mesh.MeshRuntimeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeInstance.class);
    private String adminServiceAddr;
    private Map<String, RegisterServerInfo> adminServerInfoMap = new HashMap<String, RegisterServerInfo>();
    private RegistryService registryService;
    private Runtime runtime;
    private RuntimeFactory runtimeFactory;
    private final RuntimeInstanceConfig runtimeInstanceConfig;
    private volatile boolean isStarted = false;

    public RuntimeInstance(RuntimeInstanceConfig runtimeInstanceConfig) {
        this.runtimeInstanceConfig = runtimeInstanceConfig;
        if (runtimeInstanceConfig.isRegistryEnabled()) {
            this.registryService = RegistryFactory.getInstance((String)runtimeInstanceConfig.getRegistryPluginType());
        }
    }

    public void init() throws Exception {
        if (this.registryService != null) {
            this.registryService.init();
            QueryInstances queryInstances = new QueryInstances();
            queryInstances.setServiceName(this.runtimeInstanceConfig.getAdminServiceName());
            queryInstances.setHealth(true);
            List adminServerRegisterInfoList = this.registryService.selectInstances(queryInstances);
            if (adminServerRegisterInfoList.isEmpty()) {
                throw new RuntimeException("admin server address is empty, please check");
            }
            this.adminServiceAddr = this.getRandomAdminServerAddr(adminServerRegisterInfoList);
            this.runtimeInstanceConfig.setAdminServiceAddr(this.adminServiceAddr);
        } else {
            this.adminServiceAddr = this.runtimeInstanceConfig.getAdminServiceAddr();
        }
        this.runtimeFactory = this.initRuntimeFactory(this.runtimeInstanceConfig);
        this.runtime = this.runtimeFactory.createRuntime(this.runtimeInstanceConfig);
        this.runtime.init();
    }

    public void start() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.adminServiceAddr)) {
            throw new RuntimeException("admin server address is empty, please check");
        }
        if (this.registryService != null) {
            this.registryService.subscribe(event -> {
                log.info("runtime receive registry event: {}", (Object)event);
                List registerServerInfoList = event.getInstances();
                HashMap<String, RegisterServerInfo> registerServerInfoMap = new HashMap<String, RegisterServerInfo>();
                for (RegisterServerInfo registerServerInfo : registerServerInfoList) {
                    registerServerInfoMap.put(registerServerInfo.getAddress(), registerServerInfo);
                }
                if (!registerServerInfoMap.isEmpty()) {
                    this.adminServerInfoMap = registerServerInfoMap;
                    this.updateAdminServerAddr();
                }
            }, this.runtimeInstanceConfig.getAdminServiceName());
        }
        this.runtime.start();
        this.isStarted = true;
    }

    public void shutdown() throws Exception {
        this.runtime.stop();
    }

    private void updateAdminServerAddr() throws Exception {
        if (this.isStarted) {
            if (!this.adminServerInfoMap.containsKey(this.adminServiceAddr)) {
                this.adminServiceAddr = this.getRandomAdminServerAddr(this.adminServerInfoMap);
                log.info("admin server address changed to: {}", (Object)this.adminServiceAddr);
                this.shutdown();
                this.start();
            }
        } else {
            this.adminServiceAddr = this.getRandomAdminServerAddr(this.adminServerInfoMap);
        }
    }

    private String getRandomAdminServerAddr(Map<String, RegisterServerInfo> adminServerInfoMap) {
        ArrayList<String> addresses = new ArrayList<String>(adminServerInfoMap.keySet());
        Random random = new Random();
        int randomIndex = random.nextInt(addresses.size());
        return addresses.get(randomIndex);
    }

    private String getRandomAdminServerAddr(List<RegisterServerInfo> adminServerRegisterInfoList) {
        Random random = new Random();
        int randomIndex = random.nextInt(adminServerRegisterInfoList.size());
        return adminServerRegisterInfoList.get(randomIndex).getAddress();
    }

    private RuntimeFactory initRuntimeFactory(RuntimeInstanceConfig runtimeInstanceConfig) {
        switch (runtimeInstanceConfig.getComponentType()) {
            case CONNECTOR: {
                return new ConnectorRuntimeFactory();
            }
            case FUNCTION: {
                return new FunctionRuntimeFactory();
            }
            case MESH: {
                return new MeshRuntimeFactory();
            }
        }
        throw new RuntimeException("unsupported runtime type: " + runtimeInstanceConfig.getComponentType());
    }
}

